/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver;

import java.awt.print.Paper;
import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PlaintextDataChunk;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PrinterDriver;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;

public class PlainTextPage {
    private PlaintextDataChunk[][] pageBuffer;
    private PrinterDriver driver;
    private int width;
    private int height;
    private Paper paper;
    private String defaultEncoding;

    public PlainTextPage(Paper pageFormat, PrinterDriver driver, String defaultEncoding) {
        if (driver == null) {
            throw new NullPointerException("PrinterCommandSet must be defined.");
        }
        if (pageFormat == null) {
            throw new NullPointerException("PageFormat must be defined.");
        }
        if (defaultEncoding == null) {
            throw new NullPointerException("DefaultEncoding must be defined.");
        }
        float characterWidthInPoint = 72.0f / driver.getCharactersPerInch();
        float characterHeightInPoint = 72.0f / driver.getLinesPerInch();
        int currentPageHeight = PlainTextPage.correctedDivisionFloor((float)pageFormat.getImageableHeight(), characterHeightInPoint);
        int currentPageWidth = PlainTextPage.correctedDivisionFloor((float)pageFormat.getImageableWidth(), characterWidthInPoint);
        this.pageBuffer = new PlaintextDataChunk[currentPageWidth][currentPageHeight];
        this.width = currentPageWidth;
        this.height = currentPageHeight;
        this.paper = pageFormat;
        this.driver = driver;
        this.defaultEncoding = defaultEncoding;
    }

    public static int correctedDivisionFloor(float c, float d) {
        c = Math.round(c * 100.0f);
        d = Math.round(d * 100.0f);
        return (int)Math.floor(c / d);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void addTextChunk(int x, int y, int w, String text, StyleSheet format) {
        if (text.length() == 0) {
            return;
        }
        if (x < 0) {
            throw new IllegalArgumentException("X < 0: " + x);
        }
        if (y < 0) {
            throw new IllegalArgumentException("y < 0: " + y);
        }
        if (w < 0) {
            throw new IllegalArgumentException("w < 0 " + w);
        }
        if (x + w > this.width) {
            throw new IllegalArgumentException("X+W [" + (x + w) + "] > bufferWidth [" + this.width + ']');
        }
        if (y >= this.height) {
            throw new IllegalArgumentException("Y > bufferHeight: " + text + " y=" + y + " h=" + this.height);
        }
        String font = (String)format.getStyleProperty(TextStyleKeys.FONT);
        boolean bold = format.getBooleanStyleProperty(TextStyleKeys.BOLD);
        boolean italic = format.getBooleanStyleProperty(TextStyleKeys.ITALIC);
        boolean underline = format.getBooleanStyleProperty(TextStyleKeys.UNDERLINED);
        boolean strikethrough = format.getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH);
        PlaintextDataChunk chunk = new PlaintextDataChunk(text, font, bold, italic, underline, strikethrough, x, y, w);
        for (int i = 0; i < w; ++i) {
            if (this.pageBuffer[x + i][y] != null) continue;
            this.pageBuffer[x + i][y] = chunk;
        }
    }

    private PlaintextDataChunk getChunk(int x, int y) {
        return this.pageBuffer[x][y];
    }

    public void writePage() throws IOException {
        this.driver.startPage(this.paper, this.defaultEncoding);
        for (int y = 0; y < this.height; ++y) {
            this.driver.startLine();
            int emptyChunkCount = 0;
            boolean overflow = false;
            for (int x = 0; x < this.width; ++x) {
                PlaintextDataChunk chunk = this.getChunk(x, y);
                if (chunk == null) {
                    ++emptyChunkCount;
                    continue;
                }
                if (chunk.getX() != x) continue;
                if (emptyChunkCount != 0) {
                    this.driver.printEmptyChunk(emptyChunkCount);
                    emptyChunkCount = 0;
                }
                this.driver.printChunk(chunk);
                if ((x += chunk.getWidth() - 1) != this.width - 1) continue;
                overflow = true;
            }
            if (y == this.height - 1) {
                this.driver.endPage(overflow);
                continue;
            }
            this.driver.endLine(overflow);
        }
        this.driver.flush();
    }
}

