/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper;

import java.util.HashMap;
import java.util.HashSet;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterEncoding;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterSpecification;

public class DefaultPrinterSpecification
implements PrinterSpecification,
Cloneable {
    private String name;
    private String displayName;
    private HashMap encodings;
    private HashSet operations;
    private PrinterEncoding[] encodingsCached;

    public DefaultPrinterSpecification(String name, String displayName) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (displayName == null) {
            throw new NullPointerException();
        }
        this.encodings = new HashMap();
        this.operations = new HashSet();
        this.name = name;
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEncodingSupported(String encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        return this.encodings.containsKey(encoding.toLowerCase());
    }

    public boolean contains(PrinterEncoding encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        return this.encodings.containsValue(encoding);
    }

    public PrinterEncoding getEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        PrinterEncoding enc = (PrinterEncoding)this.encodings.get(encoding.toLowerCase());
        if (enc == null) {
            throw new IllegalArgumentException("Encoding is not supported.");
        }
        return enc;
    }

    public void addEncoding(PrinterEncoding encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        if (!this.encodings.containsKey(encoding.getEncoding())) {
            this.encodings.put(encoding.getEncoding().toLowerCase(), encoding);
            this.encodingsCached = null;
        }
    }

    public void removeEncoding(PrinterEncoding encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        if (this.encodings.remove(encoding.getEncoding().toLowerCase()) != null) {
            this.encodingsCached = null;
        }
    }

    public PrinterEncoding[] getSupportedEncodings() {
        if (this.encodingsCached == null) {
            PrinterEncoding[] encodingArray = new PrinterEncoding[this.encodings.size()];
            this.encodingsCached = this.encodings.values().toArray(encodingArray);
        }
        return this.encodingsCached;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultPrinterSpecification spec = (DefaultPrinterSpecification)super.clone();
        spec.encodings = (HashMap)this.encodings.clone();
        return spec;
    }

    public boolean isFeatureAvailable(String operationName) {
        return this.operations.contains(operationName);
    }
}

