/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.xml.internal;

import java.awt.Color;
import java.beans.PropertyEditor;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderCorner;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PhysicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContent;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.model.SpacerRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ColorValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;
import org.pentaho.reporting.libraries.formatting.FastDecimalFormat;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class XmlDocumentWriter
extends IterateStructuralProcessStep {
    private static final String LAYOUT_OUTPUT_NAMESPACE = "http://reporting.pentaho.org/namespaces/output/layout-output/pageable/1.0";
    private static final Log logger = LogFactory.getLog(XmlDocumentWriter.class);
    private OutputStream outputStream;
    private String encoding;
    private StrictBounds drawArea;
    private XmlWriter xmlWriter;
    private FastDecimalFormat pointIntConverter;
    private FastDecimalFormat pointConverter;
    private boolean ignoreEmptyBorders = true;
    private OutputProcessorMetaData metaData;

    public XmlDocumentWriter(OutputStream outputStream, OutputProcessorMetaData metaData) {
        this.metaData = metaData;
        if (outputStream == null) {
            throw new NullPointerException();
        }
        this.outputStream = outputStream;
        this.pointConverter = new FastDecimalFormat("0.####", Locale.US);
        this.pointIntConverter = new FastDecimalFormat("0", Locale.US);
    }

    public void open() throws IOException {
        DefaultTagDescription td = new DefaultTagDescription();
        td.addDefaultDefinition(LAYOUT_OUTPUT_NAMESPACE, false);
        td.addTagDefinition(LAYOUT_OUTPUT_NAMESPACE, "text", true);
        String encoding = this.metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.xml.Encoding", EncodingRegistry.getPlatformDefaultEncoding());
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, encoding));
        this.xmlWriter = new XmlWriter((Writer)writer, (TagDescription)td);
        this.xmlWriter.writeXmlDeclaration(encoding);
        AttributeList attrs = new AttributeList();
        attrs.addNamespaceDeclaration("", LAYOUT_OUTPUT_NAMESPACE);
        this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "layout-output", attrs, false);
    }

    public void close() throws IOException {
        this.xmlWriter.writeCloseTag();
        this.xmlWriter.close();
    }

    public void processPhysicalPage(PageGrid pageGrid, LogicalPageBox logicalPage, int row, int col) throws IOException {
        PhysicalPageBox page = pageGrid.getPage(row, col);
        if (page == null) {
            return;
        }
        float width = (float)StrictGeomUtility.toExternalValue(page.getWidth());
        float height = (float)StrictGeomUtility.toExternalValue(page.getHeight());
        float marginLeft = (float)StrictGeomUtility.toExternalValue(page.getImageableX());
        float marginRight = (float)StrictGeomUtility.toExternalValue(page.getWidth() - page.getImageableWidth() - page.getImageableX());
        float marginTop = (float)StrictGeomUtility.toExternalValue(page.getImageableY());
        float marginBottom = (float)StrictGeomUtility.toExternalValue(page.getHeight() - page.getImageableHeight() - page.getImageableY());
        AttributeList pageAttributes = new AttributeList();
        pageAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "page-x", this.pointConverter.format((Object)page.getGlobalX()));
        pageAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "page-y", this.pointConverter.format((Object)page.getGlobalY()));
        pageAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "page-width", this.pointConverter.format((Object)Float.valueOf(width)));
        pageAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "page-height", this.pointConverter.format((Object)Float.valueOf(height)));
        pageAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "margin-top", this.pointConverter.format((Object)Float.valueOf(marginTop)));
        pageAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "margin-left", this.pointConverter.format((Object)Float.valueOf(marginLeft)));
        pageAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "margin-bottom", this.pointConverter.format((Object)Float.valueOf(marginBottom)));
        pageAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "margin-right", this.pointConverter.format((Object)Float.valueOf(marginRight)));
        this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "physical-page", pageAttributes, false);
        this.drawArea = new StrictBounds(page.getGlobalX(), page.getGlobalY(), page.getImageableWidth(), page.getImageableHeight());
        this.processPage(logicalPage);
        this.xmlWriter.writeCloseTag();
    }

    public void processLogicalPage(LogicalPageKey key, LogicalPageBox logicalPage) throws IOException {
        float width = (float)StrictGeomUtility.toExternalValue(logicalPage.getPageWidth());
        float height = (float)StrictGeomUtility.toExternalValue(logicalPage.getPageHeight());
        AttributeList pageAttributes = new AttributeList();
        pageAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "logical-page-number", String.valueOf(key.getPosition()));
        pageAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "width", this.pointConverter.format((Object)Float.valueOf(width)));
        pageAttributes.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "height", this.pointConverter.format((Object)Float.valueOf(height)));
        this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "logical-page", pageAttributes, false);
        this.drawArea = new StrictBounds(0L, 0L, logicalPage.getPageWidth(), logicalPage.getPageHeight());
        this.processPage(logicalPage);
        this.xmlWriter.writeCloseTag();
    }

    protected void processPage(LogicalPageBox rootBox) {
        StrictBounds pageBounds = this.drawArea;
        this.startProcessing(rootBox.getWatermarkArea());
        BlockRenderBox headerArea = rootBox.getHeaderArea();
        BlockRenderBox footerArea = rootBox.getFooterArea();
        BlockRenderBox repeatFooterArea = rootBox.getRepeatFooterArea();
        StrictBounds headerBounds = new StrictBounds(headerArea.getX(), headerArea.getY(), headerArea.getWidth(), headerArea.getHeight());
        StrictBounds footerBounds = new StrictBounds(footerArea.getX(), footerArea.getY(), footerArea.getWidth(), footerArea.getHeight());
        StrictBounds repeatFooterBounds = new StrictBounds(repeatFooterArea.getX(), repeatFooterArea.getY(), repeatFooterArea.getWidth(), repeatFooterArea.getHeight());
        StrictBounds contentBounds = new StrictBounds(rootBox.getX(), headerArea.getY() + headerArea.getHeight(), rootBox.getWidth(), footerArea.getY() - headerArea.getHeight());
        this.drawArea = headerBounds;
        this.startProcessing(headerArea);
        this.drawArea = contentBounds;
        this.processBoxChilds(rootBox);
        this.drawArea = repeatFooterBounds;
        this.startProcessing(repeatFooterArea);
        this.drawArea = footerBounds;
        this.startProcessing(footerArea);
        this.drawArea = pageBounds;
    }

    private void writeElementAttributes(RenderNode element) throws IOException {
        ReportAttributeMap attributes = element.getAttributes();
        ElementType type = element.getElementType();
        Object[] attributeNamespaces = attributes.getNameSpaces();
        Arrays.sort(attributeNamespaces);
        for (int i = 0; i < attributeNamespaces.length; ++i) {
            Object namespace = attributeNamespaces[i];
            Object[] attributeNames = attributes.getNames((String)namespace);
            Arrays.sort(attributeNames);
            for (int j = 0; j < attributeNames.length; ++j) {
                AttributeMetaData attrMeta;
                Object name = attributeNames[j];
                Object value = attributes.getAttribute((String)namespace, (String)name);
                if (value == null || (attrMeta = type.getMetaData().getAttributeDescription((String)namespace, (String)name)) == null) continue;
                AttributeList attList = new AttributeList();
                if (value instanceof String) {
                    String s = (String)value;
                    if (StringUtils.isEmpty((String)s)) continue;
                    if (!this.xmlWriter.isNamespaceDefined((String)namespace) && !attList.isNamespaceUriDefined((String)namespace)) {
                        attList.addNamespaceDeclaration("autoGenNs", (String)namespace);
                    }
                    attList.setAttribute((String)namespace, (String)name, String.valueOf(value));
                    this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "attribute", attList, true);
                    continue;
                }
                if (!this.xmlWriter.isNamespaceDefined((String)namespace) && !attList.isNamespaceUriDefined((String)namespace)) {
                    attList.addNamespaceDeclaration("autoGenNs", (String)namespace);
                }
                try {
                    String textValue;
                    PropertyEditor propertyEditor = attrMeta.getEditor();
                    if (propertyEditor != null) {
                        propertyEditor.setValue(value);
                        textValue = propertyEditor.getAsText();
                    } else {
                        textValue = ConverterRegistry.toAttributeValue(value);
                    }
                    if (!StringUtils.isEmpty((String)textValue)) {
                        attList.setAttribute((String)namespace, (String)name, textValue);
                        this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "attribute", attList, true);
                        continue;
                    }
                    logger.warn((Object)("Attribute '" + (String)namespace + '|' + (String)name + "' is not convertible to a text - returned null"));
                    continue;
                }
                catch (BeanException e) {
                    if (!attrMeta.isTransient()) {
                        logger.warn((Object)("Attribute '" + (String)namespace + '|' + (String)name + "' is not convertible with the bean-methods"));
                        continue;
                    }
                    logger.debug((Object)("Attribute '" + (String)namespace + '|' + (String)name + "' is not convertible with the bean-methods"));
                }
            }
        }
    }

    protected final boolean isNodeVisible(RenderNode rect2) {
        long drawAreaX0 = this.drawArea.getX();
        long drawAreaY0 = this.drawArea.getY();
        long drawAreaX1 = drawAreaX0 + this.drawArea.getWidth();
        long drawAreaY1 = drawAreaY0 + this.drawArea.getHeight();
        long x = rect2.getX();
        long y = rect2.getY();
        long width = rect2.getWidth();
        long height = rect2.getHeight();
        long x2 = x + width;
        long y2 = y + height;
        if (width == 0L) {
            if (x2 < drawAreaX0) {
                return false;
            }
            if (x > drawAreaX1) {
                return false;
            }
        } else {
            if (x2 <= drawAreaX0) {
                return false;
            }
            if (x >= drawAreaX1) {
                return false;
            }
        }
        if (height == 0L) {
            if (y2 < drawAreaY0) {
                return false;
            }
            if (y > drawAreaY1) {
                return false;
            }
        } else {
            if (y2 <= drawAreaY0) {
                return false;
            }
            if (y >= drawAreaY1) {
                return false;
            }
        }
        return true;
    }

    private AttributeList createBoxAttributeList(RenderBox box) {
        Color color;
        BorderCorner bottomRight;
        BorderCorner bottomLeft;
        BorderCorner topRight;
        BorderCorner topLeft;
        BorderEdge right;
        BorderEdge bottom;
        BorderEdge left;
        AttributeList attributeList = new AttributeList();
        if (!StringUtils.isEmpty((String)box.getName())) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "name", box.getName());
        }
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "type", box.getClass().getSimpleName());
        BoxDefinition definition = box.getBoxDefinition();
        Border border = definition.getBorder();
        StaticBoxLayoutProperties sblp = box.getStaticBoxLayoutProperties();
        BorderEdge top = border.getTop();
        if (!BorderEdge.EMPTY.equals(top) || !this.ignoreEmptyBorders) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-color", this.convertColorToString(top));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-width", String.valueOf(StrictGeomUtility.toExternalValue(sblp.getBorderTop())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-style", String.valueOf(top.getBorderStyle()));
        }
        if (!BorderEdge.EMPTY.equals(left = border.getLeft()) || !this.ignoreEmptyBorders) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-left-color", this.convertColorToString(left));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-left-width", String.valueOf(StrictGeomUtility.toExternalValue(sblp.getBorderLeft())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-left-style", String.valueOf(left.getBorderStyle()));
        }
        if (!BorderEdge.EMPTY.equals(bottom = border.getBottom()) || !this.ignoreEmptyBorders) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-color", this.convertColorToString(bottom));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-width", String.valueOf(StrictGeomUtility.toExternalValue(sblp.getBorderBottom())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-style", String.valueOf(bottom.getBorderStyle()));
        }
        if (!BorderEdge.EMPTY.equals(right = border.getRight()) || !this.ignoreEmptyBorders) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-right-color", this.convertColorToString(right));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-right-width", String.valueOf(StrictGeomUtility.toExternalValue(sblp.getBorderRight())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-right-style", String.valueOf(right.getBorderStyle()));
        }
        if (!this.isEmptyCorner(topLeft = border.getTopLeft())) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-left-x", String.valueOf(StrictGeomUtility.toExternalValue(topLeft.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-left-y", String.valueOf(StrictGeomUtility.toExternalValue(topLeft.getHeight())));
        }
        if (!this.isEmptyCorner(topRight = border.getTopRight())) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-right-x", String.valueOf(StrictGeomUtility.toExternalValue(topRight.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-top-right-y", String.valueOf(StrictGeomUtility.toExternalValue(topRight.getHeight())));
        }
        if (!this.isEmptyCorner(bottomLeft = border.getBottomLeft())) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-left-x", String.valueOf(StrictGeomUtility.toExternalValue(bottomLeft.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-left-y", String.valueOf(StrictGeomUtility.toExternalValue(bottomLeft.getHeight())));
        }
        if (!this.isEmptyCorner(bottomRight = border.getBottomRight())) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-right-x", String.valueOf(StrictGeomUtility.toExternalValue(bottomRight.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "border-bottom-right-y", String.valueOf(StrictGeomUtility.toExternalValue(bottomRight.getHeight())));
        }
        if (sblp.getMarginTop() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "margin-top", String.valueOf(StrictGeomUtility.toExternalValue(sblp.getMarginTop())));
        }
        if (sblp.getMarginLeft() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "margin-left", String.valueOf(StrictGeomUtility.toExternalValue(sblp.getMarginLeft())));
        }
        if (sblp.getMarginBottom() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "margin-bottom", String.valueOf(StrictGeomUtility.toExternalValue(sblp.getMarginBottom())));
        }
        if (sblp.getMarginRight() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "margin-right", String.valueOf(StrictGeomUtility.toExternalValue(sblp.getMarginRight())));
        }
        if (definition.getPaddingTop() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "padding-top", String.valueOf(StrictGeomUtility.toExternalValue(definition.getPaddingTop())));
        }
        if (definition.getPaddingLeft() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "padding-left", String.valueOf(StrictGeomUtility.toExternalValue(definition.getPaddingLeft())));
        }
        if (definition.getPaddingBottom() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "padding-bottom", String.valueOf(StrictGeomUtility.toExternalValue(definition.getPaddingBottom())));
        }
        if (definition.getPaddingRight() > 0L) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "padding-right", String.valueOf(StrictGeomUtility.toExternalValue(definition.getPaddingRight())));
        }
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "x", String.valueOf(StrictGeomUtility.toExternalValue(box.getX())));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "y", String.valueOf(StrictGeomUtility.toExternalValue(box.getY())));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "width", String.valueOf(StrictGeomUtility.toExternalValue(box.getWidth())));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "height", String.valueOf(StrictGeomUtility.toExternalValue(box.getHeight())));
        Color backgroundColor = (Color)box.getStyleSheet().getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR);
        if (backgroundColor != null) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "background-color", ColorValueConverter.colorToString(backgroundColor));
        }
        if ((color = (Color)box.getStyleSheet().getStyleProperty(ElementStyleKeys.PAINT)) != null) {
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "color", ColorValueConverter.colorToString(color));
        }
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "font-face", (String)box.getStyleSheet().getStyleProperty(TextStyleKeys.FONT));
        Object o = box.getStyleSheet().getStyleProperty(TextStyleKeys.FONTSIZE);
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "font-size", this.pointIntConverter.format(o));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "font-style-bold", String.valueOf(box.getStyleSheet().getStyleProperty(TextStyleKeys.BOLD)));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "font-style-italics", String.valueOf(box.getStyleSheet().getStyleProperty(TextStyleKeys.ITALIC)));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "font-style-underline", String.valueOf(box.getStyleSheet().getStyleProperty(TextStyleKeys.UNDERLINED)));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "font-style-strikethrough", String.valueOf(box.getStyleSheet().getStyleProperty(TextStyleKeys.STRIKETHROUGH)));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "anchor", (String)box.getStyleSheet().getStyleProperty(ElementStyleKeys.ANCHOR_NAME));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "href", (String)box.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_TARGET));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "href-window", (String)box.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_WINDOW));
        attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "href-title", (String)box.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_TITLE));
        return attributeList;
    }

    private String convertColorToString(BorderEdge borderEdge) {
        Color o = borderEdge.getColor();
        if (o == null) {
            return null;
        }
        return ColorValueConverter.colorToString(o);
    }

    private boolean isEmptyCorner(BorderCorner corner) {
        if (!this.ignoreEmptyBorders) {
            return false;
        }
        return corner.getWidth() == 0L && corner.getHeight() == 0L;
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        try {
            if ((box.getNodeType() & 0x812) == 2066) {
                AttributeList list = this.createBoxAttributeList(box);
                list.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "type", box.getName());
                this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "page-area", list, false);
            } else if (box.getNodeType() == 274) {
                this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "p", this.createBoxAttributeList(box), false);
            } else {
                this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "block", this.createBoxAttributeList(box), false);
            }
            this.writeElementAttributes(box);
            return true;
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    protected void finishBlockBox(BlockRenderBox box) {
        try {
            this.xmlWriter.writeCloseTag();
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        try {
            if (box.getNodeType() == 322) {
                this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "line", this.createBoxAttributeList(box), false);
            } else {
                this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "inline", this.createBoxAttributeList(box), false);
            }
            this.writeElementAttributes(box);
            return true;
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    protected void finishInlineBox(InlineRenderBox box) {
        try {
            this.xmlWriter.writeCloseTag();
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    protected boolean startOtherBox(RenderBox box) {
        try {
            this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "other-box", this.createBoxAttributeList(box), false);
            this.writeElementAttributes(box);
            return true;
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    protected void finishOtherBox(RenderBox box) {
        try {
            this.xmlWriter.writeCloseTag();
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    protected boolean startCanvasBox(CanvasRenderBox box) {
        try {
            this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "canvas", this.createBoxAttributeList(box), false);
            this.writeElementAttributes(box);
            return true;
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    protected void finishCanvasBox(CanvasRenderBox box) {
        try {
            this.xmlWriter.writeCloseTag();
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    protected void processOtherNode(RenderNode node) {
        try {
            int nodeType = node.getNodeType();
            if (nodeType == 17) {
                RenderableText text = (RenderableText)node;
                AttributeList attributeList = new AttributeList();
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "x", String.valueOf(StrictGeomUtility.toExternalValue(node.getX())));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "y", String.valueOf(StrictGeomUtility.toExternalValue(node.getY())));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "width", String.valueOf(StrictGeomUtility.toExternalValue(node.getWidth())));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "height", String.valueOf(StrictGeomUtility.toExternalValue(node.getHeight())));
                this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "text", attributeList, false);
                this.xmlWriter.writeTextNormalized(text.getRawText(), true);
                this.xmlWriter.writeCloseTag();
            } else if (nodeType == 65) {
                SpacerRenderNode spacer = (SpacerRenderNode)node;
                AttributeList attributeList = new AttributeList();
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "width", String.valueOf(StrictGeomUtility.toExternalValue(node.getWidth())));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "height", String.valueOf(StrictGeomUtility.toExternalValue(node.getHeight())));
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "preserve", String.valueOf(!spacer.isDiscardable()));
                this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "spacer", attributeList, true);
            }
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    protected void processRenderableContent(RenderableReplacedContentBox node) {
        try {
            RenderableReplacedContent prc = node.getContent();
            AttributeList attributeList = new AttributeList();
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "x", String.valueOf(StrictGeomUtility.toExternalValue(node.getX())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "y", String.valueOf(StrictGeomUtility.toExternalValue(node.getY())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "width", String.valueOf(StrictGeomUtility.toExternalValue(node.getWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "height", String.valueOf(StrictGeomUtility.toExternalValue(node.getHeight())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "source", String.valueOf(prc.getSource()));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "content-width", String.valueOf(StrictGeomUtility.toExternalValue(prc.getContentWidth())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "content-height", String.valueOf(StrictGeomUtility.toExternalValue(prc.getContentHeight())));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "requested-width", this.convertRenderLength(prc.getRequestedWidth()));
            attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "requested-height", this.convertRenderLength(prc.getRequestedHeight()));
            Object o = prc.getRawObject();
            if (o != null) {
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "raw-object-type", o.getClass().getName());
            } else {
                attributeList.setAttribute(LAYOUT_OUTPUT_NAMESPACE, "raw-object-type", "null");
            }
            this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "replaced-content", attributeList, false);
            this.writeElementAttributes(node);
            this.xmlWriter.writeCloseTag();
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    private String convertRenderLength(RenderLength length) {
        if (length == null) {
            return null;
        }
        if (RenderLength.AUTO.equals(length)) {
            return "auto";
        }
        if (length.isPercentage()) {
            return this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(-length.getValue())) + '%';
        }
        return this.pointConverter.format((Object)StrictGeomUtility.toExternalValue(length.getValue()));
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    protected boolean startRowBox(RenderBox box) {
        try {
            this.xmlWriter.writeTag(LAYOUT_OUTPUT_NAMESPACE, "row-box", this.createBoxAttributeList(box), false);
            this.writeElementAttributes(box);
            return true;
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }

    protected void finishRowBox(RenderBox box) {
        try {
            this.xmlWriter.writeCloseTag();
        }
        catch (IOException e) {
            throw new InvalidReportStateException(e.getMessage(), e);
        }
    }
}

