/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.xml.internal;

import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.fonts.FontMappingUtility;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class XmlPageOutputProcessorMetaData
extends AbstractOutputProcessorMetaData {
    public static final OutputProcessorFeature.BooleanOutputProcessorFeature WRITE_RESOURCEKEYS = new OutputProcessorFeature.BooleanOutputProcessorFeature("xml.write-resourcekeys");

    public XmlPageOutputProcessorMetaData(Configuration configuration) {
        this(configuration, (FontRegistry)new AWTFontRegistry());
    }

    public XmlPageOutputProcessorMetaData(Configuration configuration, FontRegistry registry) {
        super(configuration, (FontStorage)new DefaultFontStorage(registry));
        this.setFamilyMapping(null, "Helvetica");
        this.addFeature(OutputProcessorFeature.FAST_FONTRENDERING);
        this.addFeature(OutputProcessorFeature.BACKGROUND_IMAGE);
        this.addFeature(OutputProcessorFeature.PAGE_SECTIONS);
        this.addFeature(OutputProcessorFeature.SPACING_SUPPORTED);
        this.addFeature(OutputProcessorFeature.PAGEBREAKS);
        this.addFeature(OutputProcessorFeature.WATERMARK_SECTION);
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.xml.AssumeOverflowX"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_X);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.xml.AssumeOverflowY"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_Y);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.xml.WriteResourceKeys"))) {
            this.addFeature(WRITE_RESOURCEKEYS);
        }
    }

    public String getNormalizedFontFamilyName(String name) {
        String mappedName = super.getNormalizedFontFamilyName(name);
        if (FontMappingUtility.isSerif((String)mappedName)) {
            return "Times";
        }
        if (FontMappingUtility.isSansSerif((String)mappedName)) {
            return "Helvetica";
        }
        if (FontMappingUtility.isCourier((String)mappedName)) {
            return "Courier";
        }
        if (FontMappingUtility.isSymbol((String)mappedName)) {
            return "Symbol";
        }
        return mappedName;
    }

    public String getExportDescriptor() {
        return "pageable/xml";
    }
}

