/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.base;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.FlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.IterativeOutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableLayoutProducer;
import org.pentaho.reporting.libraries.base.util.MemoryUsageMessage;
import org.pentaho.reporting.libraries.formatting.FastMessageFormat;

public abstract class AbstractTableOutputProcessor
extends AbstractOutputProcessor
implements IterativeOutputProcessor {
    private static final Log logger = LogFactory.getLog(AbstractTableOutputProcessor.class);
    public static final OutputProcessorFeature.BooleanOutputProcessorFeature STRICT_LAYOUT = new OutputProcessorFeature.BooleanOutputProcessorFeature("strict-layout");
    public static final OutputProcessorFeature.BooleanOutputProcessorFeature TREAT_ELLIPSE_AS_RECTANGLE = new OutputProcessorFeature.BooleanOutputProcessorFeature("treat-ellipse-as-rectangle");
    public static final OutputProcessorFeature.BooleanOutputProcessorFeature SHAPES_CONTENT = new OutputProcessorFeature.BooleanOutputProcessorFeature("shape-content");
    private ArrayList sheetLayouts = new ArrayList();
    private TableLayoutProducer currentLayout;
    private TableContentProducer currentContent;
    private long time;
    private long lastRowCount;

    protected AbstractTableOutputProcessor() {
    }

    public boolean isNeedAlignedPage() {
        return !this.getMetaData().isFeatureSupported(OutputProcessorFeature.ITERATIVE_RENDERING);
    }

    protected final void processPaginationContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage) {
        if (this.currentLayout == null) {
            this.currentLayout = new TableLayoutProducer(this.getMetaData());
        }
        this.currentLayout.update(logicalPage, false);
        this.currentLayout.pageCompleted();
        long rowCount = this.currentLayout.getLayout().getRowCount();
        this.logPerformance("Pagination done: ", rowCount);
        this.sheetLayouts.add(this.currentLayout);
        this.currentLayout = null;
    }

    protected final void processPageContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage) throws ContentProcessingException {
        FlowSelector tableInterceptor = this.getFlowSelector();
        if (tableInterceptor == null) {
            return;
        }
        if (!tableInterceptor.isLogicalPageAccepted(logicalPageKey)) {
            return;
        }
        if (this.currentContent == null) {
            int pageCursor = this.getPageCursor();
            TableLayoutProducer sheetLayout = (TableLayoutProducer)this.sheetLayouts.get(pageCursor);
            this.currentContent = this.createTableContentProducer(sheetLayout.getLayout());
        }
        this.currentContent.compute(logicalPage, false);
        this.processTableContent(logicalPageKey, logicalPage, this.currentContent);
        this.currentContent.clearFinishedBoxes();
        long rowCount = this.currentContent.getContentRowCount();
        this.logPerformance("Content done: ", rowCount);
        this.currentContent = null;
    }

    protected abstract void processTableContent(LogicalPageKey var1, LogicalPageBox var2, TableContentProducer var3) throws ContentProcessingException;

    public final void processIterativeContent(LogicalPageBox logicalPageBox, boolean performOutput) throws ContentProcessingException {
        if (!this.isContentGeneratable()) {
            if (this.currentLayout == null) {
                this.currentLayout = new TableLayoutProducer(this.getMetaData());
            }
            this.currentLayout.update(logicalPageBox, true);
            long rowCount = this.currentLayout.getLayout().getRowCount();
            this.logPerformance("Still Iterating: ", rowCount);
        } else {
            int pageCursor = this.getPageCursor();
            LogicalPageKey logicalPageKey = this.getLogicalPage(pageCursor);
            FlowSelector tableInterceptor = this.getFlowSelector();
            if (tableInterceptor == null) {
                return;
            }
            if (!tableInterceptor.isLogicalPageAccepted(logicalPageKey)) {
                return;
            }
            if (this.currentContent == null) {
                this.time = 0L;
                this.lastRowCount = 0L;
                TableLayoutProducer sheetLayout = (TableLayoutProducer)this.sheetLayouts.get(pageCursor);
                this.currentContent = this.createTableContentProducer(sheetLayout.getLayout());
            }
            this.currentContent.compute(logicalPageBox, true);
            this.updateTableContent(logicalPageKey, logicalPageBox, this.currentContent, performOutput);
            this.currentContent.clearFinishedBoxes();
            long rowCount = this.currentContent.getContentRowCount();
            this.logPerformance("Still Iterating: ", rowCount);
        }
    }

    private void logPerformance(String message, long rowCount) {
        long time = System.currentTimeMillis();
        long deltaTime = time - this.time;
        if (deltaTime > 30000L) {
            this.time = time;
            double rowsPerSec = (float)(rowCount - this.lastRowCount) * 1000.0f / (float)deltaTime;
            this.lastRowCount = rowCount;
            if (logger.isDebugEnabled()) {
                FastMessageFormat messageFormat = new FastMessageFormat("{0} Rows: {1} ({2,number,0.000} rows/sec) ");
                logger.debug((Object)new MemoryUsageMessage(messageFormat.format((Object)new Object[]{message, rowCount, rowsPerSec})));
            }
        }
    }

    protected TableContentProducer createTableContentProducer(SheetLayout layout) {
        return new TableContentProducer(layout, this.getMetaData());
    }

    protected void updateTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPageBox, TableContentProducer tableContentProducer, boolean performOutput) throws ContentProcessingException {
        throw new UnsupportedOperationException("This output processor does not implement the iterative content processing protocol.");
    }

    protected abstract FlowSelector getFlowSelector();
}

