/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.base;

import java.awt.Color;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderCorner;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;

public class CellBackground {
    private ReportAttributeMap attributes;
    private ArrayList<Color> collectedColors;
    private Color backgroundColor;
    private ArrayList<String> anchors;
    private BorderEdge top = BorderEdge.EMPTY;
    private BorderEdge left = BorderEdge.EMPTY;
    private BorderEdge bottom = BorderEdge.EMPTY;
    private BorderEdge right = BorderEdge.EMPTY;
    private BorderCorner topLeft;
    private BorderCorner topRight;
    private BorderCorner bottomLeft;
    private BorderCorner bottomRight;
    private boolean origin;
    private ElementType elementType;
    private static final String[] EMPTY_ANCHORS = new String[0];

    public CellBackground() {
        this.attributes = new ReportAttributeMap();
        this.topLeft = new BorderCorner(0L, 0L);
        this.topRight = new BorderCorner(0L, 0L);
        this.bottomLeft = new BorderCorner(0L, 0L);
        this.bottomRight = new BorderCorner(0L, 0L);
    }

    public boolean isOrigin() {
        return this.origin;
    }

    public void setOrigin(boolean origin) {
        this.origin = origin;
    }

    public void addAttributes(ReportAttributeMap attrs) {
        if (attrs == null) {
            throw new NullPointerException();
        }
        String[] namespaces = attrs.getNameSpaces();
        for (int i = 0; i < namespaces.length; ++i) {
            String namespace = namespaces[i];
            String[] names = attrs.getNames(namespace);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                Object value = attrs.getAttribute(namespace, name);
                if (value == null) continue;
                this.attributes.setAttribute(namespace, name, value);
            }
        }
    }

    public ReportAttributeMap getAttributes() {
        return this.attributes;
    }

    public void addBackground(Color color) {
        if (color == null) {
            return;
        }
        if (color.getAlpha() == 0) {
            return;
        }
        if (this.backgroundColor == null) {
            this.backgroundColor = color;
            return;
        }
        if (color.getAlpha() == 255) {
            this.backgroundColor = color;
            if (this.collectedColors != null) {
                this.collectedColors.clear();
            }
            return;
        }
        if (this.collectedColors == null) {
            this.collectedColors = new ArrayList();
        }
        if (this.collectedColors.isEmpty()) {
            this.collectedColors.add(this.backgroundColor);
        }
        this.collectedColors.add(color);
    }

    public Color getBackgroundColor() {
        if (this.backgroundColor != null && this.backgroundColor.getAlpha() == 255) {
            return this.backgroundColor;
        }
        if (this.collectedColors == null) {
            return this.backgroundColor;
        }
        if (!this.collectedColors.isEmpty()) {
            Color retval = null;
            int colorCount = this.collectedColors.size();
            for (int i = 0; i < colorCount; ++i) {
                Color c = this.collectedColors.get(i);
                retval = retval == null ? c : CellBackground.addColor(retval, c);
            }
            return retval;
        }
        return this.backgroundColor;
    }

    private static Color addColor(Color base, Color paint) {
        if (paint.getAlpha() == 255) {
            return paint;
        }
        if (paint.getAlpha() == 0) {
            return base;
        }
        double baseAlpha = (double)base.getAlpha() / 255.0;
        double paintAlpha = (double)paint.getAlpha() / 255.0;
        double effectiveAlpha = 1.0 - baseAlpha * paintAlpha;
        double deltaAlpha = 1.0 - effectiveAlpha;
        int red = (int)((double)base.getRed() * deltaAlpha + (double)paint.getRed() * effectiveAlpha);
        int green = (int)((double)base.getGreen() * deltaAlpha + (double)paint.getGreen() * effectiveAlpha);
        int blue = (int)((double)base.getBlue() * deltaAlpha + (double)paint.getBlue() * effectiveAlpha);
        return new Color(red, green, blue, (int)(effectiveAlpha * 255.0));
    }

    public BorderEdge getTop() {
        return this.top;
    }

    public void setTop(BorderEdge top) {
        if (top == null) {
            throw new NullPointerException();
        }
        this.top = top;
    }

    public BorderEdge getLeft() {
        return this.left;
    }

    public void setLeft(BorderEdge left) {
        if (left == null) {
            throw new NullPointerException();
        }
        this.left = left;
    }

    public BorderEdge getBottom() {
        return this.bottom;
    }

    public void setBottom(BorderEdge edge) {
        if (edge == null) {
            throw new NullPointerException();
        }
        this.bottom = edge;
    }

    public BorderEdge getRight() {
        return this.right;
    }

    public void setRight(BorderEdge edge) {
        if (edge == null) {
            throw new NullPointerException();
        }
        this.right = edge;
    }

    public void setTopLeft(BorderCorner topLeft) {
        if (topLeft == null) {
            throw new NullPointerException();
        }
        this.topLeft = topLeft;
    }

    public void setTopRight(BorderCorner topRight) {
        if (topRight == null) {
            throw new NullPointerException();
        }
        this.topRight = topRight;
    }

    public void setBottomLeft(BorderCorner bottomLeft) {
        if (bottomLeft == null) {
            throw new NullPointerException();
        }
        this.bottomLeft = bottomLeft;
    }

    public void setBottomRight(BorderCorner bottomRight) {
        if (bottomRight == null) {
            throw new NullPointerException();
        }
        this.bottomRight = bottomRight;
    }

    public BorderCorner getTopLeft() {
        return this.topLeft;
    }

    public BorderCorner getTopRight() {
        return this.topRight;
    }

    public BorderCorner getBottomLeft() {
        return this.bottomLeft;
    }

    public BorderCorner getBottomRight() {
        return this.bottomRight;
    }

    public void addAnchor(String anchor) {
        if (anchor == null) {
            return;
        }
        if (this.anchors == null) {
            this.anchors = new ArrayList();
        }
        this.anchors.add(anchor);
    }

    public String[] getAnchors() {
        if (this.anchors == null) {
            return EMPTY_ANCHORS;
        }
        return this.anchors.toArray(new String[this.anchors.size()]);
    }

    public void addElementType(ElementType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.elementType = type;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellBackground that = (CellBackground)o;
        if (this.origin != that.origin) {
            return false;
        }
        if (this.anchors != null ? !this.anchors.equals(that.anchors) : that.anchors != null) {
            return false;
        }
        if (this.attributes != null ? !this.attributes.equals((Object)that.attributes) : that.attributes != null) {
            return false;
        }
        if (this.backgroundColor != null ? !this.backgroundColor.equals(that.backgroundColor) : that.backgroundColor != null) {
            return false;
        }
        if (this.bottom != null ? !this.bottom.equals(that.bottom) : that.bottom != null) {
            return false;
        }
        if (this.bottomLeft != null ? !this.bottomLeft.equals(that.bottomLeft) : that.bottomLeft != null) {
            return false;
        }
        if (this.bottomRight != null ? !this.bottomRight.equals(that.bottomRight) : that.bottomRight != null) {
            return false;
        }
        if (this.collectedColors != null ? !this.collectedColors.equals(that.collectedColors) : that.collectedColors != null) {
            return false;
        }
        if (this.elementType != null ? !this.elementType.equals(that.elementType) : that.elementType != null) {
            return false;
        }
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        if (this.right != null ? !this.right.equals(that.right) : that.right != null) {
            return false;
        }
        if (this.top != null ? !this.top.equals(that.top) : that.top != null) {
            return false;
        }
        if (this.topLeft != null ? !this.topLeft.equals(that.topLeft) : that.topLeft != null) {
            return false;
        }
        return !(this.topRight != null ? !this.topRight.equals(that.topRight) : that.topRight != null);
    }
}

