/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.base;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderCorner;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContent;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.ProcessUtility;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableExportRenderBoxState;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableRectangle;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.ShapeDrawable;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class CellBackgroundProducer
extends IterateStructuralProcessStep {
    private static final int BACKGROUND_NONE = 0;
    private static final int BACKGROUND_AREA = 1;
    private static final int BACKGROUND_TOP = 2;
    private static final int BACKGROUND_LEFT = 4;
    private static final int BACKGROUND_BOTTOM = 8;
    private static final int BACKGROUND_RIGHT = 16;
    private TableRectangle lookupRectangle;
    private int gridX;
    private int gridY;
    private boolean collectAttributes;
    private SheetLayout sheetLayout;
    private int gridX2;
    private int gridY2;
    private CellBackground retval;
    private long resolvedX;
    private long resolvedY;
    private boolean ellipseAsRectangle;
    private boolean unalignedPagebands;
    private long contentShift;
    private FastStack<RenderBox> parents;
    private boolean fastCellBackgroundProducerMode;

    public CellBackgroundProducer(boolean ellipseAsRectangle, boolean unalignedPagebands) {
        this.ellipseAsRectangle = ellipseAsRectangle;
        this.unalignedPagebands = unalignedPagebands;
        this.lookupRectangle = new TableRectangle();
        this.fastCellBackgroundProducerMode = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.FastCellBackgroundProducer"));
    }

    public CellBackground getBackgroundAt(LogicalPageBox pageBox, SheetLayout sheetLayout, int gridX, int gridY, boolean computeAttributes, int sectionType) {
        return this.computeBackground(pageBox, sheetLayout, gridX, gridY, 1, 1, computeAttributes, sectionType);
    }

    private CellBackground computeBackground(LogicalPageBox logicalPageBox, SheetLayout sheetLayout, int gridX, int gridY, int gridWidth, int gridHeight, boolean collectAttributes, int sectionType) {
        if (logicalPageBox == null) {
            throw new NullPointerException();
        }
        if (sheetLayout == null) {
            throw new NullPointerException();
        }
        this.sheetLayout = sheetLayout;
        this.collectAttributes = collectAttributes;
        this.retval = null;
        this.initFromPosition(gridX, gridY, gridWidth, gridHeight);
        BlockRenderBox headerArea = logicalPageBox.getHeaderArea();
        if (!this.unalignedPagebands) {
            this.contentShift = 0L;
            this.startProcessing(headerArea);
            this.startProcessing(logicalPageBox);
            this.startProcessing(logicalPageBox.getRepeatFooterArea());
            this.startProcessing(logicalPageBox.getFooterArea());
            return this.retval;
        }
        switch (sectionType) {
            case 1: {
                this.contentShift = 0L;
                this.startProcessing(headerArea);
                return this.retval;
            }
            case 0: {
                BlockRenderBox contentArea = logicalPageBox.getContentArea();
                long contentStart = headerArea.getHeight() + contentArea.getY();
                this.contentShift = contentStart - logicalPageBox.getPageOffset();
                this.startProcessing(contentArea);
                return this.retval;
            }
            case 3: {
                BlockRenderBox contentArea = logicalPageBox.getContentArea();
                long contentStart = headerArea.getHeight() + contentArea.getY();
                BlockRenderBox footerArea = logicalPageBox.getRepeatFooterArea();
                this.contentShift = contentStart + contentArea.getHeight();
                this.startProcessing(footerArea);
                return this.retval;
            }
            case 2: {
                BlockRenderBox contentArea = logicalPageBox.getContentArea();
                long contentStart = headerArea.getHeight() + contentArea.getY();
                BlockRenderBox repeatFooterArea = logicalPageBox.getRepeatFooterArea();
                BlockRenderBox footerArea = logicalPageBox.getFooterArea();
                this.contentShift = contentStart + contentArea.getHeight() + repeatFooterArea.getHeight();
                this.startProcessing(footerArea);
                return this.retval;
            }
            case -1: {
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public CellBackground getBackgroundForBox(LogicalPageBox logicalPageBox, SheetLayout sheetLayout, int gridX, int gridY, int gridWidth, int gridHeight, boolean collectAttributes, int sectionType, RenderBox contentBox) {
        if (!this.fastCellBackgroundProducerMode) {
            return this.computeBackground(logicalPageBox, sheetLayout, gridX, gridY, gridWidth, gridHeight, collectAttributes, sectionType);
        }
        if (logicalPageBox == null) {
            throw new NullPointerException();
        }
        if (sheetLayout == null) {
            throw new NullPointerException();
        }
        this.sheetLayout = sheetLayout;
        this.collectAttributes = collectAttributes;
        this.retval = null;
        this.initFromPosition(gridX, gridY, gridWidth, gridHeight);
        BlockRenderBox headerArea = logicalPageBox.getHeaderArea();
        if (!this.unalignedPagebands) {
            this.contentShift = 0L;
        } else {
            switch (sectionType) {
                case 1: {
                    this.contentShift = 0L;
                    break;
                }
                case 0: {
                    BlockRenderBox contentArea = logicalPageBox.getContentArea();
                    long contentStart = headerArea.getHeight() + contentArea.getY();
                    this.contentShift = contentStart - logicalPageBox.getPageOffset();
                    break;
                }
                case 3: {
                    BlockRenderBox contentArea = logicalPageBox.getContentArea();
                    long contentStart = headerArea.getHeight() + contentArea.getY();
                    this.contentShift = contentStart + contentArea.getHeight();
                    break;
                }
                case 2: {
                    BlockRenderBox contentArea = logicalPageBox.getContentArea();
                    long contentStart = headerArea.getHeight() + contentArea.getY();
                    BlockRenderBox repeatFooterArea = logicalPageBox.getRepeatFooterArea();
                    this.contentShift = contentStart + contentArea.getHeight() + repeatFooterArea.getHeight();
                    break;
                }
                case -1: {
                    return null;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (this.parents == null) {
            this.parents = new FastStack();
        } else {
            this.parents.clear();
        }
        boolean seenSectionBox = false;
        RenderBox lastProcessed = null;
        for (RenderBox p = contentBox; p != null; p = p.getParent()) {
            int nodeType = p.getNodeType();
            if (nodeType == 69650) {
                seenSectionBox = true;
            }
            if (seenSectionBox) {
                this.parents.push((Object)p);
                continue;
            }
            lastProcessed = p;
        }
        boolean receivedNoBackground = false;
        while (!this.parents.isEmpty()) {
            RenderBox p2 = (RenderBox)this.parents.pop();
            if (this.startBox(p2)) continue;
            receivedNoBackground = true;
            break;
        }
        if (!receivedNoBackground && lastProcessed != null) {
            this.startProcessing(lastProcessed);
        }
        return this.retval;
    }

    private void initFromPosition(int gridX, int gridY, int gridWidth, int gridHeight) {
        this.resolvedX = this.sheetLayout.getXPosition(gridX);
        this.resolvedY = this.sheetLayout.getYPosition(gridY);
        this.gridX = gridX;
        this.gridY = gridY;
        this.gridX2 = gridX + gridWidth;
        this.gridY2 = gridY + gridHeight;
    }

    private int computeBackground(RenderBox node) {
        TableExportRenderBoxState renderBoxState;
        Object state = node.getTableExportState();
        if (state instanceof TableExportRenderBoxState) {
            renderBoxState = (TableExportRenderBoxState)state;
        } else {
            renderBoxState = new TableExportRenderBoxState();
            node.setTableExportState(renderBoxState);
        }
        TableRectangle hint = renderBoxState.getCellBackgroundHint();
        if (hint == null) {
            hint = this.sheetLayout.getTableBoundsWithCache(node.getX(), node.getY() + this.contentShift, node.getWidth(), node.getHeight(), new TableRectangle(-1, -1, -1, -1));
        } else if (renderBoxState.getBackgroundDefinitionAge() != this.contentShift) {
            hint = this.sheetLayout.getTableBoundsWithCache(node.getX(), node.getY() + this.contentShift, node.getWidth(), node.getHeight(), hint);
        }
        int x1 = hint.getX1();
        int y1 = hint.getY1();
        int x2 = hint.getX2();
        int y2 = hint.getY2();
        int retval = this.computeBackgroundHint(x1, y1, x2, y2);
        renderBoxState.setCellBackgroundHint(hint, this.contentShift);
        return retval;
    }

    private int computeBackground(long x, long y, long width, long height) {
        this.lookupRectangle = this.sheetLayout.getTableBounds(x, y + this.contentShift, width, height, this.lookupRectangle);
        int x1 = this.lookupRectangle.getX1();
        int y1 = this.lookupRectangle.getY1();
        int x2 = this.lookupRectangle.getX2();
        int y2 = this.lookupRectangle.getY2();
        return this.computeBackgroundHint(x1, y1, x2, y2);
    }

    private int computeBackgroundHint(int x1, int y1, int x2, int y2) {
        int retval = 0;
        if (x1 <= this.gridX && x2 >= this.gridX2) {
            if (y1 <= this.gridY && y2 >= this.gridY2) {
                retval |= 1;
            }
            if (y1 == this.gridY) {
                retval |= 2;
            }
            if (y2 == this.gridY2) {
                retval |= 8;
            }
        }
        if (y1 <= this.gridY && y2 >= this.gridY2) {
            if (x1 == this.gridX) {
                retval |= 4;
            }
            if (x2 == this.gridX2) {
                retval |= 0x10;
            }
        }
        return retval;
    }

    protected void processRenderableContent(RenderableReplacedContentBox box) {
        int backgroundHint = this.computeBackground(box);
        if (backgroundHint == 0) {
            return;
        }
        this.retval = CellBackgroundProducer.applyBorder(box, this.retval, backgroundHint);
        if ((backgroundHint & 1) == 1) {
            this.retval = CellBackgroundProducer.applyBackground(box, this.retval);
            this.retval = CellBackgroundProducer.applyAnchor(box, this.contentShift, this.resolvedX, this.resolvedY, this.retval);
            this.retval = CellBackgroundProducer.applyElementType(box, this.contentShift, this.resolvedX, this.resolvedY, this.retval);
            if (this.collectAttributes) {
                this.retval = CellBackgroundProducer.applyAttributes(box, this.contentShift, this.resolvedX, this.resolvedY, this.retval);
            }
        }
        this.computeLegacyBackground(box);
    }

    private void computeLegacyBackground(RenderableReplacedContentBox node) {
        long nodeHeight;
        long nodeWidth;
        long nodeY;
        BoxDefinition sblp = node.getBoxDefinition();
        long nodeX = node.getX() + sblp.getPaddingLeft();
        int backgroundHint = this.computeBackground(nodeX, nodeY = node.getY() + sblp.getPaddingTop(), nodeWidth = node.getWidth() - sblp.getPaddingLeft() - sblp.getPaddingRight(), nodeHeight = node.getHeight() - sblp.getPaddingTop() - sblp.getPaddingBottom());
        if (backgroundHint == 0) {
            return;
        }
        RenderableReplacedContent rpc = node.getContent();
        Object rawContentObject = rpc.getRawObject();
        if (!(rawContentObject instanceof DrawableWrapper)) {
            return;
        }
        DrawableWrapper wrapper = (DrawableWrapper)rawContentObject;
        Object rawbackend = wrapper.getBackend();
        if (!(rawbackend instanceof ShapeDrawable)) {
            return;
        }
        ShapeDrawable drawable = (ShapeDrawable)rawbackend;
        Shape shape = drawable.getShape();
        StyleSheet styleSheet = node.getStyleSheet();
        boolean draw = styleSheet.getBooleanStyleProperty(ElementStyleKeys.DRAW_SHAPE);
        if (draw && shape instanceof Line2D) {
            boolean horizontal;
            Line2D line = (Line2D)shape;
            boolean vertical = line.getX1() == line.getX2();
            boolean bl = horizontal = line.getY1() == line.getY2();
            if (vertical && horizontal) {
                return;
            }
            if (!vertical && !horizontal) {
                return;
            }
            if (this.retval == null) {
                this.retval = new CellBackground();
            }
            BorderEdge edge = ProcessUtility.produceBorderEdge(styleSheet);
            if (vertical) {
                if (line.getX1() == 0.0) {
                    RenderBox nodeParent;
                    if ((backgroundHint & 4) == 4) {
                        this.retval.setLeft(edge);
                    } else if ((backgroundHint & 0x10) == 16 && (nodeParent = node.getParent()) != null && nodeParent.getX() + nodeParent.getWidth() == nodeX + nodeWidth) {
                        this.retval.setRight(edge);
                    }
                } else if ((backgroundHint & 0x10) == 16) {
                    this.retval.setRight(edge);
                }
            } else if (line.getY1() == 0.0) {
                RenderBox nodeParent;
                if ((backgroundHint & 2) == 2) {
                    this.retval.setTop(edge);
                } else if ((backgroundHint & 8) == 8 && (nodeParent = node.getParent()) != null && nodeParent.getY() + nodeParent.getHeight() == nodeY + nodeHeight) {
                    this.retval.setBottom(edge);
                }
            } else if ((backgroundHint & 8) == 8) {
                this.retval.setBottom(edge);
            }
            return;
        }
        boolean fill = styleSheet.getBooleanStyleProperty(ElementStyleKeys.FILL_SHAPE);
        if (!draw && !fill) {
            return;
        }
        if (shape instanceof Rectangle2D || this.ellipseAsRectangle && shape instanceof Ellipse2D) {
            BorderEdge edge;
            if (this.retval == null) {
                this.retval = new CellBackground();
            }
            if (draw && (edge = ProcessUtility.produceBorderEdge(styleSheet)) != null) {
                if ((backgroundHint & 2) == 2) {
                    this.retval.setTop(edge);
                }
                if ((backgroundHint & 4) == 4) {
                    this.retval.setLeft(edge);
                }
                if ((backgroundHint & 8) == 8) {
                    this.retval.setBottom(edge);
                }
                if ((backgroundHint & 0x10) == 16) {
                    this.retval.setRight(edge);
                }
            }
            if (fill && (backgroundHint & 1) == 1) {
                Color color = (Color)styleSheet.getStyleProperty(ElementStyleKeys.FILL_COLOR);
                if (color != null) {
                    this.retval.addBackground(color);
                } else {
                    this.retval.addBackground((Color)styleSheet.getStyleProperty(ElementStyleKeys.PAINT));
                }
            }
            return;
        }
        if (shape instanceof RoundRectangle2D) {
            BorderEdge edge;
            RoundRectangle2D rr = (RoundRectangle2D)shape;
            if (this.retval == null) {
                this.retval = new CellBackground();
            }
            if (draw && (edge = ProcessUtility.produceBorderEdge(styleSheet)) != null) {
                if ((backgroundHint & 2) == 2) {
                    this.retval.setTop(edge);
                }
                if ((backgroundHint & 4) == 4) {
                    this.retval.setLeft(edge);
                }
                if ((backgroundHint & 8) == 8) {
                    this.retval.setBottom(edge);
                }
                if ((backgroundHint & 0x10) == 16) {
                    this.retval.setRight(edge);
                }
            }
            if (fill && (backgroundHint & 1) == 1) {
                Color color = (Color)styleSheet.getStyleProperty(ElementStyleKeys.FILL_COLOR);
                if (color != null) {
                    this.retval.addBackground(color);
                } else {
                    this.retval.addBackground((Color)styleSheet.getStyleProperty(ElementStyleKeys.PAINT));
                }
            }
            long arcHeight = StrictGeomUtility.toInternalValue(rr.getArcHeight());
            long arcWidth = StrictGeomUtility.toInternalValue(rr.getArcWidth());
            if (arcHeight > 0L && arcWidth > 0L) {
                BorderCorner bc = new BorderCorner(arcWidth, arcHeight);
                if ((backgroundHint & 2) == 2) {
                    if ((backgroundHint & 4) == 4) {
                        this.retval.setTopLeft(bc);
                    }
                    if ((backgroundHint & 0x10) == 16) {
                        this.retval.setTopRight(bc);
                    }
                }
                if ((backgroundHint & 8) == 8) {
                    if ((backgroundHint & 4) == 4) {
                        this.retval.setBottomLeft(bc);
                    }
                    if ((backgroundHint & 0x10) == 16) {
                        this.retval.setBottomRight(bc);
                    }
                }
            }
        }
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        return this.startBox(box);
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        return this.startBox(box);
    }

    protected boolean startCanvasBox(CanvasRenderBox box) {
        return this.startBox(box);
    }

    protected boolean startOtherBox(RenderBox box) {
        return this.startBox(box);
    }

    private boolean startBox(RenderBox box) {
        int backgroundHint = this.computeBackground(box);
        if (backgroundHint == 0) {
            return false;
        }
        this.retval = CellBackgroundProducer.applyBorder(box, this.retval, backgroundHint);
        if ((backgroundHint & 1) == 1) {
            this.retval = CellBackgroundProducer.applyBackground(box, this.retval);
            this.retval = CellBackgroundProducer.applyAnchor(box, this.contentShift, this.resolvedX, this.resolvedY, this.retval);
            this.retval = CellBackgroundProducer.applyElementType(box, this.contentShift, this.resolvedX, this.resolvedY, this.retval);
            if (this.collectAttributes) {
                this.retval = CellBackgroundProducer.applyAttributes(box, this.contentShift, this.resolvedX, this.resolvedY, this.retval);
            }
            return true;
        }
        return true;
    }

    protected boolean startRowBox(RenderBox box) {
        return this.startBox(box);
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
    }

    private static CellBackground applyAnchor(RenderBox content, long contentShift, long x, long y, CellBackground retval) {
        if (content.getY() + contentShift != y || content.getX() != x) {
            return retval;
        }
        String anchor = (String)content.getStyleSheet().getStyleProperty(ElementStyleKeys.ANCHOR_NAME);
        if (anchor != null) {
            if (retval == null) {
                retval = new CellBackground();
            }
            retval.addAnchor(anchor);
        }
        return retval;
    }

    private static CellBackground applyElementType(RenderBox content, long contentShift, long x, long y, CellBackground retval) {
        if (content.getY() + contentShift != y || content.getX() != x) {
            return retval;
        }
        ElementType anchor = content.getElementType();
        if (anchor != null) {
            if (retval == null) {
                retval = new CellBackground();
            }
            retval.addElementType(anchor);
        }
        return retval;
    }

    private static CellBackground applyAttributes(RenderBox content, long contentShift, long x, long y, CellBackground retval) {
        if (content.getY() + contentShift != y || content.getX() != x) {
            return retval;
        }
        if (retval == null) {
            retval = new CellBackground();
        }
        retval.addAttributes(content.getAttributes());
        return retval;
    }

    private static CellBackground applyBorder(RenderBox content, CellBackground retval, int backgroundHint) {
        BorderEdge borderEdgeRight;
        BorderEdge borderEdgeBottom;
        BorderEdge borderEdgeLeft;
        BorderEdge borderEdgeTop;
        Border border = content.getBoxDefinition().getBorder();
        if (border.isEmpty()) {
            return retval;
        }
        if ((backgroundHint & 2) == 2 && !(borderEdgeTop = border.getTop()).isEmpty()) {
            if (retval == null) {
                retval = new CellBackground();
            }
            retval.setTop(borderEdgeTop);
        }
        if ((backgroundHint & 4) == 4 && !(borderEdgeLeft = border.getLeft()).isEmpty()) {
            if (retval == null) {
                retval = new CellBackground();
            }
            retval.setLeft(borderEdgeLeft);
        }
        if ((backgroundHint & 8) == 8 && !(borderEdgeBottom = border.getBottom()).isEmpty()) {
            if (retval == null) {
                retval = new CellBackground();
            }
            retval.setBottom(borderEdgeBottom);
        }
        if ((backgroundHint & 0x10) == 16 && !(borderEdgeRight = border.getRight()).isEmpty()) {
            if (retval == null) {
                retval = new CellBackground();
            }
            retval.setRight(borderEdgeRight);
        }
        return retval;
    }

    private static CellBackground applyBackground(RenderBox content, CellBackground retval) {
        Color backgroundColor = (Color)content.getStyleSheet().getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR);
        if (backgroundColor != null && backgroundColor.getAlpha() > 0) {
            if (retval == null) {
                retval = new CellBackground();
            }
            retval.addBackground(backgroundColor);
        }
        return retval;
    }
}

