/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.base;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContent;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.model.SpacerRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.RevalidateTextEllipseProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.text.GlyphList;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;

public class DefaultTextExtractor
extends IterateStructuralProcessStep {
    private StringBuffer text;
    private Object rawResult;
    private RenderNode rawSource;
    private StrictBounds paragraphBounds;
    private boolean overflowX;
    private boolean overflowY;
    private boolean textLineOverflow;
    private RevalidateTextEllipseProcessStep revalidateTextEllipseProcessStep;
    private CodePointBuffer codePointBuffer;
    private boolean manualBreak;
    private long contentAreaX2;
    private boolean ellipseDrawn;
    private boolean clipOnWordBoundary;

    public DefaultTextExtractor(OutputProcessorMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        this.codePointBuffer = new CodePointBuffer(400);
        this.text = new StringBuffer(400);
        this.paragraphBounds = new StrictBounds();
        this.revalidateTextEllipseProcessStep = new RevalidateTextEllipseProcessStep(metaData);
        this.clipOnWordBoundary = "true".equals(metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.LastLineBreaksOnWordBoundary"));
    }

    protected CodePointBuffer getCodePointBuffer() {
        return this.codePointBuffer;
    }

    public Object compute(RenderBox box) {
        this.rawResult = null;
        this.rawSource = null;
        this.paragraphBounds.setRect(box.getX(), box.getY(), box.getWidth(), box.getHeight());
        this.overflowX = box.isBoxOverflowX();
        this.overflowY = box.isBoxOverflowY();
        this.clearText();
        this.startProcessing(box);
        if (this.rawResult != null) {
            return this.rawResult;
        }
        return this.text.toString();
    }

    public String getFormattedtext() {
        return this.text.toString();
    }

    private long extractEllipseSize(RenderNode node) {
        if (node == null) {
            return 0L;
        }
        RenderBox parent = node.getParent();
        if (parent == null) {
            return 0L;
        }
        RenderBox textEllipseBox = parent.getTextEllipseBox();
        if (textEllipseBox == null) {
            return 0L;
        }
        return textEllipseBox.getWidth();
    }

    protected void processOtherNode(RenderNode node) {
        int nodeType = node.getNodeType();
        if (this.isTextLineOverflow()) {
            if (!node.isNodeVisible(this.paragraphBounds, this.overflowX, this.overflowY)) {
                return;
            }
            if (node.isVirtualNode()) {
                RenderBox textEllipseBox;
                RenderBox parent;
                if (this.ellipseDrawn) {
                    return;
                }
                this.ellipseDrawn = true;
                if (!this.clipOnWordBoundary && nodeType == 17) {
                    RenderableText text = (RenderableText)node;
                    long ellipseSize = this.extractEllipseSize(node);
                    long x1 = text.getX();
                    long effectiveAreaX2 = this.contentAreaX2 - ellipseSize;
                    if (x1 < this.contentAreaX2) {
                        this.drawText(text, effectiveAreaX2);
                    }
                }
                if ((parent = node.getParent()) != null && (textEllipseBox = parent.getTextEllipseBox()) != null) {
                    this.processBoxChilds(textEllipseBox);
                }
                return;
            }
        }
        if (nodeType == 17) {
            RenderableText textNode = (RenderableText)node;
            if (this.isTextLineOverflow()) {
                long effectiveAreaX2;
                if (!textNode.isNodeVisible(this.paragraphBounds, this.overflowX, this.overflowY)) {
                    return;
                }
                long ellipseSize = this.extractEllipseSize(node);
                long x1 = node.getX();
                long x2 = x1 + node.getWidth();
                if (x2 <= (effectiveAreaX2 = this.contentAreaX2 - ellipseSize)) {
                    this.drawText(textNode, x2);
                } else if (x1 < this.contentAreaX2) {
                    RenderBox textEllipseBox;
                    this.drawText(textNode, effectiveAreaX2);
                    RenderBox parent = node.getParent();
                    if (parent != null && (textEllipseBox = parent.getTextEllipseBox()) != null) {
                        this.processBoxChilds(textEllipseBox);
                    }
                }
            } else {
                this.drawText(textNode, textNode.getX() + textNode.getWidth());
            }
            if (textNode.isForceLinebreak()) {
                this.manualBreak = true;
            }
        } else if (nodeType == 65) {
            SpacerRenderNode spacer = (SpacerRenderNode)node;
            int count = Math.max(1, spacer.getSpaceCount());
            for (int i = 0; i < count; ++i) {
                this.text.append(' ');
            }
        }
    }

    protected void drawText(RenderableText renderableText, long contentX2) {
        if (renderableText.getLength() == 0) {
            return;
        }
        GlyphList gs = renderableText.getGlyphs();
        int maxLength = renderableText.computeMaximumTextSize(contentX2);
        this.text.append(gs.getText(renderableText.getOffset(), maxLength, this.codePointBuffer));
    }

    protected boolean startOtherBox(RenderBox box) {
        return false;
    }

    protected boolean isContentField(RenderBox box) {
        return box.getNodeType() == 258;
    }

    public boolean startCanvasBox(CanvasRenderBox box) {
        return false;
    }

    protected void processRenderableContent(RenderableReplacedContentBox box) {
        RenderableReplacedContent rpc = box.getContent();
        this.rawResult = rpc.getRawObject();
        this.rawSource = box;
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        return box.getStaticBoxLayoutProperties().isVisible();
    }

    protected boolean startRowBox(RenderBox box) {
        return box.getStaticBoxLayoutProperties().isVisible();
    }

    public RenderNode getRawSource() {
        return this.rawSource;
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        return box.getStaticBoxLayoutProperties().isVisible();
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.rawResult = box.getRawValue();
        this.paragraphBounds.setRect(box.getX(), box.getY(), box.getWidth(), box.getHeight());
        this.overflowX = box.isBoxOverflowX();
        this.overflowY = box.isBoxOverflowY();
        long contentAreaX1 = box.getContentAreaX1();
        this.contentAreaX2 = box.getContentAreaX2();
        for (RenderBox lineBox = (RenderBox)box.getFirstChild(); lineBox != null; lineBox = (RenderBox)lineBox.getNext()) {
            this.manualBreak = false;
            this.processTextLine(lineBox, contentAreaX1, this.contentAreaX2);
            if (this.manualBreak) {
                this.addLinebreak();
                continue;
            }
            if (lineBox.getNext() == null) continue;
            if (!lineBox.getStaticBoxLayoutProperties().isPreserveSpace()) {
                this.addSoftBreak();
                continue;
            }
            this.addEmptyBreak();
        }
    }

    protected void addEmptyBreak() {
        this.text.append(' ');
    }

    protected void addSoftBreak() {
        this.text.append(' ');
    }

    protected void addLinebreak() {
        this.text.append('\n');
    }

    protected void processTextLine(RenderBox lineBox, long contentAreaX1, long contentAreaX2) {
        if (!lineBox.isNodeVisible(this.paragraphBounds, this.overflowX, this.overflowY)) {
            return;
        }
        this.ellipseDrawn = false;
        boolean overflowProperty = lineBox.getParent().getStaticBoxLayoutProperties().isOverflowX();
        boolean bl = this.textLineOverflow = lineBox.getX() + lineBox.getWidth() > contentAreaX2 && !overflowProperty;
        if (this.textLineOverflow) {
            this.revalidateTextEllipseProcessStep.compute(lineBox, contentAreaX1, contentAreaX2);
        }
        this.startProcessing(lineBox);
    }

    public Object getRawResult() {
        return this.rawResult;
    }

    protected void setRawResult(Object rawResult) {
        this.rawResult = rawResult;
    }

    public String getText() {
        return this.text.toString();
    }

    public int getTextLength() {
        return this.text.length();
    }

    protected void clearText() {
        this.text.delete(0, this.text.length());
    }

    protected StrictBounds getParagraphBounds() {
        return this.paragraphBounds;
    }

    public boolean isTextLineOverflow() {
        return this.textLineOverflow;
    }

    public boolean isOverflowX() {
        return this.overflowX;
    }

    public boolean isOverflowY() {
        return this.overflowY;
    }
}

