/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.base;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;

public class SheetLayoutCollection {
    private ArrayList pageLayouts = new ArrayList();
    private SheetLayout globalLayout;
    private boolean useGlobalLayout;

    public SheetLayoutCollection(boolean useGlobalLayout) {
        this.useGlobalLayout = useGlobalLayout;
        this.globalLayout = null;
    }

    public void addLayout(SheetLayout bounds) {
        if (this.isGlobalLayout()) {
            this.globalLayout = bounds;
        } else {
            this.pageLayouts.add(bounds);
        }
    }

    public boolean isGlobalLayout() {
        return this.useGlobalLayout;
    }

    public SheetLayout getLayoutForPage(int page) {
        if (this.isGlobalLayout()) {
            if (this.globalLayout == null) {
                throw new IllegalStateException("No global layout defined.");
            }
            return this.globalLayout;
        }
        if (page < this.pageLayouts.size()) {
            return (SheetLayout)this.pageLayouts.get(page);
        }
        return null;
    }

    public int getPageCount() {
        if (!this.isGlobalLayout()) {
            return this.pageLayouts.size();
        }
        if (this.globalLayout == null) {
            return 0;
        }
        return 1;
    }
}

