/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.base;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.WatermarkAreaBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;

public class TableLayoutProducer
extends IterateStructuralProcessStep {
    private SheetLayout layout;
    private long pageOffset;
    private boolean headerProcessed;
    private long contentOffset;
    private long effectiveOffset;
    private boolean unalignedPagebands;
    private long pageHeight;
    private OutputProcessorMetaData metaData;

    public TableLayoutProducer(OutputProcessorMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        this.metaData = metaData;
        this.unalignedPagebands = metaData.isFeatureSupported(OutputProcessorFeature.UNALIGNED_PAGEBANDS);
        this.layout = new SheetLayout(metaData.isFeatureSupported(AbstractTableOutputProcessor.STRICT_LAYOUT), metaData.isFeatureSupported(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE));
    }

    public SheetLayout getLayout() {
        return this.layout;
    }

    public void update(LogicalPageBox logicalPage, boolean iterativeUpdate) {
        if (!this.unalignedPagebands) {
            this.pageOffset = 0L;
            long pageEnd = logicalPage.getPageEnd() - logicalPage.getPageOffset();
            this.effectiveOffset = 0L;
            this.pageHeight = this.effectiveOffset + (pageEnd - this.pageOffset);
            if (this.startBlockBox(logicalPage)) {
                if (!this.headerProcessed) {
                    this.startProcessing(logicalPage.getWatermarkArea());
                    BlockRenderBox headerArea = logicalPage.getHeaderArea();
                    this.startProcessing(headerArea);
                    this.headerProcessed = true;
                }
                this.processBoxChilds(logicalPage);
                if (!iterativeUpdate) {
                    BlockRenderBox repeatFooterBox = logicalPage.getRepeatFooterArea();
                    this.pageHeight += repeatFooterBox.getHeight();
                    this.startProcessing(repeatFooterBox);
                    BlockRenderBox pageFooterBox = logicalPage.getFooterArea();
                    this.pageHeight += pageFooterBox.getHeight();
                    this.startProcessing(pageFooterBox);
                }
            }
            this.finishBlockBox(logicalPage);
        } else {
            this.effectiveOffset = 0L;
            this.pageOffset = 0L;
            this.pageHeight = logicalPage.getPageEnd();
            if (this.startBlockBox(logicalPage)) {
                if (!this.headerProcessed) {
                    this.contentOffset = 0L;
                    this.effectiveOffset = 0L;
                    WatermarkAreaBox watermarkArea = logicalPage.getWatermarkArea();
                    long watermarkPageEnd = watermarkArea.getHeight();
                    this.pageHeight = this.effectiveOffset + (watermarkPageEnd - this.pageOffset);
                    this.startProcessing(watermarkArea);
                    BlockRenderBox headerArea = logicalPage.getHeaderArea();
                    long pageEnd = headerArea.getHeight();
                    this.pageHeight = this.effectiveOffset + (pageEnd - this.pageOffset);
                    this.startProcessing(headerArea);
                    this.contentOffset = headerArea.getHeight();
                    this.headerProcessed = true;
                }
                this.pageOffset = logicalPage.getPageOffset();
                long pageEnd = logicalPage.getPageEnd();
                this.effectiveOffset = this.contentOffset;
                this.pageHeight = this.effectiveOffset + (pageEnd - this.pageOffset);
                this.processBoxChilds(logicalPage);
                if (!iterativeUpdate) {
                    this.pageOffset = 0L;
                    BlockRenderBox repeatFooterArea = logicalPage.getRepeatFooterArea();
                    long repeatFooterOffset = this.contentOffset + (logicalPage.getPageEnd() - logicalPage.getPageOffset());
                    long repeatFooterPageEnd = repeatFooterOffset + repeatFooterArea.getHeight();
                    this.effectiveOffset = repeatFooterOffset;
                    this.pageHeight = this.effectiveOffset + (repeatFooterPageEnd - this.pageOffset);
                    this.startProcessing(repeatFooterArea);
                    BlockRenderBox footerArea = logicalPage.getFooterArea();
                    long footerPageEnd = repeatFooterPageEnd + footerArea.getHeight();
                    this.effectiveOffset = repeatFooterPageEnd;
                    this.pageHeight = this.effectiveOffset + (footerPageEnd - this.pageOffset);
                    this.startProcessing(footerArea);
                }
            }
            this.finishBlockBox(logicalPage);
        }
    }

    public SheetLayout createSheetLayout(RenderBox section) {
        this.layout = new SheetLayout(this.metaData.isFeatureSupported(AbstractTableOutputProcessor.STRICT_LAYOUT), this.metaData.isFeatureSupported(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE));
        this.pageOffset = 0L;
        this.effectiveOffset = 0L;
        this.contentOffset = 0L;
        this.pageHeight = section.getHeight();
        this.startProcessing(section);
        return this.layout;
    }

    private boolean startBox(RenderBox box) {
        long y = this.effectiveOffset + box.getY() - this.pageOffset;
        long height = box.getHeight();
        if (height > 0L) {
            if (y + height <= this.effectiveOffset) {
                return false;
            }
            if (y >= this.pageHeight) {
                return false;
            }
        } else {
            if (y + height < this.effectiveOffset) {
                return false;
            }
            if (y > this.pageHeight) {
                return false;
            }
        }
        if (!box.isOpen() && !box.isFinishedTable() && box.isCommited()) {
            if (this.layout.add(box, -this.pageOffset + this.effectiveOffset)) {
                return false;
            }
            box.setFinishedTable(true);
            return true;
        }
        return true;
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        return this.startBox(box);
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        return false;
    }

    protected boolean startOtherBox(RenderBox box) {
        return this.startBox(box);
    }

    public boolean startCanvasBox(CanvasRenderBox box) {
        return this.startBox(box);
    }

    protected boolean startRowBox(RenderBox box) {
        return this.startBox(box);
    }

    protected void processRenderableContent(RenderableReplacedContentBox box) {
        if (!box.isOpen() && !box.isFinishedTable() && box.isCommited()) {
            this.startBox(box);
            this.layout.addRenderableContent(box, -this.pageOffset + this.effectiveOffset);
        }
    }

    protected void processParagraphChilds(ParagraphRenderBox box) {
    }

    public void pageCompleted() {
        this.layout.pageCompleted();
        this.headerProcessed = false;
    }
}

