/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.csv;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.DefaultTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.CSVQuoter;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.NameGenerator;

public class CSVPrinter {
    private ContentLocation contentLocation;
    private NameGenerator contentNameGenerator;
    private String encoding;
    private ContentItem documentContentItem;
    private PrintWriter writer;
    private DefaultTextExtractor textExtractor;
    private CSVQuoter quoter;

    public CSVPrinter() {
        this.encoding = EncodingRegistry.getPlatformDefaultEncoding();
    }

    public CSVPrinter(Configuration config) {
        this.encoding = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.Encoding", EncodingRegistry.getPlatformDefaultEncoding());
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        this.encoding = encoding;
    }

    public ContentLocation getContentLocation() {
        return this.contentLocation;
    }

    public void setContentLocation(ContentLocation contentLocation) {
        if (contentLocation == null) {
            throw new NullPointerException();
        }
        this.contentLocation = contentLocation;
    }

    public NameGenerator getContentNameGenerator() {
        return this.contentNameGenerator;
    }

    public void setContentNameGenerator(NameGenerator contentNameGenerator) {
        if (contentNameGenerator == null) {
            throw new NullPointerException();
        }
        this.contentNameGenerator = contentNameGenerator;
    }

    public void print(LogicalPageBox logicalPage, TableContentProducer contentProducer, OutputProcessorMetaData metaData, boolean incremental) throws ContentProcessingException {
        try {
            if (this.textExtractor == null) {
                this.textExtractor = new DefaultTextExtractor(metaData);
                String separator = metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.Separator", ",");
                if (separator.length() == 0) {
                    throw new IllegalArgumentException("CSV separate cannot be an empty string.");
                }
                this.quoter = new CSVQuoter(separator.charAt(0));
            }
            if (this.documentContentItem == null) {
                if (this.contentLocation == null) {
                    throw new IllegalStateException();
                }
                if (this.contentNameGenerator == null) {
                    throw new IllegalStateException();
                }
                this.documentContentItem = this.contentLocation.createItem(this.contentNameGenerator.generateName("content", "text/csv"));
                OutputStream out = this.documentContentItem.getOutputStream();
                String encoding = metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.Encoding", this.encoding);
                this.writer = new PrintWriter(new OutputStreamWriter(out, encoding));
            }
            SheetLayout sheetLayout = contentProducer.getSheetLayout();
            int columnCount = contentProducer.getColumnCount();
            int lastColumn = columnCount - 1;
            int startRow = contentProducer.getFinishedRows();
            int finishRow = contentProducer.getFilledRows();
            for (int row = startRow; row < finishRow; ++row) {
                for (int col = 0; col < columnCount; col = (int)((short)(col + 1))) {
                    RenderBox content = contentProducer.getContent(row, col);
                    if (content == null) {
                        this.writer.print(this.quoter.getSeparator());
                        continue;
                    }
                    if (!content.isCommited()) {
                        throw new InvalidReportStateException("Uncommited content encountered");
                    }
                    long contentOffset = contentProducer.getContentOffset(row, col);
                    long colPos = sheetLayout.getXPosition(col);
                    long rowPos = sheetLayout.getYPosition(row);
                    if (content.getX() != colPos || content.getY() + contentOffset != rowPos) {
                        this.writer.print(this.quoter.getSeparator());
                        continue;
                    }
                    this.textExtractor.compute(content);
                    String formattedtext = this.textExtractor.getFormattedtext();
                    this.quoter.doQuoting(formattedtext, (Writer)this.writer);
                    if (col < lastColumn) {
                        this.writer.print(this.quoter.getSeparator());
                    }
                    content.setFinishedTable(true);
                }
                this.writer.println();
            }
            if (!incremental) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
                this.documentContentItem = null;
            }
        }
        catch (IOException e) {
            this.writer = null;
            this.documentContentItem = null;
            throw new ContentProcessingException("Failed to write content", e);
        }
        catch (ContentCreationException e) {
            this.writer = null;
            this.documentContentItem = null;
            throw new ContentProcessingException("Failed to write content", (Exception)((Object)e));
        }
        catch (ContentIOException e) {
            this.writer = null;
            this.documentContentItem = null;
            throw new ContentProcessingException("Failed to write content", (Exception)((Object)e));
        }
    }

    public void close() {
    }
}

