/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.csv;

import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.DisplayAllFlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.FlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.csv.CSVPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.csv.helper.CSVOutputProcessorMetaData;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.NameGenerator;

public class FlowCSVOutputProcessor
extends AbstractTableOutputProcessor {
    private OutputProcessorMetaData metaData;
    private FlowSelector flowSelector;
    private CSVPrinter printer;

    public FlowCSVOutputProcessor(Configuration config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.metaData = new CSVOutputProcessorMetaData(config, 1);
        this.flowSelector = new DisplayAllFlowSelector();
        this.printer = new CSVPrinter(config);
    }

    public String getEncoding() {
        return this.printer.getEncoding();
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        this.printer.setEncoding(encoding);
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public void setFlowSelector(FlowSelector flowSelector) {
        this.flowSelector = flowSelector;
    }

    public FlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    protected void processTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer) throws ContentProcessingException {
        this.printer.print(logicalPage, contentProducer, this.metaData, false);
    }

    protected void updateTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPageBox, TableContentProducer tableContentProducer, boolean performOutput) throws ContentProcessingException {
        this.printer.print(logicalPageBox, tableContentProducer, this.metaData, true);
    }

    protected void processingContentFinished() {
        if (!this.isContentGeneratable()) {
            return;
        }
        this.printer.close();
        this.metaData.commit();
    }

    public ContentLocation getContentLocation() {
        return this.printer.getContentLocation();
    }

    public void setContentLocation(ContentLocation contentLocation) {
        this.printer.setContentLocation(contentLocation);
    }

    public NameGenerator getContentNameGenerator() {
        return this.printer.getContentNameGenerator();
    }

    public void setContentNameGenerator(NameGenerator contentNameGenerator) {
        this.printer.setContentNameGenerator(contentNameGenerator);
    }
}

