/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.csv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.DisplayAllFlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.FlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.PhysicalPageKey;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.csv.CSVPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.csv.helper.CSVOutputProcessorMetaData;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.NameGenerator;

public class PageableCSVOutputProcessor
extends AbstractTableOutputProcessor
implements PageableOutputProcessor {
    private List physicalPages;
    private OutputProcessorMetaData metaData;
    private CSVPrinter printer;
    private FlowSelector flowSelector;

    public PageableCSVOutputProcessor(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.physicalPages = new ArrayList();
        this.metaData = new CSVOutputProcessorMetaData(configuration, 2);
        this.flowSelector = new DisplayAllFlowSelector();
        this.printer = new CSVPrinter(configuration);
    }

    public String getEncoding() {
        return this.printer.getEncoding();
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        this.printer.setEncoding(encoding);
    }

    protected void processingPagesFinished() {
        super.processingPagesFinished();
        this.physicalPages = Collections.unmodifiableList(this.physicalPages);
    }

    public int getPhysicalPageCount() {
        return this.physicalPages.size();
    }

    public PhysicalPageKey getPhysicalPage(int page) {
        if (!this.isPaginationFinished()) {
            throw new IllegalStateException();
        }
        return (PhysicalPageKey)this.physicalPages.get(page);
    }

    protected LogicalPageKey createLogicalPage(int width, int height) {
        LogicalPageKey key = super.createLogicalPage(width, height);
        for (int h = 0; h < key.getHeight(); ++h) {
            for (int w = 0; w < key.getWidth(); ++w) {
                this.physicalPages.add(key.getPage(w, h));
            }
        }
        return key;
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public FlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    public void setFlowSelector(FlowSelector flowSelector) {
        this.flowSelector = flowSelector;
    }

    protected void processTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer) throws ContentProcessingException {
        this.printer.print(logicalPage, contentProducer, this.metaData, false);
    }

    protected void processingContentFinished() {
        if (!this.isContentGeneratable()) {
            return;
        }
        this.metaData.commit();
        this.printer.close();
    }

    public ContentLocation getContentLocation() {
        return this.printer.getContentLocation();
    }

    public void setContentLocation(ContentLocation contentLocation) {
        this.printer.setContentLocation(contentLocation);
    }

    public NameGenerator getContentNameGenerator() {
        return this.printer.getContentNameGenerator();
    }

    public void setContentNameGenerator(NameGenerator contentNameGenerator) {
        this.printer.setContentNameGenerator(contentNameGenerator);
    }
}

