/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.csv.helper;

import org.pentaho.reporting.engine.classic.core.Anchor;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class CSVOutputProcessorMetaData
extends AbstractOutputProcessorMetaData {
    public static final int PAGINATION_NONE = 0;
    public static final int PAGINATION_MANUAL = 1;
    public static final int PAGINATION_FULL = 2;

    public CSVOutputProcessorMetaData(Configuration configuration, int paginationMode) {
        super(configuration);
        String localStrict = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.StrictLayout");
        if (localStrict != null) {
            if ("true".equals(localStrict)) {
                this.addFeature(AbstractTableOutputProcessor.STRICT_LAYOUT);
            }
        } else {
            String globalStrict = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.StrictLayout");
            if ("true".equals(globalStrict)) {
                this.addFeature(AbstractTableOutputProcessor.STRICT_LAYOUT);
            }
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.UsePageBands"))) {
            this.addFeature(OutputProcessorFeature.PAGE_SECTIONS);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.UsePageBands"))) {
            this.addFeature(OutputProcessorFeature.PAGE_SECTIONS);
        }
        if (paginationMode == 2) {
            this.addFeature(OutputProcessorFeature.PAGEBREAKS);
        } else if (paginationMode == 1) {
            this.addFeature(OutputProcessorFeature.PAGEBREAKS);
            this.addFeature(OutputProcessorFeature.ITERATIVE_RENDERING);
            this.addFeature(OutputProcessorFeature.UNALIGNED_PAGEBANDS);
        } else {
            this.addFeature(OutputProcessorFeature.ITERATIVE_RENDERING);
            this.addFeature(OutputProcessorFeature.UNALIGNED_PAGEBANDS);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.AssumeOverflowX"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_X);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.csv.AssumeOverflowY"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_Y);
        }
    }

    public boolean isContentSupported(Object content) {
        if (content instanceof Anchor) {
            return false;
        }
        if (content instanceof ImageContainer) {
            return false;
        }
        if (content instanceof DrawableWrapper) {
            return false;
        }
        return super.isContentSupported(content);
    }

    public String getExportDescriptor() {
        return "table/csv";
    }
}

