/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.FlowReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FileSystemURLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FlowHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.SingleRepositoryURLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.StreamHtmlOutputProcessor;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.file.FileRepository;
import org.pentaho.reporting.libraries.repository.stream.StreamRepository;
import org.pentaho.reporting.libraries.repository.zipwriter.ZipRepository;

public final class HtmlReportUtil {
    private static final Log logger = LogFactory.getLog(HtmlReportUtil.class);

    private HtmlReportUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createStreamHTML(MasterReport report, String filename) throws IOException, ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (filename == null) {
            throw new NullPointerException();
        }
        File file = new File(filename);
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(file));
        try {
            HtmlReportUtil.createStreamHTML(report, fout);
        }
        finally {
            ((OutputStream)fout).close();
        }
    }

    public static void createStreamHTML(MasterReport report, OutputStream outputStream) throws ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (outputStream == null) {
            throw new NullPointerException();
        }
        StreamRepository targetRepository = new StreamRepository(outputStream);
        ContentLocation targetRoot = targetRepository.getRoot();
        StreamHtmlOutputProcessor outputProcessor = new StreamHtmlOutputProcessor(report.getConfiguration());
        AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(report.getResourceManager());
        printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, "index", "html"));
        printer.setDataWriter(null, null);
        printer.setUrlRewriter(new FileSystemURLRewriter());
        outputProcessor.setPrinter(printer);
        StreamReportProcessor sp = new StreamReportProcessor(report, outputProcessor);
        sp.processReport();
        sp.close();
    }

    public static void createDirectoryHTML(MasterReport report, String targetFileName) throws IOException, ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (targetFileName == null) {
            throw new NullPointerException();
        }
        try {
            File targetFile = new File(targetFileName).getCanonicalFile();
            if (targetFile.exists() && !targetFile.delete()) {
                throw new IOException("Unable to remove the already existing target-file.");
            }
            File targetDirectory = targetFile.getParentFile();
            if (!targetDirectory.exists() && !targetDirectory.mkdirs()) {
                throw new IOException("Unable to create the target-directory.");
            }
            FileRepository targetRepository = new FileRepository(targetDirectory);
            ContentLocation targetRoot = targetRepository.getRoot();
            String suffix = HtmlReportUtil.getSuffix(targetFileName);
            String filename = IOUtils.getInstance().stripFileExtension(targetFile.getName());
            FlowHtmlOutputProcessor outputProcessor = new FlowHtmlOutputProcessor(report.getConfiguration());
            AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(report.getResourceManager());
            printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, filename, suffix));
            printer.setDataWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, "content"));
            printer.setUrlRewriter(new FileSystemURLRewriter());
            outputProcessor.setPrinter(printer);
            FlowReportProcessor sp = new FlowReportProcessor(report, outputProcessor);
            sp.processReport();
            sp.close();
        }
        catch (ContentIOException e) {
            throw new IOException("Failed to get or create the repository-root.");
        }
    }

    public static void createDirectoryHTML(MasterReport report, String targetFileName, String dataDirectoryName) throws IOException, ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (targetFileName == null) {
            throw new NullPointerException();
        }
        if (dataDirectoryName == null) {
            throw new NullPointerException();
        }
        try {
            File targetFile = new File(targetFileName);
            if (targetFile.exists() && !targetFile.delete()) {
                throw new IOException("Unable to remove the already existing target-file.");
            }
            File targetDirectory = targetFile.getParentFile().getCanonicalFile();
            if (!targetDirectory.exists() && !targetDirectory.mkdirs()) {
                throw new IOException("Unable to create the target-directory.");
            }
            File tempDataDir = new File(dataDirectoryName).getCanonicalFile();
            File dataDirectory = tempDataDir.isAbsolute() ? tempDataDir : new File(targetDirectory, dataDirectoryName).getCanonicalFile();
            if (dataDirectory.exists() && !dataDirectory.isDirectory()) {
                if (!(dataDirectory = dataDirectory.getParentFile()).isDirectory()) {
                    throw new ReportProcessingException("DataDirectory is invalid: " + dataDirectory);
                }
            } else if (!dataDirectory.exists() && !dataDirectory.mkdirs()) {
                throw new IOException("Unable to create the data-directory.");
            }
            FileRepository targetRepository = new FileRepository(targetDirectory);
            ContentLocation targetRoot = targetRepository.getRoot();
            FileRepository dataRepository = new FileRepository(dataDirectory);
            ContentLocation dataRoot = dataRepository.getRoot();
            String suffix = HtmlReportUtil.getSuffix(targetFileName);
            String filename = IOUtils.getInstance().stripFileExtension(targetFile.getName());
            FlowHtmlOutputProcessor outputProcessor = new FlowHtmlOutputProcessor(report.getConfiguration());
            AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(report.getResourceManager());
            printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, filename, suffix));
            printer.setDataWriter(dataRoot, (NameGenerator)new DefaultNameGenerator(dataRoot, "content"));
            printer.setUrlRewriter(new FileSystemURLRewriter());
            outputProcessor.setPrinter(printer);
            FlowReportProcessor sp = new FlowReportProcessor(report, outputProcessor);
            sp.processReport();
            sp.close();
        }
        catch (ContentIOException e) {
            throw new IOException("Failed to get repository-root.");
        }
    }

    private static String getSuffix(String filename) {
        String suffix = IOUtils.getInstance().getFileExtension(filename);
        if (suffix.length() == 0) {
            return "";
        }
        return suffix.substring(1);
    }

    public static void createZIPHTML(MasterReport report, String filename) throws IOException, ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (filename == null) {
            throw new NullPointerException();
        }
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(filename));
            HtmlReportUtil.createZIPHTML(report, out, "report");
            out.close();
            out = null;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ReportProcessingException re) {
            throw re;
        }
        catch (Exception re) {
            throw new ReportProcessingException("Failed to process the report", re);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unable to close the output stream.", (Throwable)e);
            }
        }
    }

    public static void createZIPHTML(MasterReport report, OutputStream out, String filename) throws IOException, ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (filename == null) {
            throw new NullPointerException();
        }
        if (out == null) {
            throw new NullPointerException();
        }
        try {
            ZipRepository zipRepository = new ZipRepository(out);
            ContentLocation root = zipRepository.getRoot();
            ContentLocation data = RepositoryUtilities.createLocation((Repository)zipRepository, (String[])RepositoryUtilities.splitPath((String)"data", (String)"/"));
            FlowHtmlOutputProcessor outputProcessor = new FlowHtmlOutputProcessor(report.getConfiguration());
            AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(report.getResourceManager());
            printer.setContentWriter(root, (NameGenerator)new DefaultNameGenerator(root, filename));
            printer.setDataWriter(data, (NameGenerator)new DefaultNameGenerator(data, "content"));
            printer.setUrlRewriter(new SingleRepositoryURLRewriter());
            outputProcessor.setPrinter(printer);
            FlowReportProcessor sp = new FlowReportProcessor(report, outputProcessor);
            sp.processReport();
            sp.close();
            zipRepository.close();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ReportProcessingException re) {
            throw re;
        }
        catch (Exception re) {
            throw new ReportProcessingException("Failed to process the report", re);
        }
    }
}

