/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html;

import java.io.IOException;
import java.text.NumberFormat;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.URLImageContainer;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.imagemap.parser.ImageMapWriter;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContent;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.model.SpacerRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.layout.text.GlyphList;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.DefaultTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlContentGenerator;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.DefaultStyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlOutputProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlTextExtractorState;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleManager;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.CharacterEntityParser;
import org.pentaho.reporting.libraries.xmlns.writer.HtmlCharacterEntities;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class HtmlTextExtractor
extends DefaultTextExtractor {
    private static final String DIV_TAG = "div";
    private static final String HREF_ATTR = "href";
    private static final String TARGET_ATTR = "target";
    private static final String TITLE_ATTR = "title";
    private static final String A_TAG = "a";
    private static final String BR_TAG = "br";
    private static final String SPAN_TAG = "span";
    private static final String IMG_TAG = "img";
    private static final String SRC_ATTR = "src";
    private static final String USEMAP_ATTR = "usemap";
    private static final String PT_UNIT = "pt";
    private static final String PX_UNIT = "px";
    private static final String ALT_ATTR = "alt";
    private OutputProcessorMetaData metaData;
    private XmlWriter xmlWriter;
    private StyleManager styleManager;
    private StyleBuilder styleBuilder;
    private HtmlContentGenerator contentGenerator;
    private CharacterEntityParser characterEntityParser;
    private boolean result;
    private boolean safariLengthFix;
    private RenderBox firstElement;
    private boolean useWhitespacePreWrap;
    private boolean enableRoundBorderCorner;
    private HtmlTextExtractorState processStack;
    private boolean enableInheritedLinkStyle;

    public HtmlTextExtractor(OutputProcessorMetaData metaData, XmlWriter xmlWriter, StyleManager styleManager, HtmlContentGenerator contentGenerator) {
        super(metaData);
        if (xmlWriter == null) {
            throw new NullPointerException();
        }
        if (styleManager == null) {
            throw new NullPointerException();
        }
        if (contentGenerator == null) {
            throw new NullPointerException();
        }
        this.contentGenerator = contentGenerator;
        this.metaData = metaData;
        this.xmlWriter = xmlWriter;
        this.styleManager = styleManager;
        this.styleBuilder = new DefaultStyleBuilder();
        this.characterEntityParser = HtmlCharacterEntities.getEntityParser();
        this.safariLengthFix = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.SafariLengthHack"));
        this.useWhitespacePreWrap = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.UseWhitespacePreWrap"));
        this.enableRoundBorderCorner = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.EnableRoundBorderCorner"));
        this.enableInheritedLinkStyle = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.LinksInheritStyle"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performOutput(RenderBox content, StyleBuilder.StyleCarrier[] cellStyle) throws IOException {
        this.styleBuilder.clear();
        this.clearText();
        this.setRawResult(null);
        this.result = false;
        this.processStack = new HtmlTextExtractorState(null, false, cellStyle);
        this.firstElement = content;
        try {
            int nodeType = content.getNodeType();
            if (nodeType == 274) {
                this.processParagraphCell((ParagraphRenderBox)content);
            } else if (nodeType == 258) {
                this.processRenderableContent((RenderableReplacedContentBox)content);
            } else {
                this.processBoxChilds(content);
            }
        }
        finally {
            this.processStack = null;
            this.firstElement = null;
        }
        return this.result;
    }

    public boolean startCanvasBox(CanvasRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        try {
            StyleSheet styleSheet;
            String target;
            ReportAttributeMap attrs = box.getAttributes();
            if (this.firstElement != box) {
                AttributeList attrList = new AttributeList();
                HtmlPrinter.applyHtmlAttributes(attrs, attrList);
                if (!attrList.isEmpty()) {
                    this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", DIV_TAG, attrList, false);
                }
                this.processStack = new HtmlTextExtractorState(this.processStack, true);
            } else {
                this.processStack = new HtmlTextExtractorState(this.processStack, false);
            }
            Object rawContent = attrs.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-content");
            if (rawContent != null) {
                this.xmlWriter.writeText(String.valueOf(rawContent));
            }
            if ((target = (String)(styleSheet = box.getStyleSheet()).getStyleProperty(ElementStyleKeys.HREF_TARGET)) != null) {
                this.handleLinkOnElement(styleSheet, target);
                this.processStack = new HtmlTextExtractorState(this.processStack, true);
            } else {
                this.processStack = new HtmlTextExtractorState(this.processStack, false);
            }
            return !Boolean.TRUE.equals(attrs.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "surpress-content"));
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    private String normalizeWindow(String window) {
        if ("_top".equalsIgnoreCase(window)) {
            return "_top";
        }
        if ("_self".equalsIgnoreCase(window)) {
            return "_self";
        }
        if ("_parent".equalsIgnoreCase(window)) {
            return "_parent";
        }
        if ("_blank".equalsIgnoreCase(window)) {
            return "_blank";
        }
        return window;
    }

    public void finishCanvasBox(CanvasRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return;
        }
        try {
            if (this.processStack.isWrittenTag()) {
                this.xmlWriter.writeCloseTag();
            }
            this.processStack = this.processStack.getParent();
            Object rawFooterContent = box.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-footer-content");
            if (rawFooterContent != null) {
                this.xmlWriter.writeText(String.valueOf(rawFooterContent));
            }
            if (this.processStack.isWrittenTag()) {
                this.xmlWriter.writeCloseTag();
            }
            this.processStack = this.processStack.getParent();
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    protected void processParagraphCell(ParagraphRenderBox box) throws IOException {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return;
        }
        StyleSheet styleSheet = box.getStyleSheet();
        String target = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TARGET);
        if (target != null) {
            this.handleLinkOnElement(styleSheet, target);
            this.processStack = new HtmlTextExtractorState(this.processStack, true);
        } else {
            this.processStack = new HtmlTextExtractorState(this.processStack, false);
        }
        if (!Boolean.TRUE.equals(box.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "surpress-content"))) {
            this.processParagraphChilds(box);
        }
        if (this.processStack.isWrittenTag()) {
            this.xmlWriter.writeCloseTag();
        }
        this.processStack = this.processStack.getParent();
    }

    protected void addEmptyBreak() {
        try {
            this.xmlWriter.writeText(" ");
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    protected void addSoftBreak() {
        try {
            this.xmlWriter.writeText(" ");
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    protected void addLinebreak() {
        try {
            this.result = true;
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", BR_TAG, true);
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    protected boolean startBlockBox(BlockRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        try {
            String target;
            AttributeList attrList = new AttributeList();
            ReportAttributeMap attrs = box.getAttributes();
            if (this.firstElement != box) {
                HtmlPrinter.applyHtmlAttributes(attrs, attrList);
                StyleBuilder style = HtmlPrinter.produceTextStyle(this.styleBuilder, box, true, this.safariLengthFix, this.useWhitespacePreWrap, this.enableRoundBorderCorner, this.processStack.getStyle());
                this.styleManager.updateStyle(style, attrList);
            }
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", DIV_TAG, attrList, false);
            this.processStack = new HtmlTextExtractorState(this.processStack, true, this.styleBuilder.toArray());
            Object rawContent = attrs.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-content");
            if (rawContent != null) {
                this.xmlWriter.writeText(String.valueOf(rawContent));
            }
            StyleSheet styleSheet = box.getStyleSheet();
            if (this.firstElement != box) {
                this.writeLocalAnchor(box);
            }
            if ((target = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TARGET)) != null) {
                this.handleLinkOnElement(styleSheet, target);
                this.processStack = new HtmlTextExtractorState(this.processStack, true);
            } else {
                this.processStack = new HtmlTextExtractorState(this.processStack, false);
            }
            return !Boolean.TRUE.equals(attrs.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "surpress-content"));
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    private void handleLinkOnElement(StyleSheet styleSheet, String target) throws IOException {
        String title;
        String window = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_WINDOW);
        AttributeList linkAttr = new AttributeList();
        linkAttr.setAttribute("http://www.w3.org/1999/xhtml", HREF_ATTR, target);
        if (window != null && !StringUtils.startsWithIgnoreCase((String)target, (String)"javascript:")) {
            linkAttr.setAttribute("http://www.w3.org/1999/xhtml", TARGET_ATTR, this.normalizeWindow(window));
        }
        if ((title = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TITLE)) != null) {
            linkAttr.setAttribute("http://www.w3.org/1999/xhtml", TITLE_ATTR, title);
        }
        if (this.enableInheritedLinkStyle) {
            this.styleBuilder = this.createLinkStyle(this.styleBuilder);
            this.styleManager.updateStyle(this.styleBuilder, linkAttr);
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", A_TAG, linkAttr, false);
    }

    private StyleBuilder createLinkStyle(StyleBuilder b) {
        if (b == null) {
            b = new DefaultStyleBuilder();
        }
        b.append(StyleBuilder.CSSKeys.FONT_STYLE, "inherit");
        b.append(StyleBuilder.CSSKeys.FONT_FAMILY, "inherit");
        b.append(StyleBuilder.CSSKeys.FONT_WEIGHT, "inherit");
        b.append(StyleBuilder.CSSKeys.FONT_SIZE, "inherit");
        b.append(StyleBuilder.CSSKeys.TEXT_DECORATION, "inherit");
        b.append(StyleBuilder.CSSKeys.COLOR, "inherit");
        return b;
    }

    protected void finishBlockBox(BlockRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return;
        }
        try {
            if (this.processStack.isWrittenTag()) {
                this.xmlWriter.writeCloseTag();
            }
            this.processStack = this.processStack.getParent();
            Object rawFooterContent = box.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-footer-content");
            if (rawFooterContent != null) {
                this.xmlWriter.writeText(String.valueOf(rawFooterContent));
            }
            if (this.processStack.isWrittenTag()) {
                this.xmlWriter.writeCloseTag();
            }
            this.processStack = this.processStack.getParent();
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    protected boolean startRowBox(RenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        try {
            String target;
            AttributeList attrList = new AttributeList();
            ReportAttributeMap attrs = box.getAttributes();
            if (this.firstElement != box) {
                HtmlPrinter.applyHtmlAttributes(attrs, attrList);
                StyleBuilder style = HtmlPrinter.produceTextStyle(this.styleBuilder, box, true, this.safariLengthFix, this.useWhitespacePreWrap, this.enableRoundBorderCorner, this.processStack.getStyle());
                this.styleManager.updateStyle(style, attrList);
            }
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", DIV_TAG, attrList, false);
            this.processStack = new HtmlTextExtractorState(this.processStack, true, this.styleBuilder.toArray());
            Object rawContent = attrs.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-content");
            if (rawContent != null) {
                this.xmlWriter.writeText(String.valueOf(rawContent));
            }
            StyleSheet styleSheet = box.getStyleSheet();
            if (this.firstElement != box) {
                this.writeLocalAnchor(box);
            }
            if ((target = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TARGET)) != null) {
                this.handleLinkOnElement(styleSheet, target);
                this.processStack = new HtmlTextExtractorState(this.processStack, true);
            } else {
                this.processStack = new HtmlTextExtractorState(this.processStack, false);
            }
            return !Boolean.TRUE.equals(attrs.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "surpress-content"));
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    protected void finishRowBox(RenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return;
        }
        try {
            if (this.processStack.isWrittenTag()) {
                this.xmlWriter.writeCloseTag();
            }
            this.processStack = this.processStack.getParent();
            Object rawFooterContent = box.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-footer-content");
            if (rawFooterContent != null) {
                this.xmlWriter.writeText(String.valueOf(rawFooterContent));
            }
            if (this.processStack.isWrittenTag()) {
                this.xmlWriter.writeCloseTag();
            }
            this.processStack = this.processStack.getParent();
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        try {
            String target;
            ReportAttributeMap attrs = box.getAttributes();
            if (this.firstElement != box) {
                AttributeList attrList = new AttributeList();
                HtmlPrinter.applyHtmlAttributes(attrs, attrList);
                StyleBuilder style = HtmlPrinter.produceTextStyle(this.styleBuilder, box, true, this.safariLengthFix, this.useWhitespacePreWrap, this.enableRoundBorderCorner, this.processStack.getStyle());
                this.styleManager.updateStyle(style, attrList);
                if (!attrList.isEmpty()) {
                    this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", SPAN_TAG, attrList, false);
                    this.processStack = new HtmlTextExtractorState(this.processStack, true, this.styleBuilder.toArray());
                } else {
                    this.processStack = new HtmlTextExtractorState(this.processStack, false);
                }
            } else {
                this.processStack = new HtmlTextExtractorState(this.processStack, false);
            }
            Object rawContent = attrs.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-content");
            if (rawContent != null) {
                this.xmlWriter.writeText(String.valueOf(rawContent));
            }
            StyleSheet styleSheet = box.getStyleSheet();
            if (this.firstElement != box) {
                this.writeLocalAnchor(box);
            }
            if ((target = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TARGET)) != null) {
                this.handleLinkOnElement(styleSheet, target);
                this.processStack = new HtmlTextExtractorState(this.processStack, true);
            } else {
                this.processStack = new HtmlTextExtractorState(this.processStack, false);
            }
            return !Boolean.TRUE.equals(attrs.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "surpress-content"));
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    protected void finishInlineBox(InlineRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return;
        }
        try {
            if (this.processStack.isWrittenTag()) {
                this.xmlWriter.writeCloseTag();
            }
            this.processStack = this.processStack.getParent();
            Object rawFooterContent = box.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-footer-content");
            if (rawFooterContent != null) {
                this.xmlWriter.writeText(String.valueOf(rawFooterContent));
            }
            if (this.processStack.isWrittenTag()) {
                this.xmlWriter.writeCloseTag();
            }
            this.processStack = this.processStack.getParent();
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    protected void processOtherNode(RenderNode node) {
        try {
            int nodeType = node.getNodeType();
            if (nodeType == 17) {
                super.processOtherNode(node);
                return;
            }
            if (node.isVirtualNode()) {
                return;
            }
            if (nodeType == 65) {
                SpacerRenderNode spacer = (SpacerRenderNode)node;
                int count = Math.max(1, spacer.getSpaceCount());
                for (int i = 0; i < count; ++i) {
                    this.xmlWriter.writeText(" ");
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed", e);
        }
    }

    protected void processRenderableContent(RenderableReplacedContentBox node) {
        try {
            ReportAttributeMap map = node.getAttributes();
            AttributeList attrs = new AttributeList();
            HtmlPrinter.applyHtmlAttributes(map, attrs);
            if (!attrs.isEmpty()) {
                this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", DIV_TAG, attrs, false);
            }
            this.writeLocalAnchor(node);
            StyleSheet styleSheet = node.getStyleSheet();
            String target = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TARGET);
            if (target != null) {
                this.handleLinkOnElement(styleSheet, target);
            }
            this.processReplacedContent(node);
            if (target != null) {
                this.xmlWriter.writeCloseTag();
            }
            if (!attrs.isEmpty()) {
                this.xmlWriter.writeCloseTag();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed", e);
        }
        catch (ContentIOException e) {
            throw new RuntimeException("Failed", e);
        }
    }

    private void writeLocalAnchor(RenderNode node) throws IOException {
        StyleSheet styleSheet = node.getStyleSheet();
        String anchor = (String)styleSheet.getStyleProperty(ElementStyleKeys.ANCHOR_NAME);
        if (anchor != null) {
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", A_TAG, "name", anchor, true);
        }
    }

    private void processReplacedContent(RenderableReplacedContentBox node) throws IOException, ContentIOException {
        URLImageContainer urlImageContainer;
        ResourceKey source;
        RenderableReplacedContent rc = node.getContent();
        Object rawObject = rc.getRawObject();
        if (rawObject instanceof URLImageContainer && (source = (urlImageContainer = (URLImageContainer)rawObject).getResourceKey()) != null) {
            if (!this.contentGenerator.isRegistered(source)) {
                String name = this.contentGenerator.writeRaw(source);
                if (name != null) {
                    AttributeList attrList = new AttributeList();
                    attrList.setAttribute("http://www.w3.org/1999/xhtml", SRC_ATTR, name);
                    attrList.setAttribute("http://www.w3.org/1999/xhtml", "border", "0");
                    StyleBuilder imgStyle = this.produceImageStyle(node);
                    if (imgStyle == null) {
                        AttributeList clipAttrList = new AttributeList();
                        StyleBuilder divStyle = this.produceClipStyle(node);
                        this.styleManager.updateStyle(divStyle, clipAttrList);
                        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", DIV_TAG, clipAttrList, false);
                        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", IMG_TAG, attrList, true);
                        this.xmlWriter.writeCloseTag();
                    } else {
                        this.styleManager.updateStyle(imgStyle, attrList);
                        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", IMG_TAG, attrList, true);
                    }
                    this.contentGenerator.registerContent(source, name);
                    this.result = true;
                    return;
                }
                this.contentGenerator.registerFailure(source);
            } else {
                String cachedName = this.contentGenerator.getRegisteredName(source);
                if (cachedName != null) {
                    AttributeList attrList = new AttributeList();
                    attrList.setAttribute("http://www.w3.org/1999/xhtml", SRC_ATTR, cachedName);
                    attrList.setAttribute("http://www.w3.org/1999/xhtml", "border", "0");
                    StyleBuilder imgStyle = this.produceImageStyle(node);
                    if (imgStyle == null) {
                        AttributeList clipAttrList = new AttributeList();
                        StyleBuilder divStyle = this.produceClipStyle(node);
                        this.styleManager.updateStyle(divStyle, clipAttrList);
                        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", DIV_TAG, clipAttrList, false);
                        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", IMG_TAG, attrList, true);
                        this.xmlWriter.writeCloseTag();
                    } else {
                        this.styleManager.updateStyle(imgStyle, attrList);
                        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", IMG_TAG, attrList, true);
                    }
                    this.result = true;
                    return;
                }
            }
        }
        ReportAttributeMap attributes = node.getAttributes();
        if (rawObject instanceof ImageContainer) {
            float quality;
            String type = RenderUtility.getEncoderType(attributes);
            String name = this.contentGenerator.writeImage((ImageContainer)rawObject, type, quality = RenderUtility.getEncoderQuality(attributes), true);
            if (name != null) {
                StyleBuilder imgStyle;
                Object altText;
                AttributeList attrList = new AttributeList();
                attrList.setAttribute("http://www.w3.org/1999/xhtml", SRC_ATTR, name);
                attrList.setAttribute("http://www.w3.org/1999/xhtml", "border", "0");
                Object titleText = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", TITLE_ATTR);
                if (titleText != null) {
                    attrList.setAttribute("http://www.w3.org/1999/xhtml", TITLE_ATTR, String.valueOf(titleText));
                }
                if ((altText = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", ALT_ATTR)) != null) {
                    attrList.setAttribute("http://www.w3.org/1999/xhtml", ALT_ATTR, String.valueOf(altText));
                }
                if ((imgStyle = this.produceImageStyle(node)) == null) {
                    AttributeList clipAttrList = new AttributeList();
                    StyleBuilder divStyle = this.produceClipStyle(node);
                    this.styleManager.updateStyle(divStyle, clipAttrList);
                    this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", DIV_TAG, clipAttrList, false);
                    this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", IMG_TAG, attrList, true);
                    this.xmlWriter.writeCloseTag();
                } else {
                    this.styleManager.updateStyle(imgStyle, attrList);
                    this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", IMG_TAG, attrList, true);
                }
                this.result = true;
            }
            return;
        }
        if (rawObject instanceof DrawableWrapper) {
            StyleBuilder imgStyle;
            Object altText;
            ImageMap imageMap;
            float quality;
            DrawableWrapper drawable = (DrawableWrapper)rawObject;
            StrictBounds cb = new StrictBounds(node.getX(), node.getY(), node.getWidth(), node.getHeight());
            ImageContainer image = RenderUtility.createImageFromDrawable(drawable, cb, node, this.metaData);
            if (image == null) {
                return;
            }
            String type = RenderUtility.getEncoderType(attributes);
            String name = this.contentGenerator.writeImage(image, type, quality = RenderUtility.getEncoderQuality(attributes), true);
            if (name == null) {
                return;
            }
            AttributeList attrList = new AttributeList();
            attrList.setAttribute("http://www.w3.org/1999/xhtml", SRC_ATTR, name);
            attrList.setAttribute("http://www.w3.org/1999/xhtml", "border", "0");
            Object imageMapNameOverride = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", USEMAP_ATTR);
            if (imageMapNameOverride != null) {
                attrList.setAttribute("http://www.w3.org/1999/xhtml", USEMAP_ATTR, String.valueOf(imageMapNameOverride));
                imageMap = null;
            } else {
                imageMap = RenderUtility.extractImageMap(node);
                if (imageMap != null) {
                    String mapName = imageMap.getAttribute("http://www.w3.org/1999/xhtml", "name");
                    if (mapName != null) {
                        attrList.setAttribute("http://www.w3.org/1999/xhtml", USEMAP_ATTR, "#" + mapName);
                    } else {
                        String generatedName = "generated_" + name + "_map";
                        imageMap.setAttribute("http://www.w3.org/1999/xhtml", "name", generatedName);
                        attrList.setAttribute("http://www.w3.org/1999/xhtml", USEMAP_ATTR, '#' + generatedName);
                    }
                }
            }
            Object titleText = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", TITLE_ATTR);
            if (titleText != null) {
                attrList.setAttribute("http://www.w3.org/1999/xhtml", TITLE_ATTR, String.valueOf(titleText));
            }
            if ((altText = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", ALT_ATTR)) != null) {
                attrList.setAttribute("http://www.w3.org/1999/xhtml", ALT_ATTR, String.valueOf(altText));
            }
            if ((imgStyle = this.produceImageStyle(node)) == null) {
                AttributeList clipAttrList = new AttributeList();
                StyleBuilder divStyle = this.produceClipStyle(node);
                this.styleManager.updateStyle(divStyle, clipAttrList);
                this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", DIV_TAG, clipAttrList, false);
                this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", IMG_TAG, attrList, true);
                this.xmlWriter.writeCloseTag();
            } else {
                this.styleManager.updateStyle(imgStyle, attrList);
                this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", IMG_TAG, attrList, true);
            }
            if (imageMap != null) {
                ImageMapWriter.writeImageMap(this.xmlWriter, imageMap, RenderUtility.getNormalizationScale(this.metaData));
            }
            this.result = true;
        }
    }

    private StyleBuilder produceClipStyle(RenderableReplacedContentBox rc) {
        this.styleBuilder.clear();
        long nodeWidth = rc.getWidth();
        long nodeHeight = rc.getHeight();
        NumberFormat pointConverter = this.styleBuilder.getPointConverter();
        this.styleBuilder.append(StyleBuilder.CSSKeys.OVERFLOW, "hidden");
        this.styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue(nodeWidth), this.safariLengthFix)), PT_UNIT);
        this.styleBuilder.append(StyleBuilder.CSSKeys.HEIGHT, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue(nodeHeight), this.safariLengthFix)), PT_UNIT);
        return this.styleBuilder;
    }

    private StyleBuilder produceImageStyle(RenderableReplacedContentBox rc) {
        this.styleBuilder.clear();
        NumberFormat pointConverter = this.styleBuilder.getPointConverter();
        RenderableReplacedContent content = rc.getContent();
        long contentWidth = content.getContentWidth();
        long nodeWidth = rc.getWidth();
        long contentHeight = content.getContentHeight();
        long nodeHeight = rc.getHeight();
        double scale = RenderUtility.getNormalizationScale(this.metaData);
        StyleSheet styleSheet = rc.getStyleSheet();
        if (styleSheet.getBooleanStyleProperty(ElementStyleKeys.SCALE)) {
            if (styleSheet.getBooleanStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO) && contentWidth > 0L && contentHeight > 0L) {
                double scaleFactor = Math.min((double)nodeWidth / (double)contentWidth, (double)nodeHeight / (double)contentHeight);
                this.styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)contentWidth * scaleFactor * scale)), this.safariLengthFix)), PX_UNIT);
                this.styleBuilder.append(StyleBuilder.CSSKeys.HEIGHT, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)contentHeight * scaleFactor * scale)), this.safariLengthFix)), PX_UNIT);
            } else {
                this.styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)nodeWidth * scale)), this.safariLengthFix)), PX_UNIT);
                this.styleBuilder.append(StyleBuilder.CSSKeys.HEIGHT, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)nodeHeight * scale)), this.safariLengthFix)), PX_UNIT);
            }
        } else {
            if (contentWidth > nodeWidth || contentHeight > nodeHeight) {
                return null;
            }
            if (contentWidth == 0L && contentHeight == 0L) {
                this.styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)nodeWidth * scale)), this.safariLengthFix)), PX_UNIT);
                this.styleBuilder.append(StyleBuilder.CSSKeys.HEIGHT, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)nodeHeight * scale)), this.safariLengthFix)), PX_UNIT);
            } else {
                long width = Math.min(nodeWidth, contentWidth);
                long height = Math.min(nodeHeight, contentHeight);
                this.styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)width * scale)), this.safariLengthFix)), PX_UNIT);
                this.styleBuilder.append(StyleBuilder.CSSKeys.HEIGHT, pointConverter.format(HtmlPrinter.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)height * scale)), this.safariLengthFix)), PX_UNIT);
            }
        }
        return this.styleBuilder;
    }

    protected void drawText(RenderableText renderableText, long contentX2) {
        try {
            if (renderableText.getLength() == 0) {
                return;
            }
            if (!renderableText.isNodeVisible(this.getParagraphBounds(), this.isOverflowX(), this.isOverflowY())) {
                return;
            }
            GlyphList gs = renderableText.getGlyphs();
            int maxLength = renderableText.computeMaximumTextSize(contentX2);
            String text = gs.getText(renderableText.getOffset(), maxLength, this.getCodePointBuffer());
            if (text.length() > 0) {
                this.xmlWriter.writeText(this.characterEntityParser.encodeEntities(text));
                if (text.trim().length() > 0) {
                    this.result = true;
                }
                this.clearText();
            }
        }
        catch (IOException ioe) {
            throw new InvalidReportStateException("Failed to write text", ioe);
        }
    }
}

