/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html;

import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.DisplayAllFlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.FlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlOutputProcessorMetaData;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class StreamHtmlOutputProcessor
extends AbstractTableOutputProcessor
implements HtmlOutputProcessor {
    private HtmlPrinter printer;
    private OutputProcessorMetaData metaData;
    private FlowSelector flowSelector;

    public StreamHtmlOutputProcessor(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.metaData = new HtmlOutputProcessorMetaData(configuration, 0);
        this.flowSelector = new DisplayAllFlowSelector();
    }

    protected FlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public HtmlPrinter getPrinter() {
        return this.printer;
    }

    public void setPrinter(HtmlPrinter printer) {
        this.printer = printer;
    }

    protected void processTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer) throws ContentProcessingException {
        if (this.printer == null) {
            return;
        }
        this.printer.print(logicalPageKey, logicalPage, contentProducer, this.metaData, false);
    }

    protected void updateTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPageBox, TableContentProducer tableContentProducer, boolean performOutput) throws ContentProcessingException {
        if (this.printer == null) {
            return;
        }
        this.printer.print(logicalPageKey, logicalPageBox, tableContentProducer, this.metaData, true);
    }

    protected void processingContentFinished() {
        if (!this.isContentGeneratable()) {
            return;
        }
        this.metaData.commit();
    }
}

