/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html;

import org.pentaho.reporting.engine.classic.core.AbstractMultiStreamReportProcessTask;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.StreamHtmlOutputProcessor;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class StreamHtmlReportProcessTask
extends AbstractMultiStreamReportProcessTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.isValid()) {
            this.setError((Throwable)((Object)new ReportProcessingException("Error: The task is not configured properly.")));
            return;
        }
        this.setError(null);
        try {
            MasterReport masterReport = this.getReport();
            Configuration configuration = masterReport.getConfiguration();
            AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(masterReport.getResourceManager());
            printer.setContentWriter(this.getBodyContentLocation(), this.getBodyNameGenerator());
            printer.setDataWriter(this.getBulkLocation(), this.getBulkNameGenerator());
            printer.setUrlRewriter(this.computeUrlRewriter());
            StreamHtmlOutputProcessor outputProcessor = new StreamHtmlOutputProcessor(configuration);
            StreamReportProcessor streamReportProcessor = new StreamReportProcessor(masterReport, outputProcessor);
            try {
                ReportProgressListener[] progressListeners = this.getReportProgressListeners();
                for (int i = 0; i < progressListeners.length; ++i) {
                    ReportProgressListener listener = progressListeners[i];
                    streamReportProcessor.addReportProgressListener(listener);
                }
                streamReportProcessor.processReport();
            }
            finally {
                streamReportProcessor.close();
            }
        }
        catch (Throwable e) {
            this.setError(e);
        }
    }

    public String getReportMimeType() {
        return "text/html";
    }
}

