/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StoredStyle;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleManager;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;

public class GlobalStyleManager
implements StyleManager {
    private static final EntryComparator comparator = new EntryComparator();
    private HashMap<StoredStyle, String> styles = new HashMap();
    private HashSet<String> stylesText = new HashSet();
    private int nameCounter;
    private String lineSeparator = StringUtils.getLineSeparator();

    public AttributeList updateStyle(StyleBuilder styleBuilder, AttributeList attributeList) {
        String attribute;
        if (styleBuilder.isEmpty()) {
            return attributeList;
        }
        StoredStyle value = new StoredStyle(styleBuilder);
        String styleText = ((Object)styleBuilder).toString();
        String styleName = this.styles.get(value);
        if (styleName == null) {
            styleName = "style-" + this.nameCounter;
            this.styles.put(value, styleName);
            if (this.stylesText.contains(styleText)) {
                throw new IllegalStateException();
            }
            this.stylesText.add(styleText);
            ++this.nameCounter;
        }
        if ((attribute = attributeList.getAttribute("http://www.w3.org/1999/xhtml", "class")) != null) {
            attributeList.setAttribute("http://www.w3.org/1999/xhtml", "class", attribute + ' ' + styleName);
        } else {
            attributeList.setAttribute("http://www.w3.org/1999/xhtml", "class", styleName);
        }
        return attributeList;
    }

    public String getGlobalStyleSheet() {
        StringBuffer b = new StringBuffer(8192);
        Map.Entry[] keys = this.styles.entrySet().toArray(new Map.Entry[this.styles.size()]);
        Arrays.sort(keys, comparator);
        for (Map.Entry entry : keys) {
            StoredStyle style = (StoredStyle)entry.getKey();
            String name = (String)entry.getValue();
            b.append('.');
            b.append(name);
            b.append(" {");
            b.append(this.lineSeparator);
            style.print(b, false);
            b.append(this.lineSeparator);
            b.append('}');
            b.append(this.lineSeparator);
            b.append(this.lineSeparator);
        }
        return b.toString();
    }

    public void write(Writer writer) throws IOException {
        Map.Entry[] keys = this.styles.entrySet().toArray(new Map.Entry[this.styles.size()]);
        Arrays.sort(keys, comparator);
        for (Map.Entry entry : keys) {
            StoredStyle style = (StoredStyle)entry.getKey();
            String name = (String)entry.getValue();
            writer.write(46);
            writer.write(name);
            writer.write(" {");
            writer.write(this.lineSeparator);
            style.print(writer, false);
            writer.write(this.lineSeparator);
            writer.write(125);
            writer.write(this.lineSeparator);
            writer.write(this.lineSeparator);
        }
    }

    private static class EntryComparator
    implements Comparator,
    Serializable {
        private EntryComparator() {
        }

        public int compare(Object o1, Object o2) {
            Map.Entry e1 = (Map.Entry)o1;
            Map.Entry e2 = (Map.Entry)o2;
            return String.valueOf(e1.getValue()).compareTo(String.valueOf(e2.getValue()));
        }
    }
}

