/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.BreakIterator;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.util.HtmlCharacterEntities;
import org.pentaho.reporting.libraries.xmlns.writer.CharacterEntityParser;

public final class HtmlEncoderUtil {
    private static final String[] HEX_CSS_ENCODING = new String[256];

    private HtmlEncoderUtil() {
    }

    public static String encodeCSS(String s) {
        StringBuffer sbuf = new StringBuffer(s.length() * 15 / 10);
        return HtmlEncoderUtil.encodeCSS(s, sbuf);
    }

    public static String encodeCSS(String s, StringBuffer sbuf) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '\"') {
                sbuf.append('\\');
                sbuf.append(ch);
                continue;
            }
            if (ch >= ' ' && ch <= '\u007f') {
                sbuf.append(ch);
                continue;
            }
            sbuf.append('\\');
            sbuf.append(HEX_CSS_ENCODING[ch >> 16 & 0xFF]);
            sbuf.append(HEX_CSS_ENCODING[ch >> 8 & 0xFF]);
            sbuf.append(HEX_CSS_ENCODING[ch & 0xFF]);
        }
        return sbuf.toString();
    }

    public static void encodeCSS(String s, Writer w) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '\"') {
                w.write(92);
                w.write(ch);
                continue;
            }
            if (ch >= ' ' && ch <= '\u007f') {
                w.write(ch);
                continue;
            }
            w.write(92);
            w.append(HEX_CSS_ENCODING[ch >> 16 & 0xFF]);
            w.append(HEX_CSS_ENCODING[ch >> 8 & 0xFF]);
            w.append(HEX_CSS_ENCODING[ch & 0xFF]);
        }
    }

    public static void printText(PrintWriter pout, String text, boolean useXHTML) {
        if (text.length() == 0) {
            return;
        }
        CharacterEntityParser entityParser = HtmlCharacterEntities.getEntityParser();
        BreakIterator instance = BreakIterator.getLineInstance();
        instance.setText(text);
        int start = instance.first();
        int end = instance.next();
        boolean flagStart = true;
        while (end != -1) {
            int whitespaceCounter;
            String readLine = text.substring(start, end);
            start = end;
            end = instance.next();
            if (flagStart) {
                flagStart = false;
            } else if (useXHTML) {
                pout.println("<br />");
            } else {
                pout.println("<br>");
            }
            for (whitespaceCounter = 0; whitespaceCounter < readLine.length() && Character.isWhitespace(readLine.charAt(whitespaceCounter)); ++whitespaceCounter) {
                pout.print("&nbsp;");
            }
            String printResult = whitespaceCounter > 0 ? readLine.substring(whitespaceCounter) : readLine;
            pout.print(entityParser.encodeEntities(printResult));
        }
    }

    static {
        for (int i = 0; i < 256; ++i) {
            String s = Integer.toHexString(i);
            HtmlEncoderUtil.HEX_CSS_ENCODING[i] = s.length() == 1 ? '0' + s : s;
        }
    }
}

