/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.rtf;

import java.io.OutputStream;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.DisplayAllFlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.FlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.helper.RTFOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.helper.RTFPrinter;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class FlowRTFOutputProcessor
extends AbstractTableOutputProcessor {
    private RTFOutputProcessorMetaData metaData;
    private FlowSelector flowSelector;
    private RTFPrinter printer;

    public FlowRTFOutputProcessor(Configuration config, OutputStream outputStream, ResourceManager resourceManager) {
        if (config == null) {
            throw new NullPointerException();
        }
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.metaData = new RTFOutputProcessorMetaData(config, 1);
        this.flowSelector = new DisplayAllFlowSelector();
        this.printer = new RTFPrinter();
        this.printer.init(config, outputStream, resourceManager);
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public void setFlowSelector(FlowSelector flowSelector) {
        this.flowSelector = flowSelector;
    }

    public FlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    protected void processTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer) throws ContentProcessingException {
        this.printer.print(logicalPageKey, logicalPage, contentProducer, this.metaData, false);
    }

    protected void updateTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPageBox, TableContentProducer tableContentProducer, boolean performOutput) throws ContentProcessingException {
        this.printer.print(logicalPageKey, logicalPageBox, tableContentProducer, this.metaData, true);
    }

    protected void processingContentFinished() {
        if (!this.isContentGeneratable()) {
            return;
        }
        this.printer.close();
        this.metaData.commit();
    }
}

