/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.helper;

import com.lowagie.text.Cell;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.TextElementArray;
import com.lowagie.text.rtf.RtfWriter2;
import com.lowagie.text.rtf.table.RtfCell;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineInfo;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PhysicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackgroundProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.helper.RTFImageCache;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.helper.RTFOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.helper.RTFTextExtractor;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.NoCloseOutputStream;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class RTFPrinter {
    private static final Log logger = LogFactory.getLog(RTFPrinter.class);
    private static final String CREATOR = ClassicEngineInfo.getInstance().getName() + " version " + ClassicEngineInfo.getInstance().getVersion();
    private OutputStream outputStream;
    private Configuration config;
    private ResourceManager resourceManager;
    private RTFImageCache imageCache;
    private Document document;
    private Table table;
    private CellBackgroundProducer cellBackgroundProducer;

    public void init(Configuration config, OutputStream outputStream, ResourceManager resourceManager) {
        this.outputStream = outputStream;
        this.config = config;
        this.resourceManager = resourceManager;
    }

    public void print(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer, RTFOutputProcessorMetaData metaData, boolean incremental) throws ContentProcessingException {
        int startRow = contentProducer.getFinishedRows();
        int finishRow = contentProducer.getFilledRows();
        if (incremental && startRow == finishRow) {
            return;
        }
        if (this.document == null) {
            String title;
            this.cellBackgroundProducer = new CellBackgroundProducer(metaData.isFeatureSupported(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE), metaData.isFeatureSupported(OutputProcessorFeature.UNALIGNED_PAGEBANDS));
            PhysicalPageBox pageFormat = logicalPage.getPageGrid().getPage(0, 0);
            float urx = (float)StrictGeomUtility.toExternalValue(pageFormat.getWidth());
            float ury = (float)StrictGeomUtility.toExternalValue(pageFormat.getHeight());
            float marginLeft = (float)StrictGeomUtility.toExternalValue(pageFormat.getImageableX());
            float marginRight = (float)StrictGeomUtility.toExternalValue(pageFormat.getWidth() - pageFormat.getImageableWidth() - pageFormat.getImageableX());
            float marginTop = (float)StrictGeomUtility.toExternalValue(pageFormat.getImageableY());
            float marginBottom = (float)StrictGeomUtility.toExternalValue(pageFormat.getHeight() - pageFormat.getImageableHeight() - pageFormat.getImageableY());
            Rectangle pageSize = new Rectangle(urx, ury);
            this.document = new Document(pageSize, marginLeft, marginRight, marginTop, marginBottom);
            this.imageCache = new RTFImageCache(this.resourceManager);
            RtfWriter2 instance = RtfWriter2.getInstance((Document)this.document, (OutputStream)new NoCloseOutputStream(this.outputStream));
            instance.getDocumentSettings().setAlwaysUseUnicode(true);
            String author = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.Author");
            if (author != null) {
                this.document.addAuthor(author);
            }
            if ((title = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.Title")) != null) {
                this.document.addTitle(title);
            }
            this.document.addProducer();
            this.document.addCreator(CREATOR);
            try {
                this.document.addCreationDate();
            }
            catch (Exception e) {
                logger.debug((Object)"Unable to add creation date. It will have to work without it.", (Throwable)e);
            }
            this.document.open();
        }
        try {
            SheetLayout sheetLayout = contentProducer.getSheetLayout();
            int columnCount = contentProducer.getColumnCount();
            if (this.table == null) {
                int rowCount = contentProducer.getRowCount();
                this.table = new Table(columnCount, rowCount);
                this.table.setAutoFillEmptyCells(false);
                this.table.setWidth(100.0f);
                float[] cellWidths = new float[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    cellWidths[i] = (float)StrictGeomUtility.toExternalValue(sheetLayout.getCellWidth(i, i + 1));
                }
                this.table.setWidths(cellWidths);
            }
            for (int row = startRow; row < finishRow; ++row) {
                for (int col = 0; col < columnCount; col = (int)((short)(col + 1))) {
                    RenderBox content = contentProducer.getContent(row, col);
                    int sectionType = contentProducer.getSectionType(row, col);
                    if (content == null) {
                        RenderBox backgroundBox = contentProducer.getBackground(row, col);
                        CellBackground background = backgroundBox != null ? this.cellBackgroundProducer.getBackgroundForBox(logicalPage, sheetLayout, col, row, 1, 1, true, sectionType, backgroundBox) : this.cellBackgroundProducer.getBackgroundAt(logicalPage, sheetLayout, col, row, true, sectionType);
                        if (background == null) {
                            RtfCell cell = new RtfCell();
                            cell.setBorderWidth(0.0f);
                            this.table.addCell((Cell)cell, row, col);
                            continue;
                        }
                        RtfCell cell = new RtfCell();
                        cell.setBorderWidth(0.0f);
                        this.updateCellStyle((Cell)cell, background);
                        this.table.addCell((Cell)cell, row, col);
                        continue;
                    }
                    if (!content.isCommited()) {
                        throw new InvalidReportStateException("Uncommited content encountered");
                    }
                    long contentOffset = contentProducer.getContentOffset(row, col);
                    long colPos = sheetLayout.getXPosition(col);
                    long rowPos = sheetLayout.getYPosition(row);
                    if (content.getX() != colPos || content.getY() + contentOffset != rowPos) continue;
                    int colSpan = sheetLayout.getColSpan(col, content.getX() + content.getWidth());
                    int rowSpan = sheetLayout.getRowSpan(row, content.getY() + content.getHeight() + contentOffset);
                    CellBackground realBackground = this.cellBackgroundProducer.getBackgroundForBox(logicalPage, sheetLayout, col, row, colSpan, rowSpan, false, sectionType, content);
                    Cell cell = new Cell();
                    cell.setRowspan(rowSpan);
                    cell.setColspan(colSpan);
                    cell.setBorderWidth(0.0f);
                    if (realBackground != null) {
                        this.updateCellStyle(cell, realBackground);
                    }
                    this.computeCellStyle(content, cell);
                    RTFTextExtractor etx = new RTFTextExtractor(metaData);
                    etx.compute(content, (TextElementArray)cell, this.imageCache);
                    this.table.addCell(cell, row, col);
                    content.setFinishedTable(true);
                }
            }
            if (!incremental) {
                this.document.add((Element)this.table);
                this.table = null;
            }
        }
        catch (DocumentException e) {
            throw new ContentProcessingException("Failed to generate RTF-Document", (Exception)((Object)e));
        }
    }

    private void computeCellStyle(RenderBox content, Cell cell) {
        ElementAlignment verticalAlign = content.getNodeLayoutProperties().getVerticalAlignment();
        if (ElementAlignment.BOTTOM.equals(verticalAlign)) {
            cell.setVerticalAlignment(6);
        } else if (ElementAlignment.MIDDLE.equals(verticalAlign)) {
            cell.setVerticalAlignment(5);
        } else {
            cell.setVerticalAlignment(4);
        }
        ElementAlignment textAlign = (ElementAlignment)content.getStyleSheet().getStyleProperty(ElementStyleKeys.ALIGNMENT);
        if (ElementAlignment.RIGHT.equals(textAlign)) {
            cell.setHorizontalAlignment(2);
        } else if (ElementAlignment.JUSTIFY.equals(textAlign)) {
            cell.setHorizontalAlignment(3);
        } else if (ElementAlignment.CENTER.equals(textAlign)) {
            cell.setHorizontalAlignment(1);
        } else {
            cell.setHorizontalAlignment(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.document != null) {
            this.document.close();
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                logger.info((Object)"Failed to flush the RTF-Output stream.");
            }
            finally {
                this.document = null;
            }
        }
    }

    private int translateBorderStyle(BorderStyle borderStyle) {
        if (BorderStyle.DASHED.equals(borderStyle)) {
            return 5;
        }
        if (BorderStyle.DOT_DASH.equals(borderStyle)) {
            return 8;
        }
        if (BorderStyle.DOT_DOT_DASH.equals(borderStyle)) {
            return 9;
        }
        if (BorderStyle.DOTTED.equals(borderStyle)) {
            return 4;
        }
        if (BorderStyle.DOUBLE.equals(borderStyle)) {
            return 7;
        }
        if (BorderStyle.HIDDEN.equals(borderStyle)) {
            return 0;
        }
        if (BorderStyle.NONE.equals(borderStyle)) {
            return 0;
        }
        if (BorderStyle.GROOVE.equals(borderStyle)) {
            return 24;
        }
        if (BorderStyle.RIDGE.equals(borderStyle)) {
            return 23;
        }
        if (BorderStyle.INSET.equals(borderStyle)) {
            return 1;
        }
        if (BorderStyle.OUTSET.equals(borderStyle)) {
            return 1;
        }
        if (BorderStyle.SOLID.equals(borderStyle)) {
            return 1;
        }
        if (BorderStyle.WAVE.equals(borderStyle)) {
            return 20;
        }
        return 0;
    }

    private void updateCellStyle(Cell cell, CellBackground background) {
        BorderEdge right;
        BorderEdge bottom;
        BorderEdge left;
        BorderEdge top;
        Color backgroundColor = background.getBackgroundColor();
        if (backgroundColor != null) {
            cell.setBackgroundColor(backgroundColor);
        }
        if (!BorderEdge.EMPTY.equals(top = background.getTop())) {
            cell.setBorderColorTop(top.getColor());
            cell.setBorderWidthTop((float)StrictGeomUtility.toExternalValue(top.getWidth()));
        }
        if (!BorderEdge.EMPTY.equals(left = background.getLeft())) {
            cell.setBorderColorLeft(left.getColor());
            cell.setBorderWidthLeft((float)StrictGeomUtility.toExternalValue(left.getWidth()));
        }
        if (!BorderEdge.EMPTY.equals(bottom = background.getBottom())) {
            cell.setBorderColorBottom(bottom.getColor());
            cell.setBorderWidthBottom((float)StrictGeomUtility.toExternalValue(bottom.getWidth()));
        }
        if (!BorderEdge.EMPTY.equals(right = background.getRight())) {
            cell.setBorderColorRight(right.getColor());
            cell.setBorderWidthRight((float)StrictGeomUtility.toExternalValue(right.getWidth()));
        }
    }
}

