/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.DisplayAllFlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.FlowSelector;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.PhysicalPageKey;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelTableContentProducer;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class PageableExcelOutputProcessor
extends AbstractTableOutputProcessor
implements PageableOutputProcessor {
    private List physicalPages;
    private OutputProcessorMetaData metaData;
    private ExcelPrinter printer;
    private FlowSelector flowSelector;

    public PageableExcelOutputProcessor(Configuration configuration, OutputStream outputStream, ResourceManager resourceManager) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.physicalPages = new ArrayList();
        this.metaData = new ExcelOutputProcessorMetaData(configuration, 2);
        this.flowSelector = new DisplayAllFlowSelector();
        this.printer = new ExcelPrinter();
        this.printer.init(configuration, this.metaData, outputStream, resourceManager);
    }

    public boolean isUseXlsxFormat() {
        return this.printer.isUseXlsxFormat();
    }

    public void setUseXlsxFormat(boolean useXlsxFormat) {
        this.printer.setUseXlsxFormat(useXlsxFormat);
    }

    public InputStream getTemplateInputStream() {
        return this.printer.getTemplateInputStream();
    }

    public void setTemplateInputStream(InputStream templateInputStream) {
        this.printer.setTemplateInputStream(templateInputStream);
    }

    protected void processingPagesFinished() {
        super.processingPagesFinished();
        this.physicalPages = Collections.unmodifiableList(this.physicalPages);
    }

    public int getPhysicalPageCount() {
        return this.physicalPages.size();
    }

    public PhysicalPageKey getPhysicalPage(int page) {
        if (!this.isPaginationFinished()) {
            throw new IllegalStateException();
        }
        return (PhysicalPageKey)this.physicalPages.get(page);
    }

    protected LogicalPageKey createLogicalPage(int width, int height) {
        LogicalPageKey key = super.createLogicalPage(width, height);
        for (int h = 0; h < key.getHeight(); ++h) {
            for (int w = 0; w < key.getWidth(); ++w) {
                this.physicalPages.add(key.getPage(w, h));
            }
        }
        return key;
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    public FlowSelector getFlowSelector() {
        return this.flowSelector;
    }

    public void setFlowSelector(FlowSelector flowSelector) {
        this.flowSelector = flowSelector;
    }

    protected void processTableContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer) throws ContentProcessingException {
        this.printer.print(logicalPageKey, logicalPage, contentProducer, false);
    }

    protected void processingContentFinished() {
        if (!this.isContentGeneratable()) {
            return;
        }
        this.metaData.commit();
        this.printer.close();
    }

    protected TableContentProducer createTableContentProducer(SheetLayout layout) {
        return new ExcelTableContentProducer(layout, this.getMetaData());
    }
}

