/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.pentaho.reporting.engine.classic.core.Anchor;
import org.pentaho.reporting.engine.classic.core.DefaultImageReference;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.LocalImageContainer;
import org.pentaho.reporting.engine.classic.core.URLImageContainer;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PhysicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackgroundProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableRectangle;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.DynamicExcelColorProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelColorProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelPrintSetupFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelTableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.HSSFCellStyleProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.StaticExcelColorSupport;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.XSSFExcelColorProducer;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.ImageUtils;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.encoder.UnsupportedEncoderException;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class ExcelPrinter {
    private static final Log logger = LogFactory.getLog(ExcelPrinter.class);
    private InputStream templateInputStream;
    private OutputStream outputStream;
    private Workbook workbook;
    private HashMap<String, Integer> sheetNamesCount = new HashMap();
    private double scaleFactor;
    private Configuration config;
    private OutputProcessorMetaData metaData;
    private ResourceManager resourceManager;
    private Sheet sheet;
    private Drawing patriarch;
    private HSSFCellStyleProducer cellStyleProducer;
    private CellBackgroundProducer cellBackgroundProducer;
    private ExcelTextExtractor textExtractor;
    private ExcelColorProducer colorProducer;
    private ExcelColorProducer fontColorProducer;
    private boolean useXlsxFormat;
    private int sheetFreezeTop;
    private int sheetFreezeLeft;

    public boolean isUseXlsxFormat() {
        return this.useXlsxFormat;
    }

    public void setUseXlsxFormat(boolean useXlsxFormat) {
        this.useXlsxFormat = useXlsxFormat;
    }

    public void init(Configuration config, OutputProcessorMetaData metaData, OutputStream outputStream, ResourceManager resourceManager) {
        if (config == null) {
            throw new NullPointerException();
        }
        if (metaData == null) {
            throw new NullPointerException();
        }
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.outputStream = outputStream;
        this.config = config;
        this.metaData = metaData;
        this.resourceManager = resourceManager;
        this.cellBackgroundProducer = new CellBackgroundProducer(metaData.isFeatureSupported(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE), metaData.isFeatureSupported(OutputProcessorFeature.UNALIGNED_PAGEBANDS));
        try {
            String scaleFactorText = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.CellWidthScaleFactor");
            this.scaleFactor = scaleFactorText == null ? 50.0 : Double.parseDouble(scaleFactorText);
        }
        catch (Exception e) {
            this.scaleFactor = 50.0;
        }
    }

    public InputStream getTemplateInputStream() {
        return this.templateInputStream;
    }

    public void setTemplateInputStream(InputStream templateInputStream) {
        this.templateInputStream = templateInputStream;
    }

    private String makeUnique(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        Integer count = this.sheetNamesCount.get(name);
        if (count == null) {
            this.sheetNamesCount.put(name, IntegerCache.getInteger(1));
            return name;
        }
        int value = count + 1;
        this.sheetNamesCount.put(name, IntegerCache.getInteger(value));
        return this.makeUnique(name + ' ' + value);
    }

    private boolean isValidSheetName(String sheetname) {
        return sheetname.indexOf(47) <= -1 && sheetname.indexOf(92) <= -1 && sheetname.indexOf(63) <= -1 && sheetname.indexOf(42) <= -1 && sheetname.indexOf(93) <= -1 && sheetname.indexOf(91) <= -1 && sheetname.indexOf(58) <= -1;
    }

    private Cell getCellAt(int x, int y) {
        Row row = this.getRowAt(y);
        Cell cell = row.getCell(x);
        if (cell != null) {
            return cell;
        }
        return row.createCell(x);
    }

    private Row getRowAt(int y) {
        Row row = this.sheet.getRow(y);
        if (row != null) {
            return row;
        }
        return this.sheet.createRow(y);
    }

    private boolean isHeaderFooterValid(String left, String center, String right) {
        int length = 0;
        if (left != null) {
            length += left.length();
        }
        if (center != null) {
            length += center.length();
        }
        if (right != null) {
            length += right.length();
        }
        return length < 255;
    }

    public void print(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer, boolean incremental) {
        int startRow = contentProducer.getFinishedRows();
        int finishRow = contentProducer.getFilledRows();
        if (incremental && startRow == finishRow) {
            return;
        }
        if (this.workbook == null) {
            this.workbook = this.createWorkbook();
            if (this.workbook instanceof HSSFWorkbook) {
                boolean dynamicColors = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.DynamicColors"));
                if (dynamicColors) {
                    HSSFWorkbook hssfWorkbook = (HSSFWorkbook)this.workbook;
                    this.colorProducer = new DynamicExcelColorProducer(hssfWorkbook);
                } else {
                    this.colorProducer = new StaticExcelColorSupport();
                }
                this.fontColorProducer = this.colorProducer;
            } else {
                this.colorProducer = new XSSFExcelColorProducer();
                this.fontColorProducer = new StaticExcelColorSupport();
            }
            this.textExtractor = new ExcelTextExtractor(this.metaData, this.colorProducer);
            boolean hardLimit = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.HardStyleCountLimit"));
            this.cellStyleProducer = new HSSFCellStyleProducer(this.workbook, hardLimit, this.colorProducer, this.fontColorProducer);
        }
        if (this.sheet == null) {
            this.sheet = this.openSheet(contentProducer.getSheetName());
            ExcelTableContentProducer excelTableContentProducer = (ExcelTableContentProducer)contentProducer;
            String pageHeaderCenter = excelTableContentProducer.getPageHeaderCenter();
            String pageFooterCenter = excelTableContentProducer.getPageFooterCenter();
            String pageHeaderLeft = excelTableContentProducer.getPageHeaderLeft();
            String pageFooterLeft = excelTableContentProducer.getPageFooterLeft();
            String pageHeaderRight = excelTableContentProducer.getPageHeaderRight();
            String pageFooterRight = excelTableContentProducer.getPageFooterRight();
            this.sheetFreezeTop = excelTableContentProducer.getFreezeTop();
            this.sheetFreezeLeft = excelTableContentProducer.getFreezeLeft();
            if (this.isHeaderFooterValid(pageHeaderLeft, pageHeaderCenter, pageHeaderRight)) {
                if (pageHeaderLeft != null) {
                    this.sheet.getHeader().setLeft(pageHeaderLeft);
                }
                if (pageHeaderCenter != null) {
                    this.sheet.getHeader().setCenter(pageHeaderCenter);
                }
                if (pageHeaderRight != null) {
                    this.sheet.getHeader().setRight(pageHeaderRight);
                }
            } else {
                logger.warn((Object)"Page-Header exceeds the maximum length of 255 characters. No page-header will be added to the sheet.");
            }
            if (this.isHeaderFooterValid(pageFooterLeft, pageFooterCenter, pageFooterRight)) {
                if (pageFooterCenter != null) {
                    this.sheet.getFooter().setCenter(pageFooterCenter);
                }
                if (pageFooterLeft != null) {
                    this.sheet.getFooter().setLeft(pageFooterLeft);
                }
                if (pageFooterRight != null) {
                    this.sheet.getFooter().setRight(pageFooterRight);
                }
            } else {
                logger.warn((Object)"Page-Footer exceeds the maximum length of 255 characters. No page-footer will be added to the sheet.");
            }
            PhysicalPageBox page = logicalPage.getPageGrid().getPage(0, 0);
            this.configureSheet(page);
            SheetLayout sheetLayout = contentProducer.getSheetLayout();
            int columnCount = contentProducer.getColumnCount();
            for (int col = 0; col < columnCount; ++col) {
                double cellWidth = StrictGeomUtility.toExternalValue(sheetLayout.getCellWidth(col, col + 1));
                double poiCellWidth = cellWidth * this.scaleFactor;
                this.sheet.setColumnWidth(col, (int)poiCellWidth);
            }
        }
        SheetLayout sheetLayout = contentProducer.getSheetLayout();
        int colCount = sheetLayout.getColumnCount();
        for (int row = startRow; row < finishRow; ++row) {
            Row hssfRow = this.getRowAt(row);
            double lastRowHeight = StrictGeomUtility.toExternalValue(sheetLayout.getRowHeight(row));
            hssfRow.setHeightInPoints((float)lastRowHeight);
            for (int col = 0; col < colCount; ++col) {
                RenderBox content = contentProducer.getContent(row, col);
                if (content == null) {
                    int sectionType = contentProducer.getSectionType(row, col);
                    RenderBox backgroundBox = contentProducer.getBackground(row, col);
                    CellBackground background = backgroundBox != null ? this.cellBackgroundProducer.getBackgroundForBox(logicalPage, sheetLayout, col, row, 1, 1, true, sectionType, backgroundBox) : this.cellBackgroundProducer.getBackgroundAt(logicalPage, sheetLayout, col, row, true, sectionType);
                    if (background == null) {
                        if (row != 0 || col != 0) continue;
                        this.getCellAt(col, row);
                        continue;
                    }
                    Cell cell = this.getCellAt(col, row);
                    CellStyle style = this.cellStyleProducer.createCellStyle(null, background);
                    if (style == null) continue;
                    cell.setCellStyle(style);
                    continue;
                }
                if (!content.isCommited()) {
                    throw new InvalidReportStateException("Uncommited content encountered");
                }
                long contentOffset = contentProducer.getContentOffset(row, col);
                TableRectangle rectangle = sheetLayout.getTableBounds(content.getX(), content.getY() + contentOffset, content.getWidth(), content.getHeight(), null);
                if (!rectangle.isOrigin(col, row)) continue;
                int sectionType = contentProducer.getSectionType(row, col);
                CellBackground realBackground = this.cellBackgroundProducer.getBackgroundForBox(logicalPage, sheetLayout, rectangle.getX1(), rectangle.getY1(), rectangle.getColumnSpan(), rectangle.getRowSpan(), false, sectionType, content);
                Cell cell = this.getCellAt(col, row);
                CellStyle style = this.cellStyleProducer.createCellStyle(content, realBackground);
                if (style != null) {
                    cell.setCellStyle(style);
                }
                if (this.applyCellValue(this.metaData, content, cell, sheetLayout, rectangle, contentOffset)) {
                    this.mergeCellRegion(rectangle, row, col, sheetLayout, logicalPage, content, contentProducer);
                }
                content.setFinishedTable(true);
            }
        }
        if (!incremental) {
            this.patriarch = null;
            this.sheet = null;
        }
    }

    private void mergeCellRegion(TableRectangle rectangle, int row, int col, SheetLayout sheetLayout, LogicalPageBox logicalPage, RenderBox content, TableContentProducer contentProducer) {
        if (content == null) {
            throw new NullPointerException();
        }
        int rowSpan = rectangle.getRowSpan();
        int columnSpan = rectangle.getColumnSpan();
        if (rowSpan <= 1 && columnSpan <= 1) {
            return;
        }
        this.sheet.addMergedRegion(new CellRangeAddress(row, row + rowSpan - 1, col, col + columnSpan - 1));
        int rectX = rectangle.getX1();
        int rectY = rectangle.getY1();
        for (int spannedRow = 0; spannedRow < rowSpan; ++spannedRow) {
            for (int spannedCol = 0; spannedCol < columnSpan; ++spannedCol) {
                int sectionType = contentProducer.getSectionType(row, col);
                CellBackground bg = this.cellBackgroundProducer.getBackgroundForBox(logicalPage, sheetLayout, rectX + spannedCol, rectY + spannedRow, 1, 1, false, sectionType, content);
                Cell regionCell = this.getCellAt(col + spannedCol, row + spannedRow);
                CellStyle spannedStyle = this.cellStyleProducer.createCellStyle(content, bg);
                if (spannedStyle == null) continue;
                regionCell.setCellStyle(spannedStyle);
            }
        }
    }

    private boolean applyCellValue(OutputProcessorMetaData metaData, RenderBox content, Cell cell, SheetLayout sheetLayout, TableRectangle rectangle, long contentOffset) {
        Object attr1;
        Object value = this.textExtractor.compute(content, this.cellStyleProducer.getFontFactory(), this.workbook.getCreationHelper());
        if (value instanceof Image) {
            try {
                DefaultImageReference imageContainer = new DefaultImageReference((Image)value);
                RenderNode rawSource = this.textExtractor.getRawSource();
                StrictBounds contentBounds = new StrictBounds(content.getX(), content.getY() + contentOffset, content.getWidth(), content.getHeight());
                this.createImageCell(rawSource, imageContainer, sheetLayout, rectangle, contentBounds);
            }
            catch (IOException ioe) {
                logger.warn((Object)"Failed to process AWT-Image in Excel-Export", (Throwable)ioe);
            }
            return false;
        }
        if (value instanceof ImageContainer) {
            ImageContainer imageContainer = (ImageContainer)value;
            RenderNode rawSource = this.textExtractor.getRawSource();
            StrictBounds contentBounds = new StrictBounds(content.getX(), content.getY() + contentOffset, content.getWidth(), content.getHeight());
            this.createImageCell(rawSource, imageContainer, sheetLayout, rectangle, contentBounds);
            return false;
        }
        if (value instanceof DrawableWrapper) {
            DrawableWrapper drawable = (DrawableWrapper)value;
            RenderNode rawSource = this.textExtractor.getRawSource();
            StrictBounds contentBounds = new StrictBounds(rawSource.getX(), rawSource.getY() + contentOffset, rawSource.getWidth(), rawSource.getHeight());
            ImageContainer imageFromDrawable = RenderUtility.createImageFromDrawable(drawable, contentBounds, content, metaData);
            this.createImageCell(rawSource, imageFromDrawable, sheetLayout, rectangle, contentBounds);
            return false;
        }
        if (value instanceof Shape) {
            return false;
        }
        String linkTarget = (String)content.getStyleSheet().getStyleProperty(ElementStyleKeys.HREF_TARGET);
        if (linkTarget != null) {
            String formula = "HYPERLINK(" + this.excelFormulaSplitAndQuote(linkTarget) + "," + this.excelFormulaSplitAndQuote(this.textExtractor.getText()) + ")";
            if (formula.length() < 1024) {
                cell.setCellFormula(formula);
                return true;
            }
            logger.warn((Object)"Excel-Cells cannot contain formulas longer than 1023 characters. Converting hyperlink into plain text");
        }
        if ((attr1 = content.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/excel", "formula")) != null) {
            String formula = String.valueOf(attr1);
            if (formula.length() < 1024) {
                cell.setCellFormula(formula);
                return true;
            }
            logger.warn((Object)"Excel-Cells cannot contain formulas longer than 1023 characters. Converting excel formula into plain text");
        }
        if (value instanceof RichTextString) {
            cell.setCellValue((RichTextString)value);
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof Number) {
            Number number = (Number)value;
            cell.setCellValue(number.doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(Boolean.TRUE.equals(value));
        } else if (!(value instanceof Anchor)) {
            if (value == null) {
                cell.setCellType(3);
            } else {
                cell.setCellValue(String.valueOf(value));
            }
        }
        return true;
    }

    private String excelFormulaSplitAndQuote(String s) {
        StringBuilder b = new StringBuilder();
        b.append('\"');
        char[] chars = s.toCharArray();
        int count = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\"') {
                b.append('\"');
                b.append('\"');
                count += 2;
            } else {
                b.append(c);
                ++count;
            }
            if (count <= 252) continue;
            count = 0;
            b.append("\" & \"");
        }
        b.append('\"');
        return b.toString();
    }

    private void configureSheet(PhysicalPageBox page) {
        this.patriarch = null;
        String paper = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.Paper");
        String orientation = this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PaperOrientation");
        short scale = (short)ParserUtil.parseInt((String)this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PrintScaleFactor"), (int)100);
        short hres = (short)ParserUtil.parseInt((String)this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PrintHorizontalResolution"), (int)-1);
        short vres = (short)ParserUtil.parseInt((String)this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PrintVerticalResolution"), (int)-1);
        boolean noColors = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PrintNoColors"));
        boolean notes = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PrintNotes"));
        boolean usePage = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PrintUsePage"));
        boolean draft = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.PrintDraft"));
        PrintSetup printSetup = this.sheet.getPrintSetup();
        ExcelPrintSetupFactory.performPageSetup(printSetup, page, paper, orientation);
        printSetup.setScale(scale);
        printSetup.setNoColor(noColors);
        printSetup.setNotes(notes);
        printSetup.setUsePage(usePage);
        if (hres > 0) {
            printSetup.setHResolution(hres);
        }
        if (vres > 0) {
            printSetup.setVResolution(vres);
        }
        printSetup.setDraft(draft);
        boolean displayGridLines = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.GridLinesDisplayed"));
        boolean printGridLines = "true".equals(this.config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.xls.GridLinesPrinted"));
        this.sheet.setDisplayGridlines(displayGridLines);
        this.sheet.setPrintGridlines(printGridLines);
        if (this.sheetFreezeTop > 0 || this.sheetFreezeLeft > 0) {
            this.sheet.createFreezePane(this.sheetFreezeLeft, this.sheetFreezeTop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.workbook != null) {
            try {
                this.workbook.write(this.outputStream);
                this.patriarch = null;
                this.sheet = null;
                this.outputStream.flush();
            }
            catch (IOException e) {
                logger.warn((Object)"could not write xls data. Message:", (Throwable)e);
            }
            finally {
                this.workbook = null;
            }
        }
    }

    protected Workbook createWorkbook() {
        if (this.templateInputStream != null) {
            try {
                Workbook workbook = WorkbookFactory.create((InputStream)this.templateInputStream);
                int sheetCount = workbook.getNumberOfSheets();
                for (int i = 0; i < sheetCount; ++i) {
                    String sheetName = workbook.getSheetName(i);
                    this.makeUnique(sheetName);
                }
                return workbook;
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to read predefined xls-data.", (Throwable)e);
            }
            catch (InvalidFormatException e) {
                logger.warn((Object)"Unable to read predefined xls-data.", (Throwable)e);
            }
        }
        if (this.isUseXlsxFormat()) {
            return new XSSFWorkbook();
        }
        return new HSSFWorkbook();
    }

    private Sheet openSheet(String sheetName) {
        if (sheetName == null) {
            return this.workbook.createSheet();
        }
        String uniqueSheetname = this.makeUnique(sheetName);
        if (uniqueSheetname.length() == 0 || uniqueSheetname.length() > 31) {
            logger.warn((Object)"A sheet name must not be empty and greater than 31 characters");
            return this.workbook.createSheet();
        }
        if (!this.isValidSheetName(uniqueSheetname)) {
            logger.warn((Object)"A sheet name must not contain any of ':/\\*?[]'");
            return this.workbook.createSheet();
        }
        return this.workbook.createSheet(uniqueSheetname);
    }

    private void createImageCell(RenderNode contentNode, ImageContainer image, SheetLayout currentLayout, TableRectangle rectangle, StrictBounds cellBounds) {
        try {
            int pictureId;
            StrictBounds cb;
            if (rectangle == null) {
                logger.debug((Object)"Invalid reference: I was not able to compute the rectangle for the content.");
                return;
            }
            StyleSheet layoutContext = contentNode.getStyleSheet();
            boolean shouldScale = layoutContext.getBooleanStyleProperty(ElementStyleKeys.SCALE);
            int imageWidth = image.getImageWidth();
            int imageHeight = image.getImageHeight();
            if (imageWidth < 1 || imageHeight < 1) {
                return;
            }
            double devResolution = this.metaData.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION);
            double scaleFactor = this.metaData.isFeatureSupported(OutputProcessorFeature.IMAGE_RESOLUTION_MAPPING) ? (devResolution != 72.0 && devResolution > 0.0 ? 72.0 / devResolution : 1.0) : 1.0;
            ElementAlignment horizontalAlignment = (ElementAlignment)layoutContext.getStyleProperty(ElementStyleKeys.ALIGNMENT);
            ElementAlignment verticalAlignment = (ElementAlignment)layoutContext.getStyleProperty(ElementStyleKeys.VALIGNMENT);
            long internalImageWidth = StrictGeomUtility.toInternalValue(scaleFactor * (double)imageWidth);
            long internalImageHeight = StrictGeomUtility.toInternalValue(scaleFactor * (double)imageHeight);
            long cellWidth = cellBounds.getWidth();
            long cellHeight = cellBounds.getHeight();
            try {
                if (shouldScale) {
                    double scaleY;
                    double scaleX;
                    boolean keepAspectRatio = layoutContext.getBooleanStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO);
                    if (keepAspectRatio) {
                        double imgScaleFactor;
                        scaleX = imgScaleFactor = Math.min((double)cellWidth / (double)internalImageWidth, (double)cellHeight / (double)internalImageHeight);
                        scaleY = imgScaleFactor;
                    } else {
                        scaleX = (double)cellWidth / (double)internalImageWidth;
                        scaleY = (double)cellHeight / (double)internalImageHeight;
                    }
                    long clipWidth = (long)(scaleX * (double)internalImageWidth);
                    long clipHeight = (long)(scaleY * (double)internalImageHeight);
                    long alignmentX = RenderUtility.computeHorizontalAlignment(horizontalAlignment, cellWidth, clipWidth);
                    long alignmentY = RenderUtility.computeVerticalAlignment(verticalAlignment, cellHeight, clipHeight);
                    cb = new StrictBounds(cellBounds.getX() + alignmentX, cellBounds.getY() + alignmentY, Math.min(clipWidth, cellWidth), Math.min(clipHeight, cellHeight));
                    rectangle = currentLayout.getTableBounds(cb, rectangle);
                    pictureId = this.loadImage(this.workbook, image);
                    if (this.isUseXlsxFormat() ? pictureId < 0 : pictureId <= 0) {
                        return;
                    }
                } else if (internalImageWidth <= cellWidth && internalImageHeight <= cellHeight) {
                    long alignmentX = RenderUtility.computeHorizontalAlignment(horizontalAlignment, cellBounds.getWidth(), internalImageWidth);
                    long alignmentY = RenderUtility.computeVerticalAlignment(verticalAlignment, cellBounds.getHeight(), internalImageHeight);
                    cb = new StrictBounds(cellBounds.getX() + alignmentX, cellBounds.getY() + alignmentY, internalImageWidth, internalImageHeight);
                    rectangle = currentLayout.getTableBounds(cb, rectangle);
                    pictureId = this.loadImage(this.workbook, image);
                    if (this.isUseXlsxFormat() ? pictureId < 0 : pictureId <= 0) {
                        return;
                    }
                } else {
                    long clipWidth = Math.min(cellWidth, internalImageWidth);
                    long clipHeight = Math.min(cellHeight, internalImageHeight);
                    long alignmentX = RenderUtility.computeHorizontalAlignment(horizontalAlignment, cellBounds.getWidth(), clipWidth);
                    long alignmentY = RenderUtility.computeVerticalAlignment(verticalAlignment, cellBounds.getHeight(), clipHeight);
                    cb = new StrictBounds(cellBounds.getX() + alignmentX, cellBounds.getY() + alignmentY, clipWidth, clipHeight);
                    rectangle = currentLayout.getTableBounds(cb, rectangle);
                    pictureId = this.loadImageWithClipping(this.workbook, image, clipWidth, clipHeight, scaleFactor);
                    if (this.isUseXlsxFormat() ? pictureId < 0 : pictureId <= 0) {
                        return;
                    }
                }
            }
            catch (UnsupportedEncoderException uee) {
                logger.warn((Object)"Assertation-Failure: PNG encoding failed.", (Throwable)uee);
                return;
            }
            int cell1x = rectangle.getX1();
            int cell1y = rectangle.getY1();
            int cell2x = Math.max(cell1x, rectangle.getX2() - 1);
            int cell2y = Math.max(cell1y, rectangle.getY2() - 1);
            long cell1width = currentLayout.getCellWidth(cell1x);
            long cell1height = currentLayout.getRowHeight(cell1y);
            long cell2width = currentLayout.getCellWidth(cell2x);
            long cell2height = currentLayout.getRowHeight(cell2y);
            long cell1xPos = currentLayout.getXPosition(cell1x);
            long cell1yPos = currentLayout.getYPosition(cell1y);
            long cell2xPos = currentLayout.getXPosition(cell2x);
            long cell2yPos = currentLayout.getYPosition(cell2y);
            int dx1 = (int)(1023.0 * ((double)(cb.getX() - cell1xPos) / (double)cell1width));
            int dy1 = (int)(255.0 * ((double)(cb.getY() - cell1yPos) / (double)cell1height));
            int dx2 = (int)(1023.0 * ((double)(cb.getX() + cb.getWidth() - cell2xPos) / (double)cell2width));
            int dy2 = (int)(255.0 * ((double)(cb.getY() + cb.getHeight() - cell2yPos) / (double)cell2height));
            ClientAnchor anchor = this.workbook.getCreationHelper().createClientAnchor();
            anchor.setDx1(dx1);
            anchor.setDy1(dy1);
            anchor.setDx2(dx2);
            anchor.setDy2(dy2);
            anchor.setCol1(cell1x);
            anchor.setRow1(cell1y);
            anchor.setCol2(cell2x);
            anchor.setRow2(cell2y);
            anchor.setAnchorType(2);
            if (this.patriarch == null) {
                this.patriarch = this.sheet.createDrawingPatriarch();
            }
            Picture picture = this.patriarch.createPicture(anchor, pictureId);
            logger.info((Object)("Created image: " + pictureId + " => " + picture));
            DebugLog.log((Object)anchor);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to add image. Ignoring.", (Throwable)e);
        }
    }

    private int getImageFormat(ResourceKey key) {
        URL url = this.resourceManager.toURL(key);
        if (url == null) {
            return -1;
        }
        String file = url.getFile();
        if (StringUtils.endsWithIgnoreCase((String)file, (String)".png")) {
            return 6;
        }
        if (StringUtils.endsWithIgnoreCase((String)file, (String)".jpg") || StringUtils.endsWithIgnoreCase((String)file, (String)".jpeg")) {
            return 5;
        }
        if (StringUtils.endsWithIgnoreCase((String)file, (String)".bmp") || StringUtils.endsWithIgnoreCase((String)file, (String)".ico")) {
            return 7;
        }
        return -1;
    }

    private int loadImageWithClipping(Workbook workbook, ImageContainer reference, long clipWidth, long clipHeight, double deviceScaleFactor) throws IOException, UnsupportedEncoderException {
        URLImageContainer urlImage;
        ResourceKey url;
        Image image = null;
        if (reference instanceof URLImageContainer && (url = (urlImage = (URLImageContainer)reference).getResourceKey()) != null && urlImage.isLoadable()) {
            if (reference instanceof LocalImageContainer) {
                LocalImageContainer li = (LocalImageContainer)reference;
                image = li.getImage();
            }
            if (image == null) {
                try {
                    Resource resource = this.resourceManager.create(url, null, Image.class);
                    image = (Image)resource.getResource();
                }
                catch (ResourceException e) {
                    // empty catch block
                }
            }
        }
        if (reference instanceof LocalImageContainer) {
            LocalImageContainer li = (LocalImageContainer)reference;
            if (image == null) {
                image = li.getImage();
            }
        }
        if (image != null) {
            return this.clipAndEncodeImage(workbook, image, clipWidth, clipHeight, deviceScaleFactor);
        }
        return -1;
    }

    private int clipAndEncodeImage(Workbook workbook, Image image, long width, long height, double deviceScaleFactor) throws UnsupportedEncoderException, IOException {
        Graphics2D graphics;
        BufferedImage bi;
        block2: {
            block1: {
                int imageWidth = (int)StrictGeomUtility.toExternalValue(width);
                int imageHeight = (int)StrictGeomUtility.toExternalValue(height);
                bi = ImageUtils.createTransparentImage(imageWidth, imageHeight);
                graphics = (Graphics2D)bi.getGraphics();
                graphics.scale(deviceScaleFactor, deviceScaleFactor);
                if (!(image instanceof BufferedImage)) break block1;
                if (graphics.drawImage(image, null, null)) break block2;
                logger.debug((Object)"Failed to render the image. This should not happen for BufferedImages");
                break block2;
            }
            WaitingImageObserver obs = new WaitingImageObserver(image);
            obs.waitImageLoaded();
            while (!graphics.drawImage(image, null, (ImageObserver)obs)) {
                obs.waitImageLoaded();
                if (!obs.isError()) continue;
                logger.warn((Object)"Error while loading the image during the rendering.");
                break;
            }
        }
        graphics.dispose();
        byte[] data = RenderUtility.encodeImage(bi);
        return workbook.addPicture(data, 6);
    }

    private int loadImage(Workbook workbook, ImageContainer reference) throws IOException, UnsupportedEncoderException {
        URLImageContainer urlImage;
        ResourceKey url;
        Image image = null;
        if (reference instanceof URLImageContainer && (url = (urlImage = (URLImageContainer)reference).getResourceKey()) != null && urlImage.isLoadable()) {
            int format = this.getImageFormat(url);
            if (format == -1) {
                if (reference instanceof LocalImageContainer) {
                    LocalImageContainer li = (LocalImageContainer)reference;
                    image = li.getImage();
                }
                if (image == null) {
                    try {
                        Resource resource = this.resourceManager.create(url, null, Image.class);
                        image = (Image)resource.getResource();
                    }
                    catch (ResourceException re) {
                        logger.info((Object)("Failed to load image from URL " + url), (Throwable)re);
                    }
                }
            } else {
                try {
                    ResourceData data = this.resourceManager.load(url);
                    return workbook.addPicture(data.getResource(this.resourceManager), format);
                }
                catch (ResourceException re) {
                    logger.info((Object)("Failed to load image from URL " + url), (Throwable)re);
                }
            }
        }
        if (reference instanceof LocalImageContainer) {
            LocalImageContainer li = (LocalImageContainer)reference;
            if (image == null) {
                image = li.getImage();
            }
        }
        if (image != null) {
            byte[] data = RenderUtility.encodeImage(image);
            return workbook.addPicture(data, 6);
        }
        return -1;
    }
}

