/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;

public class ExcelTableContentProducer
extends TableContentProducer {
    private String pageHeaderCenter;
    private String pageFooterCenter;
    private String pageHeaderLeft;
    private String pageFooterLeft;
    private String pageHeaderRight;
    private String pageFooterRight;
    private Integer freezeTop;
    private Integer freezeLeft;

    public ExcelTableContentProducer(SheetLayout sheetLayout, OutputProcessorMetaData metaData) {
        super(sheetLayout, metaData);
    }

    public void compute(LogicalPageBox logicalPage, boolean iterativeUpdate) {
        this.pageFooterLeft = null;
        this.pageFooterCenter = null;
        this.pageFooterRight = null;
        this.pageHeaderLeft = null;
        this.pageHeaderCenter = null;
        this.pageHeaderRight = null;
        super.compute(logicalPage, iterativeUpdate);
    }

    public String getPageHeaderCenter() {
        return this.pageHeaderCenter;
    }

    public void setPageHeaderCenter(String pageHeaderCenter) {
        this.pageHeaderCenter = pageHeaderCenter;
    }

    public String getPageFooterCenter() {
        return this.pageFooterCenter;
    }

    public void setPageFooterCenter(String pageFooterCenter) {
        this.pageFooterCenter = pageFooterCenter;
    }

    public String getPageHeaderLeft() {
        return this.pageHeaderLeft;
    }

    public void setPageHeaderLeft(String pageHeaderLeft) {
        this.pageHeaderLeft = pageHeaderLeft;
    }

    public String getPageFooterLeft() {
        return this.pageFooterLeft;
    }

    public void setPageFooterLeft(String pageFooterLeft) {
        this.pageFooterLeft = pageFooterLeft;
    }

    public String getPageHeaderRight() {
        return this.pageHeaderRight;
    }

    public void setPageHeaderRight(String pageHeaderRight) {
        this.pageHeaderRight = pageHeaderRight;
    }

    public String getPageFooterRight() {
        return this.pageFooterRight;
    }

    public void setPageFooterRight(String pageFooterRight) {
        this.pageFooterRight = pageFooterRight;
    }

    protected void collectSheetStyleData(RenderBox box) {
        super.collectSheetStyleData(box);
        this.pageHeaderCenter = this.lookup(box, "page-header-center", this.pageHeaderCenter);
        this.pageHeaderLeft = this.lookup(box, "page-header-left", this.pageHeaderLeft);
        this.pageHeaderRight = this.lookup(box, "page-header-right", this.pageHeaderRight);
        this.pageFooterCenter = this.lookup(box, "page-footer-center", this.pageFooterCenter);
        this.pageFooterLeft = this.lookup(box, "page-footer-left", this.pageFooterLeft);
        this.pageFooterRight = this.lookup(box, "page-footer-right", this.pageFooterRight);
        Integer freezeTop = (Integer)box.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/excel", "freezing-top-position");
        if (this.freezeTop == null && freezeTop != null) {
            this.freezeTop = freezeTop;
        }
        Integer freezeLeft = (Integer)box.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/excel", "freezing-left-position");
        if (this.freezeLeft == null && freezeLeft != null) {
            this.freezeLeft = freezeLeft;
        }
    }

    public int getFreezeTop() {
        if (this.freezeTop == null) {
            return 0;
        }
        return this.freezeTop;
    }

    public int getFreezeLeft() {
        if (this.freezeLeft == null) {
            return 0;
        }
        return this.freezeLeft;
    }

    private String lookup(RenderBox box, String attribute, String defaultValue) {
        Object value = box.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/excel", attribute);
        if (value != null && defaultValue == null) {
            return String.valueOf(value);
        }
        return defaultValue;
    }
}

