/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import java.awt.Color;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.RichTextString;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.DefaultTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelColorProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelFontFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.HSSFFontWrapper;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;

public class ExcelTextExtractor
extends DefaultTextExtractor {
    private static final Log logger = LogFactory.getLog(ExcelTextExtractor.class);
    private ArrayList buffer;
    private ExcelColorProducer colorProducer;

    public ExcelTextExtractor(OutputProcessorMetaData metaData, ExcelColorProducer colorProducer) {
        super(metaData);
        if (colorProducer == null) {
            throw new NullPointerException();
        }
        this.colorProducer = colorProducer;
        this.buffer = new ArrayList();
    }

    public Object compute(RenderBox paraBox, ExcelFontFactory fontFactory, CreationHelper creationHelper) {
        this.buffer.clear();
        super.compute(paraBox);
        String text = this.getText();
        if (this.buffer.size() <= 1) {
            Object rawResult = this.getRawResult();
            if (rawResult != null && !(rawResult instanceof String)) {
                return rawResult;
            }
            if (text.length() > Short.MAX_VALUE) {
                logger.warn((Object)"Excel-Cells cannot contain text larger than 32.737 characters. Text will be clipped.");
                return text.substring(0, Short.MAX_VALUE);
            }
            if (text.length() > 0) {
                return text;
            }
            return null;
        }
        if (text.length() > 0) {
            RichTextFormat o;
            int position;
            if (text.length() < 32768) {
                RichTextString rtStr = creationHelper.createRichTextString(text);
                for (int i = 0; i < this.buffer.size(); ++i) {
                    RichTextFormat o2 = (RichTextFormat)this.buffer.get(i);
                    int position2 = o2.getPosition();
                    HSSFFontWrapper font = o2.getFont();
                    if (i == this.buffer.size() - 1) {
                        rtStr.applyFont(position2, text.length(), fontFactory.getExcelFont(font));
                        continue;
                    }
                    RichTextFormat next = (RichTextFormat)this.buffer.get(i + 1);
                    rtStr.applyFont(position2, next.getPosition(), fontFactory.getExcelFont(font));
                }
                return rtStr;
            }
            logger.warn((Object)"Excel-Cells cannot contain text larger than 32.737 characters. Text will be clipped.");
            String realText = text.substring(0, Short.MAX_VALUE);
            RichTextString rtStr = creationHelper.createRichTextString(realText);
            for (int i = 0; i < this.buffer.size() && (position = (o = (RichTextFormat)this.buffer.get(i)).getPosition()) < Short.MAX_VALUE; ++i) {
                HSSFFontWrapper font = o.getFont();
                if (i == this.buffer.size() - 1) {
                    int endPosition = Math.min(Short.MAX_VALUE, text.length());
                    rtStr.applyFont(position, endPosition, fontFactory.getExcelFont(font));
                    continue;
                }
                RichTextFormat next = (RichTextFormat)this.buffer.get(i + 1);
                int endPosition = Math.min(Short.MAX_VALUE, next.getPosition());
                rtStr.applyFont(position, endPosition, fontFactory.getExcelFont(font));
            }
            return rtStr;
        }
        return null;
    }

    protected boolean startInlineBox(InlineRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        StyleSheet styleSheet = box.getStyleSheet();
        Color textColor = (Color)styleSheet.getStyleProperty(ElementStyleKeys.PAINT);
        String fontName = (String)styleSheet.getStyleProperty(TextStyleKeys.FONT);
        short fontSize = (short)styleSheet.getIntStyleProperty(TextStyleKeys.FONTSIZE, 0);
        boolean bold = styleSheet.getBooleanStyleProperty(TextStyleKeys.BOLD);
        boolean italic = styleSheet.getBooleanStyleProperty(TextStyleKeys.ITALIC);
        boolean underline = styleSheet.getBooleanStyleProperty(TextStyleKeys.UNDERLINED);
        boolean strikethrough = styleSheet.getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH);
        HSSFFontWrapper wrapper = new HSSFFontWrapper(fontName, fontSize, bold, italic, underline, strikethrough, this.colorProducer.getNearestColor(textColor));
        RichTextFormat rtf = new RichTextFormat(this.getTextLength(), wrapper);
        if (this.buffer.isEmpty()) {
            this.buffer.add(rtf);
        } else {
            RichTextFormat lastRtf = (RichTextFormat)this.buffer.get(this.buffer.size() - 1);
            if (!lastRtf.getFont().equals(rtf.getFont())) {
                this.buffer.add(rtf);
            }
        }
        return true;
    }

    private static class RichTextFormat {
        private int position;
        private HSSFFontWrapper font;

        protected RichTextFormat(int position, HSSFFontWrapper font) {
            if (font == null) {
                throw new NullPointerException();
            }
            this.position = position;
            this.font = font;
        }

        public int getPosition() {
            return this.position;
        }

        public HSSFFontWrapper getFont() {
            return this.font;
        }
    }
}

