/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import org.apache.poi.ss.usermodel.Font;

public final class HSSFFontWrapper {
    public static final int FONT_FACTOR = 20;
    private final String fontName;
    private final short colorIndex;
    private final int fontHeight;
    private final boolean bold;
    private final boolean italic;
    private final boolean underline;
    private final boolean strikethrough;
    private int hashCode;

    public HSSFFontWrapper(String fontName, short fontSize, boolean bold, boolean italic, boolean underline, boolean strikethrough, short colorIndex) {
        if (fontName == null) {
            throw new NullPointerException("FontDefinition is null");
        }
        this.fontName = "SansSerif".equalsIgnoreCase(fontName) ? "Arial" : ("Monosspace".equalsIgnoreCase(fontName) ? "Courier New" : ("Serif".equalsIgnoreCase(fontName) ? "Times New Roman" : fontName));
        this.colorIndex = colorIndex;
        this.fontHeight = fontSize;
        this.bold = bold;
        this.italic = italic;
        this.underline = underline;
        this.strikethrough = strikethrough;
    }

    public HSSFFontWrapper(Font font) {
        if (font == null) {
            throw new NullPointerException("Font is null");
        }
        this.fontName = font.getFontName();
        this.colorIndex = font.getColor();
        this.fontHeight = font.getFontHeightInPoints();
        this.italic = font.getItalic();
        this.bold = font.getBoldweight() == 700;
        this.underline = font.getUnderline() != 0;
        this.strikethrough = font.getStrikeout();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HSSFFontWrapper)) {
            return false;
        }
        HSSFFontWrapper wrapper = (HSSFFontWrapper)o;
        if (this.bold != wrapper.bold) {
            return false;
        }
        if (this.underline != wrapper.strikethrough) {
            return false;
        }
        if (this.strikethrough != wrapper.strikethrough) {
            return false;
        }
        if (this.colorIndex != wrapper.colorIndex) {
            return false;
        }
        if (this.fontHeight != wrapper.fontHeight) {
            return false;
        }
        if (this.italic != wrapper.italic) {
            return false;
        }
        return this.fontName.equals(wrapper.fontName);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = this.fontName.hashCode();
            result = 29 * result + this.colorIndex;
            result = 29 * result + this.fontHeight;
            result = 29 * result + (this.bold ? 1 : 0);
            this.hashCode = result = 29 * result + (this.italic ? 1 : 0);
        }
        return this.hashCode;
    }

    public boolean isBold() {
        return this.bold;
    }

    public short getColorIndex() {
        return this.colorIndex;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public boolean isUnderline() {
        return this.underline;
    }
}

