/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.xml;

import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.GenericOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.xml.XMLWriter;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class XMLProcessor
extends AbstractReportProcessor {
    private Writer writer;
    private static final String EXPORT_DESCRIPTOR = "document/xml";

    public XMLProcessor(MasterReport report) throws ReportProcessingException {
        super(report, new XMLDataOutputProcessor(report.getConfiguration()));
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    protected static boolean isStrictErrorHandling(Configuration config) {
        String strictError = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.StrictErrorHandling");
        return "true".equals(strictError);
    }

    protected OutputFunction createLayoutManager() {
        XMLWriter xmlWriter = new XMLWriter();
        xmlWriter.setWriter(this.writer);
        return xmlWriter;
    }

    private static class XMLDataOutputProcessor
    extends AbstractOutputProcessor {
        private OutputProcessorMetaData metaData;

        private XMLDataOutputProcessor(Configuration config) {
            this.metaData = new GenericOutputProcessorMetaData(config, XMLProcessor.EXPORT_DESCRIPTOR);
        }

        protected void processPageContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage) throws ContentProcessingException {
        }

        public OutputProcessorMetaData getMetaData() {
            return this.metaData;
        }
    }
}

