/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.xml;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.process.SubReportProcessType;
import org.pentaho.reporting.libraries.xmlns.writer.CharacterEntityParser;

public class XMLWriter
extends AbstractFunction
implements OutputFunction {
    private static final Log logger = LogFactory.getLog(XMLWriter.class);
    private Writer w;
    private int depLevel;
    private final CharacterEntityParser entityParser;
    private static final InlineSubreportMarker[] EMPTY_SUBREPORTS = new InlineSubreportMarker[0];

    public XMLWriter() {
        this.setDependencyLevel(-2);
        this.entityParser = CharacterEntityParser.createXMLEntityParser();
    }

    public Writer getWriter() {
        return this.w;
    }

    public void setWriter(Writer w) {
        this.w = w;
    }

    private void writeBand(Band b) throws IOException {
        for (Element e : b.unsafeGetElementArray()) {
            if (e instanceof Band) {
                this.w.write("<band>");
                this.writeBand((Band)e);
                this.w.write("</band>");
                continue;
            }
            this.w.write("<element name=\"");
            this.w.write(this.entityParser.encodeEntities(e.getName()));
            this.w.write("\">");
            String value = String.valueOf(e.getElementType().getValue(this.getRuntime(), e));
            this.w.write(this.entityParser.encodeEntities(value));
            this.w.write("</element>");
        }
    }

    public void reportStarted(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            return;
        }
        try {
            this.w.write("<report>");
            this.w.write("<reportheader>");
            this.writeBand(event.getReport().getReportHeader());
            this.w.write("</reportheader>");
        }
        catch (IOException ioe) {
            logger.error((Object)"Error writing the band", (Throwable)ioe);
        }
    }

    public void reportFinished(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            return;
        }
        try {
            this.w.write("<reportfooter>");
            this.writeBand(event.getReport().getReportFooter());
            this.w.write("</reportfooter>");
            this.w.write("</report>");
        }
        catch (IOException ioe) {
            logger.error((Object)"Error writing the band", (Throwable)ioe);
        }
    }

    public void groupStarted(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            return;
        }
        try {
            this.w.write("<groupheader name=\"");
            Group g = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
            this.w.write(this.entityParser.encodeEntities(g.getName()));
            this.w.write("\">");
            this.writeBand(g.getHeader());
            this.w.write("</groupheader>");
        }
        catch (IOException ioe) {
            logger.error((Object)"Error writing the band", (Throwable)ioe);
        }
    }

    public void groupFinished(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            return;
        }
        try {
            this.w.write("<groupfooter name=\"");
            Group g = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
            this.w.write(this.entityParser.encodeEntities(g.getName()));
            this.w.write("\">");
            this.writeBand(g.getFooter());
            this.w.write("</groupfooter>");
        }
        catch (IOException ioe) {
            logger.error((Object)"Error writing the band", (Throwable)ioe);
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            return;
        }
        try {
            this.w.write("<itemband>");
            this.writeBand(event.getReport().getItemBand());
            this.w.write("</itemband>");
        }
        catch (IOException ioe) {
            logger.error((Object)"Error writing the band", (Throwable)ioe);
        }
    }

    public void itemsStarted(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            return;
        }
        try {
            if (event.getState().getNumberOfRows() == 0) {
                this.w.write("<nodata>");
                this.writeBand(event.getReport().getNoDataBand());
                this.w.write("</nodata>");
            }
            this.w.write("<details-header>");
            this.writeBand(event.getReport().getDetailsHeader());
            this.w.write("</details-header>");
            this.w.write("<items>");
        }
        catch (IOException ioe) {
            logger.error((Object)"Error writing the items tag", (Throwable)ioe);
        }
    }

    public void itemsFinished(ReportEvent event) {
        if (event.getState().isPrepareRun()) {
            return;
        }
        try {
            this.w.write("<details-footer>");
            this.writeBand(event.getReport().getDetailsFooter());
            this.w.write("</details-footer>");
            this.w.write("</items>");
        }
        catch (IOException ioe) {
            logger.error((Object)"Error writing the items tag", (Throwable)ioe);
        }
    }

    public Object getValue() {
        return this;
    }

    public int getDependencyLevel() {
        return this.depLevel;
    }

    public void setDependencyLevel(int deplevel) {
        this.depLevel = deplevel;
    }

    public OutputFunction deriveForStorage() {
        try {
            return (OutputFunction)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public OutputFunction deriveForPagebreak() {
        try {
            return (OutputFunction)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        XMLWriter o = (XMLWriter)super.clone();
        return o;
    }

    public InlineSubreportMarker[] getInlineSubreports() {
        return EMPTY_SUBREPORTS;
    }

    public void clearInlineSubreports(SubReportProcessType inlineExecution) {
    }

    public void restart(ReportState state) {
    }

    public boolean createRollbackInformation() {
        return false;
    }
}

