/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base.common;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.PropertyStringReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class ConfigurationReadHandler
extends AbstractPropertyXmlReadHandler {
    private ModifiableConfiguration configuration;
    private HashMap fieldHandlers;

    public ConfigurationReadHandler(ModifiableConfiguration configuration) {
        this.configuration = configuration;
        this.fieldHandlers = new HashMap();
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes attrs) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("property".equals(tagName)) {
            String name = attrs.getValue(this.getUri(), "name");
            if (name == null) {
                throw new SAXException("Required attribute 'name' is missing.");
            }
            PropertyStringReadHandler readHandler = new PropertyStringReadHandler();
            this.fieldHandlers.put(name, readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (Map.Entry entry : this.fieldHandlers.entrySet()) {
            String originalKey = (String)entry.getKey();
            String key = CompatibilityMapperUtil.mapConfigurationKey(originalKey);
            PropertyStringReadHandler readHandler = (PropertyStringReadHandler)entry.getValue();
            this.configuration.setConfigProperty(key, CompatibilityMapperUtil.mapConfigurationValue(originalKey, key, readHandler.getResult()));
        }
    }

    public Object getObject() {
        return this.configuration;
    }
}

