/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base.common;

import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.DataFactoryReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.SAXException;

public class DataFactoryRefReadHandler
extends AbstractPropertyXmlReadHandler
implements DataFactoryReadHandler {
    private DataFactory dataFactory;

    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        String href = attrs.getValue(this.getUri(), "href");
        if (href != null) {
            ResourceKey key = this.getRootHandler().getSource();
            ResourceManager manager = this.getRootHandler().getResourceManager();
            try {
                ResourceKey derivedKey = manager.deriveKey(key, href);
                Resource resource = manager.create(derivedKey, null, DataFactory.class);
                this.getRootHandler().getDependencyCollector().add(resource);
                this.dataFactory = (DataFactory)resource.getResource();
            }
            catch (ResourceKeyCreationException e) {
                throw new ParseException("Unable to derive key for " + key + " and " + href, (Exception)((Object)e), this.getLocator());
            }
            catch (ResourceCreationException e) {
                throw new ParseException("Unable to parse resource for " + key + " and " + href, (Exception)((Object)e), this.getLocator());
            }
            catch (ResourceLoadingException e) {
                throw new ParseException("Unable to load resource data for " + key + " and " + href, (Exception)((Object)e), this.getLocator());
            }
            catch (ResourceException e) {
                throw new ParseException("Unable to parse resource for " + key + " and " + href, (Exception)((Object)e), this.getLocator());
            }
            return;
        }
        String dfType = CompatibilityMapperUtil.mapClassName(attrs.getValue(this.getUri(), "type"));
        if (dfType != null) {
            Object o = ObjectUtilities.loadAndInstantiate((String)dfType, this.getClass(), DataFactory.class);
            if (o == null) {
                throw new ParseException("'type' did not point to a usable DataFactory implementation.", this.getLocator());
            }
            this.dataFactory = (DataFactory)o;
        }
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    public Object getObject() {
        return this.dataFactory;
    }
}

