/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base.common;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.PropertyStringReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.SAXException;

public class ExpressionPropertyReadHandler
extends PropertyStringReadHandler {
    public static final String NAME_ATT = "name";
    public static final String CLASS_ATT = "class";
    private BeanUtility beanUtility;
    private String propertyName;
    private String propertyType;
    private String expressionName;
    private String originalExpressionClass;
    private String expressionClass;
    private static final Log logger = LogFactory.getLog(ExpressionPropertyReadHandler.class);
    private boolean strictParsing;

    public ExpressionPropertyReadHandler(BeanUtility expression, String originalExpressionClass, String expressionClass, String expressionName) {
        if (expression == null) {
            throw new NullPointerException();
        }
        this.originalExpressionClass = originalExpressionClass;
        this.expressionClass = expressionClass;
        this.expressionName = expressionName;
        this.beanUtility = expression;
        this.strictParsing = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.parser.base.StrictParseMode"));
        if (this.strictParsing) {
            this.strictParsing = ObjectUtilities.equal((Object)originalExpressionClass, (Object)expressionClass);
        }
    }

    public void startParsing(PropertyAttributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.propertyType = CompatibilityMapperUtil.mapClassName(attrs.getValue(this.getUri(), CLASS_ATT));
        this.propertyName = attrs.getValue(this.getUri(), NAME_ATT);
        if (this.propertyName == null) {
            throw new ParseException("Required attribute 'name' is null.", this.getLocator());
        }
    }

    public void doneParsing() throws SAXException {
        super.doneParsing();
        String result = this.getResult();
        String propertyName = CompatibilityMapperUtil.mapExpressionProperty(this.originalExpressionClass, this.expressionClass, this.propertyName);
        if (this.beanUtility == null) {
            throw new ParseException("No current beanUtility", this.getLocator());
        }
        try {
            if (this.propertyType != null) {
                ClassLoader cl = ObjectUtilities.getClassLoader(ExpressionPropertyReadHandler.class);
                Class<?> c = Class.forName(this.propertyType, false, cl);
                this.beanUtility.setPropertyAsString(propertyName, c, result);
            } else {
                this.beanUtility.setPropertyAsString(propertyName, result);
            }
        }
        catch (BeanException e) {
            if (this.strictParsing) {
                throw new ParseException("Unable to assign property '" + propertyName + "' to expression '" + this.expressionName + '\'', (Exception)((Object)e), this.getLocator());
            }
            logger.warn((Object)("Legacy-Parser warning: Unable to assign property '" + propertyName + "' to expression '" + this.expressionName + '\''), (Throwable)new ParseException("Unable to assign property '" + propertyName + "' to expression '" + this.expressionName + '\'', (Exception)((Object)e), this.getLocator()));
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("Unable to assign property '" + propertyName + "' to expression '" + this.expressionName + '\'', (Exception)e, this.getLocator());
        }
    }

    public Object getObject() {
        return null;
    }
}

