/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base.common;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ExpressionReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.PropertyReferenceReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class FunctionsReadHandler
extends AbstractPropertyXmlReadHandler {
    private AbstractReportDefinition report;
    private ArrayList expressionHandlers;
    private ArrayList propertyRefs;

    public FunctionsReadHandler(AbstractReportDefinition report) {
        this.report = report;
        this.expressionHandlers = new ArrayList();
        this.propertyRefs = new ArrayList();
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes attrs) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("expression".equals(tagName) || "function".equals(tagName)) {
            ExpressionReadHandler readHandler = new ExpressionReadHandler();
            this.expressionHandlers.add(readHandler);
            return readHandler;
        }
        if ("property-ref".equals(tagName)) {
            PropertyReferenceReadHandler readHandler = new PropertyReferenceReadHandler();
            this.propertyRefs.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.expressionHandlers.size(); ++i) {
            ExpressionReadHandler readHandler = (ExpressionReadHandler)((Object)this.expressionHandlers.get(i));
            if (readHandler.getObject() == null) continue;
            this.report.addExpression((Expression)readHandler.getObject());
        }
        MasterReport master = this.report instanceof MasterReport ? (MasterReport)this.report : null;
        for (int i = 0; i < this.propertyRefs.size(); ++i) {
            String text;
            PropertyReferenceReadHandler readHandler = (PropertyReferenceReadHandler)this.propertyRefs.get(i);
            Object object = readHandler.getObject();
            if (object == null || object instanceof String && (text = (String)object).length() == 0) continue;
            if (master != null) {
                master.getParameterValues().put(readHandler.getPropertyName(), object);
                this.report.getProperties().put(readHandler.getPropertyName(), object);
                continue;
            }
            this.report.setProperty(readHandler.getPropertyName(), object);
        }
    }

    public Object getObject() {
        return null;
    }
}

