/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base.common;

import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ExpressionPropertyReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.PropertyStringReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.SAXException;

public class LayoutPreprocessorPropertyReadHandler
extends PropertyStringReadHandler {
    private BeanUtility beanUtility;
    private String propertyName;
    private String propertyType;

    public LayoutPreprocessorPropertyReadHandler(BeanUtility expression) {
        this.beanUtility = expression;
    }

    public void startParsing(PropertyAttributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.propertyType = CompatibilityMapperUtil.mapClassName(attrs.getValue(this.getUri(), "class"));
        this.propertyName = attrs.getValue(this.getUri(), "name");
        if (this.propertyName == null) {
            throw new ParseException("Required attribute 'name' is null.", this.getLocator());
        }
    }

    public void doneParsing() throws SAXException {
        super.doneParsing();
        String result = this.getResult();
        if (this.beanUtility == null) {
            throw new SAXException("No current beanUtility");
        }
        try {
            if (this.propertyType != null) {
                ClassLoader cl = ObjectUtilities.getClassLoader(ExpressionPropertyReadHandler.class);
                Class<?> c = Class.forName(this.propertyType, false, cl);
                this.beanUtility.setPropertyAsString(this.propertyName, c, result);
            } else {
                this.beanUtility.setPropertyAsString(this.propertyName, result);
            }
        }
        catch (BeanException e) {
            throw new ParseException("Unable to assign property '" + this.propertyName + "' to the specified Layout-PreProcessor", (Exception)((Object)e), this.getLocator());
        }
        catch (ClassNotFoundException e) {
            throw new ParseException("Unable to assign property '" + this.propertyName + "' to expression Layout-PreProcessor", (Exception)e, this.getLocator());
        }
    }

    public Object getObject() {
        return null;
    }
}

