/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base.common;

import java.beans.IntrospectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ExpressionPropertiesReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class StyleExpressionHandler
extends AbstractPropertyXmlReadHandler {
    private static final Log logger = LogFactory.getLog(StyleExpressionHandler.class);
    private String originalClassName;
    private String expressionClassName;
    private Expression expression;
    private StyleKey key;

    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        String expressionName = attrs.getValue(this.getUri(), "style-key");
        if (expressionName == null) {
            throw new SAXException("Required attribute 'style-key' is missing.");
        }
        if (ElementStyleKeys.isLegacyKey(expressionName)) {
            return;
        }
        this.key = StyleKey.getStyleKey(expressionName);
        if (this.key == null) {
            throw new SAXException("Required attribute 'style-key' is invalid.");
        }
        String className = attrs.getValue(this.getUri(), "class");
        String formula = attrs.getValue(this.getUri(), "formula");
        if (className == null) {
            if (formula != null) {
                FormulaExpression expression = new FormulaExpression();
                expression.setFormula(formula);
                this.expression = expression;
                this.expression.setName(expressionName);
                this.originalClassName = FormulaExpression.class.getName();
                this.expressionClassName = FormulaExpression.class.getName();
            } else {
                logger.warn((Object)("Required attribute 'class' is missing. Gracefully ignoring the error." + this.getLocator()));
            }
        }
        if (this.expression == null && className != null) {
            String mappedClassName = CompatibilityMapperUtil.mapClassName(className);
            this.expression = (Expression)ObjectUtilities.loadAndInstantiate((String)mappedClassName, ((Object)((Object)this)).getClass(), Expression.class);
            if (this.expression == null) {
                throw new ParseException("Expression '" + className + "' is not valid. The specified class was not found.", this.getLocator());
            }
            this.originalClassName = className;
            this.expressionClassName = mappedClassName;
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if (this.key == null) {
            return new IgnoreAnyChildReadHandler();
        }
        if ("properties".equals(tagName) && this.expression != null) {
            try {
                return new ExpressionPropertiesReadHandler(this.expression, this.originalClassName, this.expressionClassName);
            }
            catch (IntrospectionException e) {
                throw new SAXException("Unable to create Introspector for the specified expression.");
            }
        }
        return null;
    }

    public Object getObject() {
        return this.expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public StyleKey getKey() {
        return this.key;
    }
}

