/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base.compat;

import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatiblityMapping;
import org.pentaho.reporting.libraries.base.util.FloatDimension;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class DefaultCompatibilityMapping
implements CompatiblityMapping {
    private static final String OLD_DEMO = "org.jfree.report.demo.";
    private static final String NEW_DEMO = "org.pentaho.reporting.engine.classic.demo.";
    private static final String OLD_ANCIENT = "org.jfree.report.ancient.";
    private static final String NEW_ANCIENT = "org.pentaho.reporting.engine.classic.demo.ancient.";
    private static final String OLD_EXT = "org.jfree.report.ext.";
    private static final String NEW_EXT = "org.pentaho.reporting.engine.classic.extensions.";
    private static final String OLD_CORE = "org.jfree.report.";
    private static final String NEW_CORE = "org.pentaho.reporting.engine.classic.core.";
    private static final String JREFINERY_CORE = "com.jrefinery.report.";
    private HashMap classMappings = new HashMap();
    private static final String JREFINERY_PDFOUTPUT_CONFIG = "com.jrefinery.report.targets.pageable.output.PDFOutputTarget.default.";

    public DefaultCompatibilityMapping() {
        this.classMappings.put("org.jfree.ui.FloatDimension", FloatDimension.class.getName());
        this.classMappings.put("com.jrefinery.report.function.BSHExpression", "org.pentaho.reporting.engine.classic.core.modules.misc.beanshell.BSHExpression");
    }

    public String mapClassName(String className) {
        if (className == null) {
            return null;
        }
        return this.performMapping(className);
    }

    private String performMapping(String className) {
        String value = (String)this.classMappings.get(className);
        if (value != null) {
            return value;
        }
        if (className.startsWith(OLD_ANCIENT)) {
            return NEW_ANCIENT + className.substring(OLD_ANCIENT.length());
        }
        if (className.startsWith(OLD_DEMO)) {
            return NEW_DEMO + className.substring(OLD_DEMO.length());
        }
        if (className.startsWith(OLD_EXT)) {
            return NEW_EXT + className.substring(OLD_EXT.length());
        }
        if (className.startsWith(OLD_CORE)) {
            return NEW_CORE + className.substring(OLD_CORE.length());
        }
        if (className.startsWith(JREFINERY_CORE)) {
            return NEW_CORE + className.substring(JREFINERY_CORE.length());
        }
        return className;
    }

    public String mapConfigurationKey(String key) {
        if (key == null) {
            return null;
        }
        if (key.startsWith(JREFINERY_PDFOUTPUT_CONFIG)) {
            return "org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf." + key.substring(JREFINERY_CORE.length());
        }
        return this.performMapping(key);
    }

    public String mapConfigurationValue(String originalKey, String mappedKey, String value) {
        if (mappedKey == null) {
            return null;
        }
        if (value == null) {
            return null;
        }
        return this.performMapping(value);
    }

    public String mapExpressionProperty(String expressionName, String mappedExpression, String propertyName) {
        if ("com.jrefinery.report.function.TextFormatExpression".equals(expressionName) && ParserUtil.parseInt((String)propertyName, (int)-1) >= 0) {
            return "field[" + propertyName + "]";
        }
        return propertyName;
    }
}

