/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.content;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.data.SubReportDataDefinition;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SubContentRootElementHandler
extends AbstractXmlReadHandler {
    private static final Log logger = LogFactory.getLog(SubContentRootElementHandler.class);
    private SubReport report;

    public void init(RootXmlReadHandler rootHandler, String uri, String tagName) {
        super.init(rootHandler, uri, tagName);
        rootHandler.setHelperObject("property-expansion", (Object)Boolean.FALSE);
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        Object maybeReport = this.getRootHandler().getHelperObject("::Report");
        if (!(maybeReport instanceof SubReport)) {
            this.report = new SubReport();
            this.getRootHandler().setHelperObject("::Report", (Object)this.report);
        } else {
            this.report = (SubReport)maybeReport;
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!"http://reporting.pentaho.org/namespaces/engine/classic/bundle/content/1.0".equals(uri)) {
            return null;
        }
        if ("data-definition".equals(tagName)) {
            String fallbackFile;
            String primaryFile = atts.getValue(this.getUri(), "ref");
            if (primaryFile == null) {
                throw new ParseException("Required attribute 'ref' is not specified", this.getLocator());
            }
            if (!this.parseDataDefinition(primaryFile) && (fallbackFile = atts.getValue(this.getUri(), "local-copy")) != null && !this.parseDataDefinition(fallbackFile)) {
                throw new ParseException("Parsing the specified local-copy failed", this.getLocator());
            }
            return new IgnoreAnyChildReadHandler();
        }
        if ("styles".equals(tagName)) {
            String fallbackFile;
            String primaryFile = atts.getValue(this.getUri(), "ref");
            if (primaryFile == null) {
                throw new ParseException("Required attribute 'ref' is not specified", this.getLocator());
            }
            if (!this.parseStyles(primaryFile) && (fallbackFile = atts.getValue(this.getUri(), "local-copy")) != null && !this.parseStyles(fallbackFile)) {
                throw new ParseException("Parsing the specified local-copy failed", this.getLocator());
            }
            return new IgnoreAnyChildReadHandler();
        }
        if ("layout".equals(tagName)) {
            String fallbackFile;
            String primaryFile = atts.getValue(this.getUri(), "ref");
            if (primaryFile == null) {
                throw new ParseException("Required attribute 'ref' is not specified", this.getLocator());
            }
            if (!this.parseLayout(primaryFile) && (fallbackFile = atts.getValue(this.getUri(), "local-copy")) != null && !this.parseLayout(fallbackFile)) {
                throw new ParseException("Parsing the specified local-copy failed", this.getLocator());
            }
            return new IgnoreAnyChildReadHandler();
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        this.parseLocalFiles();
    }

    private void parseLocalFiles() throws ParseException {
        this.parseDataDefinition("datadefinition.xml");
        this.parseStyles("styles.xml");
        this.parseLayout("layout.xml");
    }

    private boolean parseLayout(String layout) throws ParseException {
        try {
            SubReport report = (SubReport)this.performExternalParsing(layout, SubReport.class);
            return report == this.report;
        }
        catch (ResourceLoadingException e) {
            logger.warn((Object)("Unable to parse the parameter for this bundle from file: " + layout));
            return false;
        }
    }

    private boolean parseStyles(String stylefile) throws ParseException {
        try {
            SubReport report = (SubReport)this.performExternalParsing(stylefile, SubReport.class);
            return report == this.report;
        }
        catch (ResourceLoadingException e) {
            logger.warn((Object)("Unable to parse the parameter for this bundle from file: " + stylefile));
            return false;
        }
    }

    private boolean parseDataDefinition(String parameterFile) throws ParseException {
        try {
            Map parameters = this.deriveParseParameters();
            parameters.put(new FactoryParameterKey("::Report"), null);
            SubReportDataDefinition dataDefinition = (SubReportDataDefinition)this.performExternalParsing(parameterFile, SubReportDataDefinition.class, parameters);
            this.report.setDataFactory(dataDefinition.getDataFactory());
            this.report.setQuery(dataDefinition.getQuery());
            this.report.setQueryLimit(dataDefinition.getQueryLimit());
            this.report.setQueryTimeout(dataDefinition.getQueryTimeout());
            ParameterMapping[] inputMapping = dataDefinition.getImportParameters();
            for (int i = 0; i < inputMapping.length; ++i) {
                ParameterMapping mapping = inputMapping[i];
                this.report.addInputParameter(mapping.getName(), mapping.getAlias());
            }
            ParameterMapping[] exportMapping = dataDefinition.getExportParameters();
            for (int i = 0; i < exportMapping.length; ++i) {
                ParameterMapping mapping = exportMapping[i];
                this.report.addExportParameter(mapping.getName(), mapping.getAlias());
            }
            Expression[] expressions = dataDefinition.getExpressions();
            if (expressions != null) {
                for (int i = 0; i < expressions.length; ++i) {
                    Expression expression = expressions[i];
                    this.report.addExpression(expression);
                }
            }
            return true;
        }
        catch (ResourceLoadingException e) {
            logger.warn((Object)("Unable to parse the parameter for this bundle from file: " + parameterFile));
            return false;
        }
        catch (ReportDataFactoryException e) {
            throw new ParseException("Unable to configure datafactory.", this.getLocator());
        }
    }

    public Object getObject() throws SAXException {
        return this.report;
    }
}

