/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.data;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.data.ParameterAttributeReadHandler;
import org.pentaho.reporting.engine.classic.core.parameters.AbstractParameter;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractParameterReadHandler
extends AbstractXmlReadHandler {
    private String name;
    private Class type;
    private boolean mandatory;
    private Object defaultValue;
    private ArrayList attributeReadHandlers = new ArrayList();

    protected AbstractParameterReadHandler() {
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        this.name = attrs.getValue(this.getUri(), "name");
        if (this.name == null) {
            throw new ParseException("Required parameter 'name' is missing.", this.getLocator());
        }
        String typeText = attrs.getValue(this.getUri(), "type");
        if (typeText == null) {
            this.type = Object.class;
        } else {
            try {
                String realClassName = CompatibilityMapperUtil.mapClassName(typeText);
                ClassLoader classLoader = ObjectUtilities.getClassLoader(((Object)((Object)this)).getClass());
                this.type = Class.forName(realClassName, false, classLoader);
            }
            catch (Throwable e) {
                throw new ParseException("Required parameter 'type' is invalid.", this.getLocator());
            }
        }
        this.mandatory = "true".equals(attrs.getValue(this.getUri(), "mandatory"));
        String defaultValueText = attrs.getValue(this.getUri(), "default-value");
        if (defaultValueText != null) {
            try {
                this.defaultValue = ConverterRegistry.toPropertyValue(defaultValueText, this.type);
            }
            catch (BeanException e) {
                throw new ParseException("Specified parameter 'default-value' is invalid.", this.getLocator());
            }
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("attribute".equals(tagName)) {
            ParameterAttributeReadHandler readHandler = new ParameterAttributeReadHandler();
            this.attributeReadHandlers.add(readHandler);
            return readHandler;
        }
        return null;
    }

    protected void applyAttributes(AbstractParameter parameter) {
        ParameterAttributeReadHandler[] parameterAttributeReadHandlers = this.getAttributeReadHandlers();
        for (int i = 0; i < parameterAttributeReadHandlers.length; ++i) {
            ParameterAttributeReadHandler handler = parameterAttributeReadHandlers[i];
            parameter.setParameterAttribute(handler.getNamespace(), handler.getName(), handler.getResult());
        }
    }

    private ParameterAttributeReadHandler[] getAttributeReadHandlers() {
        return this.attributeReadHandlers.toArray(new ParameterAttributeReadHandler[this.attributeReadHandlers.size()]);
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

