/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout;

import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.StyleReadHandler;
import org.pentaho.reporting.engine.classic.core.style.BoxSizing;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CommonStyleReadHandler
extends AbstractXmlReadHandler
implements StyleReadHandler {
    private ElementStyleSheet styleSheet;

    public ElementStyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(ElementStyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        String alignment;
        String valignment;
        String avoidPagebreak;
        String overflowY;
        String overflowX;
        String orphans;
        String widows;
        String invisibleConsumesSpace;
        String visible;
        String boxSizing;
        String hrefWindow;
        String hrefTitle;
        String hrefTarget;
        String anchorName = attrs.getValue(this.getUri(), "anchor-name");
        if (anchorName != null) {
            this.styleSheet.setStyleProperty(ElementStyleKeys.ANCHOR_NAME, anchorName);
        }
        if ((hrefTarget = attrs.getValue(this.getUri(), "href-target")) != null) {
            this.styleSheet.setStyleProperty(ElementStyleKeys.HREF_TARGET, hrefTarget);
        }
        if ((hrefTitle = attrs.getValue(this.getUri(), "href-title")) != null) {
            this.styleSheet.setStyleProperty(ElementStyleKeys.HREF_TITLE, hrefTitle);
        }
        if ((hrefWindow = attrs.getValue(this.getUri(), "href-window")) != null) {
            this.styleSheet.setStyleProperty(ElementStyleKeys.HREF_WINDOW, hrefWindow);
        }
        if ((boxSizing = attrs.getValue(this.getUri(), "box-sizing")) != null) {
            this.styleSheet.setStyleProperty(ElementStyleKeys.BOX_SIZING, this.parseBoxSizing(boxSizing));
        }
        if ((visible = attrs.getValue(this.getUri(), "visible")) != null) {
            this.styleSheet.setBooleanStyleProperty(ElementStyleKeys.VISIBLE, "true".equals(visible));
        }
        if ((invisibleConsumesSpace = attrs.getValue(this.getUri(), "invisible-consumes-space")) != null) {
            this.styleSheet.setBooleanStyleProperty(ElementStyleKeys.INVISIBLE_CONSUMES_SPACE, "true".equals(invisibleConsumesSpace));
        }
        if ((widows = attrs.getValue(this.getUri(), "widows")) != null) {
            this.styleSheet.setStyleProperty(ElementStyleKeys.WIDOWS, ReportParserUtil.parseInteger(widows, this.getLocator()));
        }
        if ((orphans = attrs.getValue(this.getUri(), "orphans")) != null) {
            this.styleSheet.setStyleProperty(ElementStyleKeys.ORPHANS, ReportParserUtil.parseInteger(orphans, this.getLocator()));
        }
        if ((overflowX = attrs.getValue(this.getUri(), "overflow-x")) != null) {
            this.styleSheet.setBooleanStyleProperty(ElementStyleKeys.OVERFLOW_X, "true".equals(overflowX));
        }
        if ((overflowY = attrs.getValue(this.getUri(), "overflow-y")) != null) {
            this.styleSheet.setBooleanStyleProperty(ElementStyleKeys.OVERFLOW_Y, "true".equals(overflowY));
        }
        if ((avoidPagebreak = attrs.getValue(this.getUri(), "avoid-page-break")) != null) {
            this.styleSheet.setBooleanStyleProperty(ElementStyleKeys.AVOID_PAGEBREAK_INSIDE, "true".equals(avoidPagebreak));
        }
        if ((valignment = attrs.getValue(this.getUri(), "vertical-alignment")) != null) {
            this.styleSheet.setStyleProperty(ElementStyleKeys.VALIGNMENT, ReportParserUtil.parseVerticalElementAlignment(valignment, this.getLocator()));
        }
        if ((alignment = attrs.getValue(this.getUri(), "alignment")) != null) {
            this.styleSheet.setStyleProperty(ElementStyleKeys.ALIGNMENT, ReportParserUtil.parseHorizontalElementAlignment(alignment, this.getLocator()));
        }
    }

    private Object parseBoxSizing(String s) {
        if (BoxSizing.CONTENT_BOX.toString().equals(s)) {
            return BoxSizing.CONTENT_BOX;
        }
        return BoxSizing.BORDER_BOX;
    }

    public Object getObject() throws SAXException {
        return null;
    }
}

