/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout;

import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.StyleReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.StyleReadHandlerFactory;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleSheetCollection;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementStyleReadHandler
extends AbstractXmlReadHandler {
    private ElementStyleSheet styleSheet;

    public ElementStyleReadHandler(ElementStyleSheet styleSheet) {
        if (styleSheet == null) {
            throw new NullPointerException();
        }
        this.styleSheet = styleSheet;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        Object maybeReport = this.getRootHandler().getHelperObject("::Report");
        if (!(maybeReport instanceof ReportDefinition)) {
            throw new ParseException("Invalid internal configuration for 'report-obj'", this.getLocator());
        }
        ReportDefinition def = (ReportDefinition)maybeReport;
        StyleSheetCollection styleSheetCollection = def.getStyleSheetCollection();
        String parent = attrs.getValue(this.getUri(), "parent");
        if (parent != null) {
            String[] classes = StringUtils.split((String)parent, (String)" ", (String)"'");
            for (int i = 0; i < classes.length; ++i) {
                String aClass = classes[i];
                ElementStyleSheet parentStyleSheet = styleSheetCollection.createStyleSheet(aClass);
                try {
                    this.styleSheet.addParent(parentStyleSheet);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ParseException("Loop detected: Specified parent style-sheet is invalid here.", (Exception)e, this.getLocator());
                }
            }
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        StyleReadHandler readHandler = (StyleReadHandler)StyleReadHandlerFactory.getInstance().getHandler(uri, tagName);
        if (readHandler == null) {
            throw new ParseException("Unable to locate style-handler for <" + uri + '|' + tagName + '>', this.getLocator());
        }
        readHandler.setStyleSheet(this.styleSheet);
        return readHandler;
    }

    public Object getObject() throws SAXException {
        return this.styleSheet;
    }
}

