/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout;

import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.StyleReadHandler;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PageBandStyleReadHandler
extends AbstractXmlReadHandler
implements StyleReadHandler {
    private ElementStyleSheet styleSheet;

    public ElementStyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(ElementStyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }

    protected void startParsing(Attributes atts) throws SAXException {
        String fixedPosition;
        String sticky;
        String displayOnLastPage;
        String displayOnFirstPage;
        String repeat = atts.getValue(this.getUri(), "repeat");
        if (repeat != null) {
            this.styleSheet.setBooleanStyleProperty(BandStyleKeys.REPEAT_HEADER, "true".equals(repeat));
        }
        if ((displayOnFirstPage = atts.getValue(this.getUri(), "display-on-first-page")) != null) {
            this.styleSheet.setBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE, "true".equals(displayOnFirstPage));
        }
        if ((displayOnLastPage = atts.getValue(this.getUri(), "display-on-last-page")) != null) {
            this.styleSheet.setBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE, "true".equals(displayOnLastPage));
        }
        if ((sticky = atts.getValue(this.getUri(), "sticky")) != null) {
            this.styleSheet.setBooleanStyleProperty(BandStyleKeys.STICKY, "true".equals(sticky));
        }
        if ((fixedPosition = atts.getValue(this.getUri(), "fixed-position")) != null) {
            this.styleSheet.setStyleProperty(BandStyleKeys.FIXED_POSITION, new Float(ReportParserUtil.parseRelativeFloat(fixedPosition, "Attribute 'fixed-position' not valid", this.getLocator())));
        }
    }

    public Object getObject() throws SAXException {
        return this.styleSheet;
    }
}

