/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout;

import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.LayoutProcessorReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.PageDefinitionReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.StyleRuleReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.PageFooterReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.PageHeaderReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.WatermarkReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StylesRootElementHandler
extends AbstractXmlReadHandler {
    private PageFooterReadHandler pageFooterReadHandler;
    private PageHeaderReadHandler pageHeaderReadHandler;
    private WatermarkReadHandler watermarkReadHandler;
    private LayoutProcessorReadHandler layoutProcessorHandler;
    private AbstractReportDefinition report;

    protected void startParsing(Attributes attrs) throws SAXException {
        Object maybeReport = this.getRootHandler().getHelperObject("::Report");
        if (maybeReport instanceof SubReport) {
            this.report = (SubReport)maybeReport;
        } else if (maybeReport instanceof MasterReport) {
            this.report = (MasterReport)maybeReport;
        } else {
            this.report = ReportParserUtil.INCLUDE_PARSING_VALUE.equals(this.getRootHandler().getHelperObject("::Include-parser")) ? new SubReport() : new MasterReport();
            this.getRootHandler().setHelperObject("::Report", (Object)this.report);
        }
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0".equals(uri)) {
            if ("page-definition".equals(tagName)) {
                return new PageDefinitionReadHandler();
            }
            if ("style-rule".equals(tagName)) {
                return new StyleRuleReadHandler();
            }
        }
        if ("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0".equals(uri)) {
            if ("layout-processors".equals(tagName)) {
                this.layoutProcessorHandler = new LayoutProcessorReadHandler();
                return this.layoutProcessorHandler;
            }
            if ("watermark".equals(tagName)) {
                if (this.watermarkReadHandler == null) {
                    this.watermarkReadHandler = new WatermarkReadHandler();
                }
                return this.watermarkReadHandler;
            }
            if ("page-header".equals(tagName)) {
                if (this.pageHeaderReadHandler == null) {
                    this.pageHeaderReadHandler = new PageHeaderReadHandler();
                }
                return this.pageHeaderReadHandler;
            }
            if ("page-footer".equals(tagName)) {
                if (this.pageFooterReadHandler == null) {
                    this.pageFooterReadHandler = new PageFooterReadHandler();
                }
                return this.pageFooterReadHandler;
            }
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        if (this.pageHeaderReadHandler != null) {
            this.report.setPageHeader((PageHeader)this.pageHeaderReadHandler.getElement());
        }
        if (this.watermarkReadHandler != null) {
            this.report.setWatermark((Watermark)this.watermarkReadHandler.getElement());
        }
        if (this.pageFooterReadHandler != null) {
            this.report.setPageFooter((PageFooter)this.pageFooterReadHandler.getElement());
        }
        if (this.layoutProcessorHandler != null) {
            Expression[] expressions = this.layoutProcessorHandler.getExpressions();
            for (int i = 0; i < expressions.length; ++i) {
                Expression expression = expressions[i];
                this.report.addExpression(expression);
            }
        }
    }

    public Object getObject() throws SAXException {
        return this.report;
    }
}

