/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements;

import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.AbstractElementReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.DataGroupBodyReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.GroupBodyReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.GroupFieldsReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.GroupFooterReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.GroupHeaderReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.elements.SubGroupBodyReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RelationalGroupReadHandler
extends AbstractElementReadHandler {
    private GroupHeaderReadHandler headerReadHandler;
    private GroupFooterReadHandler footerReadHandler;
    private GroupFieldsReadHandler fieldsReadHandler;
    private GroupBodyReadHandler groupBodyReadHandler;

    public RelationalGroupReadHandler() throws ParseException {
        super("relational-group");
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0".equals(uri)) {
            if ("group-header".equals(tagName)) {
                if (this.headerReadHandler == null) {
                    this.headerReadHandler = new GroupHeaderReadHandler();
                }
                return this.headerReadHandler;
            }
            if ("group-footer".equals(tagName)) {
                if (this.footerReadHandler == null) {
                    this.footerReadHandler = new GroupFooterReadHandler();
                }
                return this.footerReadHandler;
            }
            if ("fields".equals(tagName)) {
                if (this.fieldsReadHandler == null) {
                    this.fieldsReadHandler = new GroupFieldsReadHandler();
                }
                return this.fieldsReadHandler;
            }
            if ("group-body".equals(tagName)) {
                this.groupBodyReadHandler = new SubGroupBodyReadHandler();
                return this.groupBodyReadHandler;
            }
            if ("data-body".equals(tagName)) {
                this.groupBodyReadHandler = new DataGroupBodyReadHandler();
                return this.groupBodyReadHandler;
            }
        }
        return super.getHandlerForChild(uri, tagName, atts);
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        RelationalGroup group = (RelationalGroup)this.getElement();
        if (this.fieldsReadHandler != null) {
            String[] fields = this.fieldsReadHandler.getFields();
            group.setFields(Arrays.asList(fields));
        }
        if (this.headerReadHandler != null) {
            group.setHeader((GroupHeader)this.headerReadHandler.getElement());
        }
        if (this.footerReadHandler != null) {
            group.setFooter((GroupFooter)this.footerReadHandler.getElement());
        }
        if (this.groupBodyReadHandler != null) {
            group.setBody(this.groupBodyReadHandler.getGroupBody());
        }
    }

    protected Element createElement(String elementType) {
        return new RelationalGroup();
    }

    public Group getGroup() {
        return (Group)this.getElement();
    }
}

