/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleElementWriteHandler;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class BundleElementWriterFactory {
    private static final String PREFIX = "org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.element-write-handler.";

    private BundleElementWriterFactory() {
    }

    public static BundleElementWriteHandler createHandler(Element element) {
        if (element == null) {
            throw new NullPointerException();
        }
        ElementType type = element.getElementType();
        String metaName = type.getMetaData().getName();
        String configKey = PREFIX + metaName;
        Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
        String handlerClass = config.getConfigProperty(configKey);
        BundleElementWriteHandler handler = (BundleElementWriteHandler)ObjectUtilities.loadAndInstantiate((String)handlerClass, type.getClass(), BundleElementWriteHandler.class);
        if (handler == null) {
            throw new IllegalStateException("Got no handler for type " + metaName);
        }
        return handler;
    }
}

