/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer;

import java.io.IOException;
import java.util.Date;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ClassicEngineInfo;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentMetaData;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class BundleMetaFileWriter
implements BundleWriterHandler {
    public int getProcessingOrder() {
        return 100000;
    }

    public String writeReport(WriteableDocumentBundle bundle, BundleWriterState state) throws IOException, BundleWriterException {
        if (state == null) {
            throw new NullPointerException();
        }
        if (bundle == null) {
            throw new NullPointerException();
        }
        WriteableDocumentMetaData writeableMetaData = bundle.getWriteableDocumentMetaData();
        String version = ClassicEngineInfo.getInstance().getName() + ' ' + ClassicEngineInfo.getInstance().getVersion();
        writeableMetaData.setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "generator", (Object)version);
        Date currentDate = new Date();
        if (writeableMetaData.getBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "creation-date") == null) {
            writeableMetaData.setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "creation-date", (Object)currentDate);
        }
        writeableMetaData.setBundleAttribute("http://purl.org/dc/elements/1.1/", "date", (Object)currentDate);
        Object visibleFlag = state.getMasterReport().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/pentaho", "visible");
        if (Boolean.FALSE.equals(visibleFlag)) {
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "visible", (Object)"false");
        } else {
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "visible", (Object)"true");
        }
        int releaseMajor = ParserUtil.parseInt((String)ClassicEngineInfo.getInstance().getReleaseMajor(), (int)-1);
        int releaseMinor = ParserUtil.parseInt((String)ClassicEngineInfo.getInstance().getReleaseMinor(), (int)-1);
        int releasePatch = ParserUtil.parseInt((String)ClassicEngineInfo.getInstance().getReleaseMilestone(), (int)-1);
        if (ClassicEngineBoot.computeVersionId(releaseMajor, releaseMinor, releasePatch) > 0) {
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.major", (Object)releaseMajor);
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.minor", (Object)releaseMinor);
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.patch", (Object)releasePatch);
        } else {
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.major", (Object)999);
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.minor", (Object)999);
            writeableMetaData.setBundleAttribute("http://reporting.pentaho.org/namespaces/engine/classic/metadata/1.0", "prpt-spec.version.patch", (Object)999);
        }
        return null;
    }
}

