/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentMetaData;
import org.pentaho.reporting.libraries.repository.ContentIOException;

public class BundleWriter {
    private static final String MASTER_HANDLER_PREFIX = "org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.handler.master.";
    private static final String SUBREPORT_HANDLER_PREFIX = "org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.handler.subreport.";
    private BundleWriterHandler[] masterWriter;
    private BundleWriterHandler[] subreportWriter;

    public BundleWriter() {
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        Iterator masterKeys = configuration.findPropertyKeys(MASTER_HANDLER_PREFIX);
        ArrayList<BundleWriterHandler> masterWriterList = new ArrayList<BundleWriterHandler>();
        while (masterKeys.hasNext()) {
            String key = (String)masterKeys.next();
            String className = configuration.getConfigProperty(key);
            BundleWriterHandler handler = (BundleWriterHandler)ObjectUtilities.loadAndInstantiate((String)className, BundleWriter.class, BundleWriterHandler.class);
            if (handler == null) continue;
            masterWriterList.add(handler);
        }
        this.masterWriter = masterWriterList.toArray(new BundleWriterHandler[masterWriterList.size()]);
        if (this.masterWriter.length == 0) {
            throw new IllegalStateException("Bundle-Writer configuration is invalid.");
        }
        BundleWriter.sortBundleWriterHandlers(this.masterWriter);
        masterWriterList.clear();
        Iterator subKeys = configuration.findPropertyKeys(SUBREPORT_HANDLER_PREFIX);
        while (subKeys.hasNext()) {
            String key = (String)subKeys.next();
            String className = configuration.getConfigProperty(key);
            BundleWriterHandler handler = (BundleWriterHandler)ObjectUtilities.loadAndInstantiate((String)className, BundleWriter.class, BundleWriterHandler.class);
            if (handler == null) continue;
            masterWriterList.add(handler);
        }
        this.subreportWriter = masterWriterList.toArray(new BundleWriterHandler[masterWriterList.size()]);
        if (this.subreportWriter.length == 0) {
            throw new IllegalStateException("Bundle-Writer configuration is invalid.");
        }
        BundleWriter.sortBundleWriterHandlers(this.subreportWriter);
    }

    public void writeReport(WriteableDocumentBundle bundle, MasterReport report) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (report == null) {
            throw new NullPointerException();
        }
        if (bundle == report.getBundle()) {
            throw new IllegalArgumentException("Cannot write to the originating bundle.");
        }
        DocumentBundle reportBundle = report.getBundle();
        if (reportBundle == null) {
            this.writeReport(bundle, report, (DocumentBundle)new MemoryDocumentBundle());
        } else {
            this.writeReport(bundle, report, reportBundle);
        }
    }

    public void writeReport(WriteableDocumentBundle bundle, MasterReport report, DocumentBundle globalBundle) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (report == null) {
            throw new NullPointerException();
        }
        if (globalBundle == null) {
            throw new NullPointerException();
        }
        WriteableDocumentMetaData data = bundle.getWriteableDocumentMetaData();
        data.setBundleType("application/vnd.pentaho.reporting.classic");
        try {
            MasterReport clone = (MasterReport)report.derive();
            BundleWriterState state = new BundleWriterState(clone, globalBundle, this);
            for (int i = 0; i < this.masterWriter.length; ++i) {
                BundleWriterHandler handler = this.masterWriter[i];
                handler.writeReport(bundle, state);
            }
        }
        catch (CloneNotSupportedException e) {
            throw new BundleWriterException("Initial clone of the report failed", e);
        }
    }

    public void writeSubReport(WriteableDocumentBundle bundle, BundleWriterState state) throws IOException, BundleWriterException {
        if (state == null) {
            throw new NullPointerException();
        }
        if (bundle == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.subreportWriter.length; ++i) {
            BundleWriterHandler handler = this.subreportWriter[i];
            handler.writeReport(bundle, state);
        }
    }

    public static void writeReportToZipFile(MasterReport report, File file) throws IOException, BundleWriterException, ContentIOException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (file == null) {
            throw new NullPointerException();
        }
        MemoryDocumentBundle outputBundle = new MemoryDocumentBundle();
        BundleWriter writer = new BundleWriter();
        writer.writeReport((WriteableDocumentBundle)outputBundle, report);
        BundleUtilities.writeAsZip((File)file, (DocumentBundle)outputBundle);
    }

    public static void writeReportToZipStream(MasterReport report, OutputStream out) throws IOException, BundleWriterException, ContentIOException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (out == null) {
            throw new NullPointerException();
        }
        MemoryDocumentBundle documentBundle = new MemoryDocumentBundle();
        BundleWriter writer = new BundleWriter();
        writer.writeReport((WriteableDocumentBundle)documentBundle, report);
        BundleUtilities.writeAsZip((OutputStream)out, (DocumentBundle)documentBundle);
    }

    public static void writeReportToDirectory(MasterReport report, File file) throws IOException, BundleWriterException, ContentIOException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (file == null) {
            throw new NullPointerException();
        }
        MemoryDocumentBundle documentBundle = new MemoryDocumentBundle();
        BundleWriter writer = new BundleWriter();
        writer.writeReport((WriteableDocumentBundle)documentBundle, report);
        BundleUtilities.writeToDirectory((File)file, (DocumentBundle)documentBundle);
    }

    private static void sortBundleWriterHandlers(BundleWriterHandler[] masterWriter) {
        Arrays.sort(masterWriter, new BundleWriterHandlerComparator());
    }

    private static class BundleWriterHandlerComparator
    implements Comparator {
        private BundleWriterHandlerComparator() {
        }

        public int compare(Object o1, Object o2) {
            BundleWriterHandler handler1 = (BundleWriterHandler)o1;
            BundleWriterHandler handler2 = (BundleWriterHandler)o2;
            return handler1.getProcessingOrder() - handler2.getProcessingOrder();
        }
    }
}

