/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer;

import java.awt.Insets;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.CustomPageDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleElementWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleElementWriterFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.ExpressionWriterUtility;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.StyleWriterUtility;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleSheetCollection;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class StyleFileWriter
implements BundleWriterHandler {
    public int getProcessingOrder() {
        return 100000;
    }

    public String writeReport(WriteableDocumentBundle bundle, BundleWriterState state) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        BundleWriterState styleFileState = new BundleWriterState(state, "styles.xml");
        BufferedOutputStream outputStream = new BufferedOutputStream(bundle.createEntry(styleFileState.getFileName(), "text/xml"));
        DefaultTagDescription tagDescription = new DefaultTagDescription(ClassicEngineBoot.getInstance().getGlobalConfig(), "org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.");
        XmlWriter writer = new XmlWriter((Writer)new OutputStreamWriter((OutputStream)outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        writer.writeXmlDeclaration("UTF-8");
        AttributeList rootAttributes = new AttributeList();
        rootAttributes.addNamespaceDeclaration("", "http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0");
        rootAttributes.addNamespaceDeclaration("layout", "http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0");
        rootAttributes.addNamespaceDeclaration("core", "http://reporting.pentaho.org/namespaces/engine/attributes/core");
        rootAttributes.addNamespaceDeclaration("html", "http://reporting.pentaho.org/namespaces/engine/attributes/html");
        rootAttributes.addNamespaceDeclaration("swing", "http://reporting.pentaho.org/namespaces/engine/attributes/swing");
        rootAttributes.addNamespaceDeclaration("pdf", "http://reporting.pentaho.org/namespaces/engine/attributes/pdf");
        writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "style", rootAttributes, false);
        AbstractReportDefinition report = styleFileState.getReport();
        if (report instanceof MasterReport) {
            PageDefinition definition = report.getPageDefinition();
            this.writePageDefinition(writer, definition);
        }
        StyleSheetCollection styles = report.getStyleSheetCollection();
        String[] styleNames = styles.getStyleNames();
        for (int i = 0; i < styleNames.length; ++i) {
            String name = styleNames[i];
            ElementStyleSheet style = styles.getStyleSheet(name);
            StyleWriterUtility.writeStyleRule("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "style-rule", writer, style, true);
        }
        if (ExpressionWriterUtility.isGlobalLayoutExpressionActive(styleFileState)) {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "layout-processors", false);
            ExpressionWriterUtility.writeGlobalLayoutExpressions(bundle, styleFileState, writer);
            writer.writeCloseTag();
        }
        Watermark watermark = report.getWatermark();
        BundleElementWriteHandler watermarkHandler = BundleElementWriterFactory.createHandler(watermark);
        watermarkHandler.writeElement(bundle, styleFileState, writer, watermark);
        PageHeader pageHeader = report.getPageHeader();
        BundleElementWriteHandler pageHeaderHandler = BundleElementWriterFactory.createHandler(pageHeader);
        pageHeaderHandler.writeElement(bundle, styleFileState, writer, pageHeader);
        PageFooter pageFooter = report.getPageFooter();
        BundleElementWriteHandler pageFooterHandler = BundleElementWriterFactory.createHandler(pageFooter);
        pageFooterHandler.writeElement(bundle, styleFileState, writer, pageFooter);
        writer.writeCloseTag();
        writer.close();
        return styleFileState.getFileName();
    }

    private void writePageDefinition(XmlWriter writer, PageDefinition definition) throws BundleWriterException, IOException {
        if (writer == null) {
            throw new NullPointerException();
        }
        if (definition == null) {
            throw new NullPointerException();
        }
        if (!(definition instanceof SimplePageDefinition)) {
            if (definition instanceof CustomPageDefinition) {
                throw new BundleWriterException("Cannot handle 'CustomPageDefinition' objects.");
            }
            throw new BundleWriterException("Cannot handle generic page-definition objects.");
        }
        SimplePageDefinition sdef = (SimplePageDefinition)definition;
        int pageCountHorizontal = sdef.getPageCountHorizontal();
        int pageCountVertical = sdef.getPageCountVertical();
        PageFormat pageFormat = sdef.getPageFormat();
        AttributeList attr = new AttributeList();
        attr.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "horizontal-span", String.valueOf(pageCountHorizontal));
        attr.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "vertical-span", String.valueOf(pageCountVertical));
        this.buildPageFormatProperties(pageFormat, attr);
        writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "page-definition", attr, true);
    }

    private AttributeList buildPageFormatProperties(PageFormat fmt, AttributeList retval) {
        if (fmt == null) {
            throw new NullPointerException();
        }
        if (retval == null) {
            throw new NullPointerException();
        }
        Paper paper = fmt.getPaper();
        int w = (int)paper.getWidth();
        int h = (int)paper.getHeight();
        String pageDefinition = PageFormatFactory.getInstance().getPageFormatName(w, h);
        if (pageDefinition != null) {
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "pageformat", pageDefinition);
        } else {
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "width", String.valueOf(w));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "height", String.valueOf(h));
        }
        Insets borders = this.getBorders(paper);
        if (fmt.getOrientation() == 2) {
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "orientation", "reverse-landscape");
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "margin-top", String.valueOf(borders.right));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "margin-left", String.valueOf(borders.top));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "margin-bottom", String.valueOf(borders.left));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "margin-right", String.valueOf(borders.bottom));
        } else if (fmt.getOrientation() == 1) {
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "orientation", "portrait");
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "margin-top", String.valueOf(borders.top));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "margin-left", String.valueOf(borders.left));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "margin-bottom", String.valueOf(borders.bottom));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "margin-right", String.valueOf(borders.right));
        } else {
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "orientation", "landscape");
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "margin-top", String.valueOf(borders.left));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "margin-left", String.valueOf(borders.bottom));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "margin-bottom", String.valueOf(borders.right));
            retval.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "margin-right", String.valueOf(borders.top));
        }
        return retval;
    }

    private Insets getBorders(Paper p) {
        return new Insets((int)p.getImageableY(), (int)p.getImageableX(), (int)(p.getHeight() - (p.getImageableY() + p.getImageableHeight())), (int)(p.getWidth() - (p.getImageableX() + p.getImageableWidth())));
    }
}

