/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer;

import java.awt.Color;
import java.awt.Stroke;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.layout.BandLayoutManager;
import org.pentaho.reporting.engine.classic.core.layout.StackedLayoutManager;
import org.pentaho.reporting.engine.classic.core.layout.StaticLayoutManager;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.BoxSizing;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.StrokeUtility;
import org.pentaho.reporting.engine.classic.core.util.beans.ColorValueConverter;
import org.pentaho.reporting.libraries.base.util.CSVQuoter;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formatting.FastDecimalFormat;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class StyleWriterUtility {
    private static final Log logger = LogFactory.getLog(StyleWriterUtility.class);
    private static final FastDecimalFormat percentageLengthFormat = new FastDecimalFormat("0.###'%'", Locale.US);
    private static final FastDecimalFormat absoluteLengthFormat = new FastDecimalFormat("0.###", Locale.US);

    private StyleWriterUtility() {
    }

    public static void writeStyleRule(String namespace, String tagName, XmlWriter writer, ElementStyleSheet style, boolean writeName) throws IOException {
        if (namespace == null) {
            throw new NullPointerException();
        }
        if (tagName == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        if (style == null) {
            throw new NullPointerException();
        }
        String parentList = StyleWriterUtility.computeParentStyleList(style);
        if (parentList == null && style.getDefinedPropertyNamesArray().length == 0) {
            return;
        }
        AttributeList attList = new AttributeList();
        if (writeName) {
            attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "name", style.getName());
        }
        if (parentList != null) {
            attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "parent", parentList);
        }
        writer.writeTag(namespace, tagName, attList, false);
        StyleWriterUtility.writeBandStyles(writer, style);
        StyleWriterUtility.writePageBandStyles(writer, style);
        StyleWriterUtility.writeCommonStyles(writer, style);
        StyleWriterUtility.writeContentStyles(writer, style);
        StyleWriterUtility.writeTextStyles(writer, style);
        StyleWriterUtility.writeSpatialStyles(writer, style);
        StyleWriterUtility.writeBorderStyles(writer, style);
        writer.writeCloseTag();
    }

    public static void writeBorderStyles(XmlWriter writer, ElementStyleSheet style) throws IOException {
        double topRight;
        double topLeft;
        Object right;
        Object left;
        if (writer == null) {
            throw new NullPointerException();
        }
        if (style == null) {
            throw new NullPointerException();
        }
        AttributeList bandStyleAtts = new AttributeList();
        if (style.isLocalKey(ElementStyleKeys.BACKGROUND_COLOR)) {
            Color value = (Color)style.getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "background-color", ColorValueConverter.colorToString(value));
        }
        if (style.isLocalKey(ElementStyleKeys.PADDING_TOP) && style.isLocalKey(ElementStyleKeys.PADDING_LEFT) && style.isLocalKey(ElementStyleKeys.PADDING_BOTTOM) && style.isLocalKey(ElementStyleKeys.PADDING_RIGHT)) {
            double paddingTop = style.getDoubleStyleProperty(ElementStyleKeys.PADDING_TOP, 0.0);
            double paddingLeft = style.getDoubleStyleProperty(ElementStyleKeys.PADDING_LEFT, 0.0);
            double paddingBottom = style.getDoubleStyleProperty(ElementStyleKeys.PADDING_BOTTOM, 0.0);
            double paddingRight = style.getDoubleStyleProperty(ElementStyleKeys.PADDING_RIGHT, 0.0);
            if (paddingTop == paddingLeft && paddingTop == paddingRight && paddingTop == paddingBottom) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "padding", absoluteLengthFormat.format((Object)paddingTop));
            } else {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "padding-top", absoluteLengthFormat.format((Object)paddingTop));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "padding-left", absoluteLengthFormat.format((Object)paddingLeft));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "padding-bottom", absoluteLengthFormat.format((Object)paddingBottom));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "padding-right", absoluteLengthFormat.format((Object)paddingRight));
            }
        } else {
            if (style.isLocalKey(ElementStyleKeys.PADDING_TOP)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.PADDING_TOP, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "padding-top", absoluteLengthFormat.format((Object)value));
            }
            if (style.isLocalKey(ElementStyleKeys.PADDING_LEFT)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.PADDING_LEFT, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "padding-left", absoluteLengthFormat.format((Object)value));
            }
            if (style.isLocalKey(ElementStyleKeys.PADDING_BOTTOM)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.PADDING_BOTTOM, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "padding-bottom", absoluteLengthFormat.format((Object)value));
            }
            if (style.isLocalKey(ElementStyleKeys.PADDING_RIGHT)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.PADDING_RIGHT, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "padding-right", absoluteLengthFormat.format((Object)value));
            }
        }
        if (style.isLocalKey(ElementStyleKeys.BORDER_TOP_WIDTH) && style.isLocalKey(ElementStyleKeys.BORDER_LEFT_WIDTH) && style.isLocalKey(ElementStyleKeys.BORDER_BOTTOM_WIDTH) && style.isLocalKey(ElementStyleKeys.BORDER_RIGHT_WIDTH)) {
            double top = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_WIDTH, 0.0);
            double left2 = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_LEFT_WIDTH, 0.0);
            double bottom = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_WIDTH, 0.0);
            double right2 = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_RIGHT_WIDTH, 0.0);
            if (top == left2 && top == right2 && top == bottom) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-width", absoluteLengthFormat.format((Object)top));
            } else {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-top-width", absoluteLengthFormat.format((Object)top));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-left-width", absoluteLengthFormat.format((Object)left2));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-bottom-width", absoluteLengthFormat.format((Object)bottom));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-right-width", absoluteLengthFormat.format((Object)right2));
            }
        } else {
            if (style.isLocalKey(ElementStyleKeys.BORDER_TOP_WIDTH)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_WIDTH, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-top-width", absoluteLengthFormat.format((Object)value));
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_LEFT_WIDTH)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_LEFT_WIDTH, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-left-width", absoluteLengthFormat.format((Object)value));
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_BOTTOM_WIDTH)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_WIDTH, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-bottom-width", absoluteLengthFormat.format((Object)value));
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_RIGHT_WIDTH)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_RIGHT_WIDTH, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-right-width", absoluteLengthFormat.format((Object)value));
            }
        }
        if (style.isLocalKey(ElementStyleKeys.BORDER_BREAK_WIDTH)) {
            double value = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_BREAK_WIDTH, 0.0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-break-width", absoluteLengthFormat.format((Object)value));
        }
        if (style.isLocalKey(ElementStyleKeys.BORDER_TOP_COLOR) && style.isLocalKey(ElementStyleKeys.BORDER_LEFT_COLOR) && style.isLocalKey(ElementStyleKeys.BORDER_BOTTOM_COLOR) && style.isLocalKey(ElementStyleKeys.BORDER_RIGHT_COLOR)) {
            Color top = (Color)style.getStyleProperty(ElementStyleKeys.BORDER_TOP_COLOR);
            left = (Color)style.getStyleProperty(ElementStyleKeys.BORDER_LEFT_COLOR);
            Color bottom = (Color)style.getStyleProperty(ElementStyleKeys.BORDER_BOTTOM_COLOR);
            right = (Color)style.getStyleProperty(ElementStyleKeys.BORDER_RIGHT_COLOR);
            if (ObjectUtilities.equal((Object)top, (Object)left) && ObjectUtilities.equal((Object)top, (Object)right) && ObjectUtilities.equal((Object)top, (Object)bottom)) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-color", ColorValueConverter.colorToString(top));
            } else {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-top-color", ColorValueConverter.colorToString(top));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-left-color", ColorValueConverter.colorToString((Color)left));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-bottom-color", ColorValueConverter.colorToString(bottom));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-right-color", ColorValueConverter.colorToString((Color)right));
            }
        } else {
            if (style.isLocalKey(ElementStyleKeys.BORDER_TOP_COLOR)) {
                Color value = (Color)style.getStyleProperty(ElementStyleKeys.BORDER_TOP_COLOR);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-top-color", ColorValueConverter.colorToString(value));
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_LEFT_COLOR)) {
                Color value = (Color)style.getStyleProperty(ElementStyleKeys.BORDER_LEFT_COLOR);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-left-color", ColorValueConverter.colorToString(value));
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_BOTTOM_COLOR)) {
                Color value = (Color)style.getStyleProperty(ElementStyleKeys.BORDER_BOTTOM_COLOR);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-bottom-color", ColorValueConverter.colorToString(value));
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_RIGHT_COLOR)) {
                Color value = (Color)style.getStyleProperty(ElementStyleKeys.BORDER_RIGHT_COLOR);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-right-color", ColorValueConverter.colorToString(value));
            }
        }
        if (style.isLocalKey(ElementStyleKeys.BORDER_BREAK_COLOR)) {
            Color value = (Color)style.getStyleProperty(ElementStyleKeys.BORDER_BREAK_COLOR);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-break-color", ColorValueConverter.colorToString(value));
        }
        if (style.isLocalKey(ElementStyleKeys.BORDER_TOP_STYLE) && style.isLocalKey(ElementStyleKeys.BORDER_LEFT_STYLE) && style.isLocalKey(ElementStyleKeys.BORDER_BOTTOM_STYLE) && style.isLocalKey(ElementStyleKeys.BORDER_RIGHT_STYLE)) {
            Object top = style.getStyleProperty(ElementStyleKeys.BORDER_TOP_STYLE);
            left = style.getStyleProperty(ElementStyleKeys.BORDER_LEFT_STYLE);
            Object bottom = style.getStyleProperty(ElementStyleKeys.BORDER_BOTTOM_STYLE);
            right = style.getStyleProperty(ElementStyleKeys.BORDER_RIGHT_STYLE);
            if (ObjectUtilities.equal((Object)top, (Object)left) && ObjectUtilities.equal((Object)top, (Object)right) && ObjectUtilities.equal((Object)top, (Object)bottom)) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-style", top.toString());
            } else {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-top-style", top.toString());
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-left-style", left.toString());
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-bottom-style", bottom.toString());
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-right-style", right.toString());
            }
        } else {
            if (style.isLocalKey(ElementStyleKeys.BORDER_TOP_STYLE)) {
                Object value = style.getStyleProperty(ElementStyleKeys.BORDER_TOP_STYLE);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-top-style", value.toString());
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_LEFT_STYLE)) {
                Object value = style.getStyleProperty(ElementStyleKeys.BORDER_LEFT_STYLE);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-left-style", value.toString());
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_BOTTOM_STYLE)) {
                Object value = style.getStyleProperty(ElementStyleKeys.BORDER_BOTTOM_STYLE);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-bottom-style", value.toString());
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_RIGHT_STYLE)) {
                Object value = style.getStyleProperty(ElementStyleKeys.BORDER_RIGHT_STYLE);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-right-style", value.toString());
            }
        }
        if (style.isLocalKey(ElementStyleKeys.BORDER_BREAK_STYLE)) {
            Object value = style.getStyleProperty(ElementStyleKeys.BORDER_BREAK_STYLE);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-break-style", value.toString());
        }
        if (style.isLocalKey(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_WIDTH) && style.isLocalKey(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_WIDTH) && style.isLocalKey(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_WIDTH) && style.isLocalKey(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_WIDTH)) {
            double bottomLeft = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_WIDTH, 0.0);
            double bottomRight = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_WIDTH, 0.0);
            topLeft = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_WIDTH, 0.0);
            topRight = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_WIDTH, 0.0);
            if (bottomLeft == bottomRight && bottomLeft == topRight && bottomLeft == topLeft) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-radius-width", absoluteLengthFormat.format((Object)bottomLeft));
            } else {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-top-left-radius-width", absoluteLengthFormat.format((Object)topLeft));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-top-right-radius-width", absoluteLengthFormat.format((Object)topRight));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-bottom-left-radius-width", absoluteLengthFormat.format((Object)bottomLeft));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-bottom-right-radius-width", absoluteLengthFormat.format((Object)bottomRight));
            }
        } else {
            if (style.isLocalKey(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_WIDTH)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_WIDTH, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-top-left-width", absoluteLengthFormat.format((Object)value));
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_WIDTH)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_WIDTH, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-top-right-width", absoluteLengthFormat.format((Object)value));
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_WIDTH)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_WIDTH, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-bottom-left-width", absoluteLengthFormat.format((Object)value));
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_WIDTH)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_WIDTH, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-bottom-right-width", absoluteLengthFormat.format((Object)value));
            }
        }
        if (style.isLocalKey(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_HEIGHT) && style.isLocalKey(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_HEIGHT) && style.isLocalKey(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_HEIGHT) && style.isLocalKey(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_HEIGHT)) {
            double bottomLeft = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_HEIGHT, 0.0);
            double bottomRight = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_HEIGHT, 0.0);
            topLeft = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_HEIGHT, 0.0);
            topRight = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_HEIGHT, 0.0);
            if (bottomLeft == bottomRight && bottomLeft == topRight && bottomLeft == topLeft) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-radius-height", absoluteLengthFormat.format((Object)bottomLeft));
            } else {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-top-left-radius-height", absoluteLengthFormat.format((Object)topLeft));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-top-right-radius-height", absoluteLengthFormat.format((Object)topRight));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-bottom-left-radius-height", absoluteLengthFormat.format((Object)bottomLeft));
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-bottom-right-radius-height", absoluteLengthFormat.format((Object)bottomRight));
            }
        } else {
            if (style.isLocalKey(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_HEIGHT)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_HEIGHT, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-top-left-height", absoluteLengthFormat.format((Object)value));
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_HEIGHT)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_HEIGHT, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-top-right-height", absoluteLengthFormat.format((Object)value));
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_HEIGHT)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_HEIGHT, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-bottom-left-height", absoluteLengthFormat.format((Object)value));
            }
            if (style.isLocalKey(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_HEIGHT)) {
                double value = style.getDoubleStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_HEIGHT, 0.0);
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-bottom-right-height", absoluteLengthFormat.format((Object)value));
            }
        }
        if (!bandStyleAtts.isEmpty()) {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "border-styles", bandStyleAtts, true);
        }
    }

    public static void writeSpatialStyles(XmlWriter writer, ElementStyleSheet style) throws IOException {
        double value;
        if (writer == null) {
            throw new NullPointerException();
        }
        if (style == null) {
            throw new NullPointerException();
        }
        AttributeList bandStyleAtts = new AttributeList();
        if (style.isLocalKey(ElementStyleKeys.POS_X)) {
            value = style.getDoubleStyleProperty(ElementStyleKeys.POS_X, 0.0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "x", StyleWriterUtility.formatLength(value));
        }
        if (style.isLocalKey(ElementStyleKeys.POS_Y)) {
            value = style.getDoubleStyleProperty(ElementStyleKeys.POS_Y, 0.0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "y", StyleWriterUtility.formatLength(value));
        }
        if (style.isLocalKey(ElementStyleKeys.MIN_WIDTH)) {
            value = style.getDoubleStyleProperty(ElementStyleKeys.MIN_WIDTH, 0.0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "min-width", StyleWriterUtility.formatLength(value));
        }
        if (style.isLocalKey(ElementStyleKeys.MIN_HEIGHT)) {
            value = style.getDoubleStyleProperty(ElementStyleKeys.MIN_HEIGHT, 0.0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "min-height", StyleWriterUtility.formatLength(value));
        }
        if (style.isLocalKey(ElementStyleKeys.WIDTH)) {
            value = style.getDoubleStyleProperty(ElementStyleKeys.WIDTH, 0.0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "width", StyleWriterUtility.formatLength(value));
        }
        if (style.isLocalKey(ElementStyleKeys.HEIGHT)) {
            value = style.getDoubleStyleProperty(ElementStyleKeys.HEIGHT, 0.0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "height", StyleWriterUtility.formatLength(value));
        }
        if (style.isLocalKey(ElementStyleKeys.MAX_WIDTH)) {
            value = style.getDoubleStyleProperty(ElementStyleKeys.MAX_WIDTH, 0.0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "max-width", StyleWriterUtility.formatLength(value));
        }
        if (style.isLocalKey(ElementStyleKeys.MAX_HEIGHT)) {
            value = style.getDoubleStyleProperty(ElementStyleKeys.MAX_HEIGHT, 0.0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "max-height", StyleWriterUtility.formatLength(value));
        }
        if (!bandStyleAtts.isEmpty()) {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "spatial-styles", bandStyleAtts, true);
        }
    }

    public static void writeTextStyles(XmlWriter writer, ElementStyleSheet style) throws IOException {
        int value;
        String value2;
        if (writer == null) {
            throw new NullPointerException();
        }
        if (style == null) {
            throw new NullPointerException();
        }
        AttributeList bandStyleAtts = new AttributeList();
        if (style.isLocalKey(TextStyleKeys.FONT)) {
            value2 = (String)style.getStyleProperty(TextStyleKeys.FONT);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "font-face", value2);
        }
        if (style.isLocalKey(TextStyleKeys.BOLD)) {
            boolean value3 = style.getBooleanStyleProperty(TextStyleKeys.BOLD);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "bold", String.valueOf(value3));
        }
        if (style.isLocalKey(TextStyleKeys.ITALIC)) {
            boolean value4 = style.getBooleanStyleProperty(TextStyleKeys.ITALIC);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "italic", String.valueOf(value4));
        }
        if (style.isLocalKey(TextStyleKeys.EMBEDDED_FONT)) {
            boolean value5 = style.getBooleanStyleProperty(TextStyleKeys.EMBEDDED_FONT);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "embedded", String.valueOf(value5));
        }
        if (style.isLocalKey(TextStyleKeys.UNDERLINED)) {
            boolean value6 = style.getBooleanStyleProperty(TextStyleKeys.UNDERLINED);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "underline", String.valueOf(value6));
        }
        if (style.isLocalKey(TextStyleKeys.STRIKETHROUGH)) {
            boolean value7 = style.getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "strikethrough", String.valueOf(value7));
        }
        if (style.isLocalKey(ElementStyleKeys.EXCEL_WRAP_TEXT)) {
            boolean value8 = style.getBooleanStyleProperty(ElementStyleKeys.EXCEL_WRAP_TEXT);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "excel-text-wrapping", String.valueOf(value8));
        }
        if (style.isLocalKey(TextStyleKeys.TRIM_TEXT_CONTENT)) {
            boolean value9 = style.getBooleanStyleProperty(TextStyleKeys.TRIM_TEXT_CONTENT);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "trim-text-content", String.valueOf(value9));
        }
        if (style.isLocalKey(TextStyleKeys.FONTENCODING)) {
            value2 = (String)style.getStyleProperty(TextStyleKeys.FONTENCODING);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "encoding", value2);
        }
        if (style.isLocalKey(TextStyleKeys.RESERVED_LITERAL)) {
            value2 = (String)style.getStyleProperty(TextStyleKeys.RESERVED_LITERAL);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "ellipsis", value2);
        }
        if (style.isLocalKey(TextStyleKeys.FONTSIZE) && (value = style.getIntStyleProperty(TextStyleKeys.FONTSIZE, 0)) > 0) {
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "font-size", String.valueOf(value));
        }
        if (style.isLocalKey(TextStyleKeys.LINEHEIGHT)) {
            double value10 = style.getDoubleStyleProperty(TextStyleKeys.LINEHEIGHT, 0.0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "line-height", StyleWriterUtility.formatLength(value10));
        }
        if (style.isLocalKey(TextStyleKeys.WORD_SPACING)) {
            int value11 = style.getIntStyleProperty(TextStyleKeys.WORD_SPACING, 0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "word-spacing", String.valueOf(value11));
        }
        if (style.isLocalKey(TextStyleKeys.X_MIN_LETTER_SPACING)) {
            int value12 = style.getIntStyleProperty(TextStyleKeys.X_MIN_LETTER_SPACING, 0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "min-letter-spacing", String.valueOf(value12));
        }
        if (style.isLocalKey(TextStyleKeys.X_OPTIMUM_LETTER_SPACING)) {
            int value13 = style.getIntStyleProperty(TextStyleKeys.X_OPTIMUM_LETTER_SPACING, 0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "optimum-letter-spacing", String.valueOf(value13));
        }
        if (style.isLocalKey(TextStyleKeys.X_MAX_LETTER_SPACING)) {
            int value14 = style.getIntStyleProperty(TextStyleKeys.X_MAX_LETTER_SPACING, 0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "max-letter-spacing", String.valueOf(value14));
        }
        if (style.isLocalKey(TextStyleKeys.FONT_SMOOTH)) {
            Object value15 = style.getStyleProperty(TextStyleKeys.FONT_SMOOTH);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "font-smooth", value15.toString());
        }
        if (style.isLocalKey(TextStyleKeys.TEXT_WRAP)) {
            Object value16 = style.getStyleProperty(TextStyleKeys.TEXT_WRAP);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "text-wrap", value16.toString());
        }
        if (style.isLocalKey(TextStyleKeys.WHITE_SPACE_COLLAPSE)) {
            Object value17 = style.getStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "whitespace-collapse", value17.toString());
        }
        if (style.isLocalKey(TextStyleKeys.VERTICAL_TEXT_ALIGNMENT)) {
            Object value18 = style.getStyleProperty(TextStyleKeys.VERTICAL_TEXT_ALIGNMENT);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "whitespace-collapse", value18.toString());
        }
        if (style.isLocalKey(TextStyleKeys.TEXT_INDENT)) {
            double value19 = style.getDoubleStyleProperty(TextStyleKeys.TEXT_INDENT, 0.0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "text-indent", StyleWriterUtility.formatFloat(value19));
        }
        if (style.isLocalKey(TextStyleKeys.FIRST_LINE_INDENT)) {
            double value20 = style.getDoubleStyleProperty(TextStyleKeys.FIRST_LINE_INDENT, 0.0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "first-line-indent", StyleWriterUtility.formatFloat(value20));
        }
        if (!bandStyleAtts.isEmpty()) {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "text-styles", bandStyleAtts, true);
        }
    }

    public static void writeContentStyles(XmlWriter writer, ElementStyleSheet style) throws IOException {
        boolean value;
        if (writer == null) {
            throw new NullPointerException();
        }
        if (style == null) {
            throw new NullPointerException();
        }
        AttributeList bandStyleAtts = new AttributeList();
        if (style.isLocalKey(ElementStyleKeys.DRAW_SHAPE)) {
            value = style.getBooleanStyleProperty(ElementStyleKeys.DRAW_SHAPE);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "draw-shape", String.valueOf(value));
        }
        if (style.isLocalKey(ElementStyleKeys.FILL_SHAPE)) {
            value = style.getBooleanStyleProperty(ElementStyleKeys.FILL_SHAPE);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "fill-shape", String.valueOf(value));
        }
        if (style.isLocalKey(ElementStyleKeys.SCALE)) {
            value = style.getBooleanStyleProperty(ElementStyleKeys.SCALE);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "scale", String.valueOf(value));
        }
        if (style.isLocalKey(ElementStyleKeys.KEEP_ASPECT_RATIO)) {
            value = style.getBooleanStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "keep-aspect-ratio", String.valueOf(value));
        }
        if (style.isLocalKey(ElementStyleKeys.DYNAMIC_HEIGHT)) {
            value = style.getBooleanStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "dynamic-height", String.valueOf(value));
        }
        if (style.isLocalKey(ElementStyleKeys.PAINT)) {
            Color value2 = (Color)style.getStyleProperty(ElementStyleKeys.PAINT);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "color", ColorValueConverter.colorToString(value2));
        }
        if (style.isLocalKey(ElementStyleKeys.FILL_COLOR)) {
            Color value3 = (Color)style.getStyleProperty(ElementStyleKeys.FILL_COLOR);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "fill-color", ColorValueConverter.colorToString(value3));
        }
        if (style.isLocalKey(ElementStyleKeys.EXCEL_DATA_FORMAT_STRING)) {
            String value4 = (String)style.getStyleProperty(ElementStyleKeys.EXCEL_DATA_FORMAT_STRING);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "excel-cell-format", value4);
        }
        if (style.isLocalKey(ElementStyleKeys.ANTI_ALIASING)) {
            boolean value5 = style.getBooleanStyleProperty(ElementStyleKeys.ANTI_ALIASING);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "anti-aliasing", String.valueOf(value5));
        }
        if (style.isLocalKey(ElementStyleKeys.STROKE)) {
            Stroke s = (Stroke)style.getStyleProperty(ElementStyleKeys.STROKE);
            float strokeWidth = StrokeUtility.getStrokeWidth(s);
            BorderStyle strokeType = StrokeUtility.translateStrokeStyle(s);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "stroke-weight", absoluteLengthFormat.format((Object)Float.valueOf(strokeWidth)));
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "stroke-style", strokeType.toString());
        }
        if (!bandStyleAtts.isEmpty()) {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "content-styles", bandStyleAtts, true);
        }
    }

    public static void writeCommonStyles(XmlWriter writer, ElementStyleSheet style) throws IOException {
        int value;
        Object value2;
        if (writer == null) {
            throw new NullPointerException();
        }
        if (style == null) {
            throw new NullPointerException();
        }
        AttributeList bandStyleAtts = new AttributeList();
        if (style.isLocalKey(ElementStyleKeys.ANCHOR_NAME)) {
            value2 = (String)style.getStyleProperty(ElementStyleKeys.ANCHOR_NAME);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "anchor-name", (String)value2);
        }
        if (style.isLocalKey(ElementStyleKeys.HREF_TARGET)) {
            value2 = (String)style.getStyleProperty(ElementStyleKeys.HREF_TARGET);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "href-target", (String)value2);
        }
        if (style.isLocalKey(ElementStyleKeys.HREF_TITLE)) {
            value2 = (String)style.getStyleProperty(ElementStyleKeys.HREF_TITLE);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "href-title", (String)value2);
        }
        if (style.isLocalKey(ElementStyleKeys.HREF_WINDOW)) {
            value2 = (String)style.getStyleProperty(ElementStyleKeys.HREF_WINDOW);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "href-window", (String)value2);
        }
        if (style.isLocalKey(ElementStyleKeys.BOX_SIZING)) {
            value2 = (BoxSizing)style.getStyleProperty(ElementStyleKeys.BOX_SIZING);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "box-sizing", ((BoxSizing)value2).toString());
        }
        if (style.isLocalKey(ElementStyleKeys.VISIBLE)) {
            boolean value3 = style.getBooleanStyleProperty(ElementStyleKeys.VISIBLE);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "visible", String.valueOf(value3));
        }
        if (style.isLocalKey(ElementStyleKeys.INVISIBLE_CONSUMES_SPACE)) {
            boolean value4 = style.getBooleanStyleProperty(ElementStyleKeys.INVISIBLE_CONSUMES_SPACE);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "invisible-consumes-space", String.valueOf(value4));
        }
        if (style.isLocalKey(ElementStyleKeys.WIDOWS) && (value = style.getIntStyleProperty(ElementStyleKeys.WIDOWS, -1)) >= 0) {
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "widows", String.valueOf(value));
        }
        if (style.isLocalKey(ElementStyleKeys.ORPHANS) && (value = style.getIntStyleProperty(ElementStyleKeys.ORPHANS, -1)) >= 0) {
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "orphans", String.valueOf(value));
        }
        if (style.isLocalKey(ElementStyleKeys.OVERFLOW_X)) {
            boolean value5 = style.getBooleanStyleProperty(ElementStyleKeys.OVERFLOW_X);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "overflow-x", String.valueOf(value5));
        }
        if (style.isLocalKey(ElementStyleKeys.OVERFLOW_Y)) {
            boolean value6 = style.getBooleanStyleProperty(ElementStyleKeys.OVERFLOW_Y);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "overflow-y", String.valueOf(value6));
        }
        if (style.isLocalKey(ElementStyleKeys.AVOID_PAGEBREAK_INSIDE)) {
            boolean value7 = style.getBooleanStyleProperty(ElementStyleKeys.AVOID_PAGEBREAK_INSIDE);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "avoid-page-break", String.valueOf(value7));
        }
        if (style.isLocalKey(ElementStyleKeys.ALIGNMENT)) {
            ElementAlignment value8 = (ElementAlignment)style.getStyleProperty(ElementStyleKeys.ALIGNMENT);
            if (ElementAlignment.CENTER.equals(value8)) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "alignment", "center");
            } else if (ElementAlignment.RIGHT.equals(value8)) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "alignment", "right");
            } else if (ElementAlignment.JUSTIFY.equals(value8)) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "alignment", "justify");
            } else if (ElementAlignment.LEFT.equals(value8)) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "alignment", "left");
            }
        }
        if (style.isLocalKey(ElementStyleKeys.VALIGNMENT)) {
            ElementAlignment value9 = (ElementAlignment)style.getStyleProperty(ElementStyleKeys.VALIGNMENT);
            if (ElementAlignment.MIDDLE.equals(value9)) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "vertical-alignment", "middle");
            } else if (ElementAlignment.BOTTOM.equals(value9)) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "vertical-alignment", "bottom");
            } else if (ElementAlignment.TOP.equals(value9)) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "vertical-alignment", "top");
            }
        }
        if (!bandStyleAtts.isEmpty()) {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "common-styles", bandStyleAtts, true);
        }
    }

    public static void writePageBandStyles(XmlWriter writer, ElementStyleSheet style) throws IOException {
        boolean value;
        if (writer == null) {
            throw new NullPointerException();
        }
        if (style == null) {
            throw new NullPointerException();
        }
        AttributeList bandStyleAtts = new AttributeList();
        if (style.isLocalKey(BandStyleKeys.REPEAT_HEADER)) {
            value = style.getBooleanStyleProperty(BandStyleKeys.REPEAT_HEADER);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "repeat", String.valueOf(value));
        }
        if (style.isLocalKey(BandStyleKeys.DISPLAY_ON_FIRSTPAGE)) {
            value = style.getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "display-on-first-page", String.valueOf(value));
        }
        if (style.isLocalKey(BandStyleKeys.DISPLAY_ON_LASTPAGE)) {
            value = style.getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "display-on-last-page", String.valueOf(value));
        }
        if (style.isLocalKey(BandStyleKeys.STICKY)) {
            value = style.getBooleanStyleProperty(BandStyleKeys.STICKY);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "sticky", String.valueOf(value));
        }
        if (style.isLocalKey(BandStyleKeys.FIXED_POSITION)) {
            double value2 = style.getDoubleStyleProperty(BandStyleKeys.FIXED_POSITION, 0.0);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "fixed-position", StyleWriterUtility.formatLength(value2));
        }
        if (!bandStyleAtts.isEmpty()) {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "page-band-styles", bandStyleAtts, true);
        }
    }

    private static String formatFloat(double value) {
        return absoluteLengthFormat.format((Object)value);
    }

    private static String formatLength(double value) {
        if (value >= 0.0) {
            return absoluteLengthFormat.format((Object)value);
        }
        return percentageLengthFormat.format((Object)(-value));
    }

    public static void writeBandStyles(XmlWriter writer, ElementStyleSheet style) throws IOException {
        String value;
        if (writer == null) {
            throw new NullPointerException();
        }
        if (style == null) {
            throw new NullPointerException();
        }
        AttributeList bandStyleAtts = new AttributeList();
        if (style.isLocalKey(BandStyleKeys.COMPUTED_SHEETNAME)) {
            value = (String)style.getStyleProperty(BandStyleKeys.COMPUTED_SHEETNAME);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "computed-sheetname", value);
        }
        if (style.isLocalKey(BandStyleKeys.BOOKMARK)) {
            value = (String)style.getStyleProperty(BandStyleKeys.BOOKMARK);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "bookmark", value);
        }
        if (style.isLocalKey(BandStyleKeys.PAGEBREAK_BEFORE)) {
            boolean value2 = style.getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "pagebreak-before", String.valueOf(value2));
        }
        if (style.isLocalKey(BandStyleKeys.PAGEBREAK_AFTER)) {
            boolean value3 = style.getBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "pagebreak-after", String.valueOf(value3));
        }
        if (style.isLocalKey(BandStyleKeys.LAYOUT)) {
            String value4 = (String)style.getStyleProperty(BandStyleKeys.LAYOUT);
            bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "layout", String.valueOf(value4));
        } else if (style.isLocalKey(BandLayoutManager.LAYOUTMANAGER)) {
            logger.warn((Object)"Converted old 'layout-manager' style definition into the new 'layout' style.");
            Object value5 = style.getStyleProperty(BandLayoutManager.LAYOUTMANAGER);
            if (value5 instanceof StaticLayoutManager) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "layout", "canvas");
            } else if (value5 instanceof StackedLayoutManager) {
                bandStyleAtts.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "layout", "block");
            }
        }
        if (!bandStyleAtts.isEmpty()) {
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "band-styles", bandStyleAtts, true);
        }
    }

    public static String computeParentStyleList(ElementStyleSheet styleSheet) {
        if (styleSheet == null) {
            throw new NullPointerException();
        }
        ElementStyleSheet[] sheets = styleSheet.getParents();
        CSVQuoter quoter = new CSVQuoter(' ', '\'');
        StringBuffer parents = null;
        for (int i = 0; i < sheets.length; ++i) {
            ElementStyleSheet sheet = sheets[i];
            if (sheet.isGlobalDefault()) continue;
            if (parents == null) {
                parents = new StringBuffer(sheets.length * 30);
            }
            String quoted = quoter.doQuoting(sheet.getName());
            if (parents.length() > 0) {
                parents.append(' ');
            }
            parents.append(quoted);
        }
        if (parents == null) {
            return null;
        }
        return parents.toString();
    }
}

