/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.elements;

import java.beans.IntrospectionException;
import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleElementWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleElementWriterFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.ExpressionWriterUtility;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.elements.AbstractElementWriteHandler;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class ReportDefinitionWriteHandler
extends AbstractElementWriteHandler {
    public void writeElement(WriteableDocumentBundle bundle, BundleWriterState state, XmlWriter xmlWriter, Element element) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        if (xmlWriter == null) {
            throw new NullPointerException();
        }
        if (!(element instanceof AbstractReportDefinition)) {
            throw new IllegalArgumentException();
        }
        AttributeList rootAttributes = new AttributeList();
        rootAttributes.addNamespaceDeclaration("", "http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0");
        rootAttributes.addNamespaceDeclaration("style", "http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0");
        rootAttributes.addNamespaceDeclaration("core", "http://reporting.pentaho.org/namespaces/engine/attributes/core");
        rootAttributes.addNamespaceDeclaration("html", "http://reporting.pentaho.org/namespaces/engine/attributes/html");
        rootAttributes.addNamespaceDeclaration("swing", "http://reporting.pentaho.org/namespaces/engine/attributes/swing");
        rootAttributes.addNamespaceDeclaration("pdf", "http://reporting.pentaho.org/namespaces/engine/attributes/pdf");
        rootAttributes.addNamespaceDeclaration("wizard", "http://reporting.pentaho.org/namespaces/engine/attributes/wizard");
        AttributeList attList = this.createMainAttributes(element, xmlWriter, rootAttributes);
        xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "layout", attList, false);
        AbstractReportDefinition report = (AbstractReportDefinition)element;
        ReportPreProcessor[] processors = report.getPreProcessors();
        for (int i = 0; i < processors.length; ++i) {
            ReportPreProcessor processor = processors[i];
            try {
                xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "preprocessor", "class", processor.getClass().getName(), false);
                this.writePreProcessor(xmlWriter, processor);
                xmlWriter.writeCloseTag();
                continue;
            }
            catch (IntrospectionException e) {
                throw new BundleWriterException("Failed to write pre-processor", e);
            }
            catch (BeanException e) {
                throw new BundleWriterException("Failed to write pre-processor", (Exception)((Object)e));
            }
        }
        if (ExpressionWriterUtility.isElementLayoutExpressionActive(state)) {
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "layout-processors", false);
            ExpressionWriterUtility.writeElementLayoutExpressions(bundle, state, xmlWriter);
            xmlWriter.writeCloseTag();
        }
        this.writeElementBody(bundle, state, element, xmlWriter);
        this.writeChildElement(bundle, state, xmlWriter, report.getReportHeader());
        this.writeChildElement(bundle, state, xmlWriter, report.getRootGroup());
        this.writeChildElement(bundle, state, xmlWriter, report.getReportFooter());
        xmlWriter.writeCloseTag();
    }

    private void writeChildElement(WriteableDocumentBundle bundle, BundleWriterState state, XmlWriter xmlWriter, Element re) throws IOException, BundleWriterException {
        BundleElementWriteHandler writeHandler = BundleElementWriterFactory.createHandler(re);
        writeHandler.writeElement(bundle, state, xmlWriter, re);
    }

    private void writePreProcessor(XmlWriter writer, ReportPreProcessor preProcessor) throws IntrospectionException, BeanException, IOException {
        if (writer == null) {
            throw new NullPointerException();
        }
        if (preProcessor == null) {
            throw new NullPointerException();
        }
        BeanUtility beanUtility = new BeanUtility(preProcessor);
        String[] propertyNames = beanUtility.getProperties();
        for (int i = 0; i < propertyNames.length; ++i) {
            String key = propertyNames[i];
            Object property = beanUtility.getProperty(key);
            Class propertyType = beanUtility.getPropertyType(key);
            String value = beanUtility.getPropertyAsString(key);
            if (value == null || property == null) continue;
            AttributeList attList = new AttributeList();
            attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "name", key);
            if (!BeanUtility.isSameType(propertyType, property.getClass())) {
                attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "class", property.getClass().getName());
            }
            writer.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "property", attList, false);
            writer.writeTextNormalized(value, false);
            writer.writeCloseTag();
        }
    }

    protected boolean isFiltered(AttributeMetaData attributeMetaData) {
        if ("http://reporting.pentaho.org/namespaces/engine/attributes/internal".equals(attributeMetaData.getNameSpace())) {
            if ("query".equals(attributeMetaData.getName())) {
                return true;
            }
            if ("query-limit".equals(attributeMetaData.getName())) {
                return true;
            }
            if ("query-timeout".equals(attributeMetaData.getName())) {
                return true;
            }
            if ("pre-processors".equals(attributeMetaData.getName())) {
                return true;
            }
            if ("structure-functions".equals(attributeMetaData.getName())) {
                return true;
            }
        } else if ("http://reporting.pentaho.org/namespaces/engine/attributes/pentaho".equals(attributeMetaData.getNameSpace()) && "visible".equals(attributeMetaData.getName())) {
            return true;
        }
        return super.isFiltered(attributeMetaData);
    }
}

