/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.data.inlinedata;

import org.pentaho.reporting.engine.classic.core.modules.parser.base.compat.CompatibilityMapperUtil;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.StringReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InlineTableDataReadHandler
extends StringReadHandler {
    private Class type;
    private boolean nullValue;
    private Object value;

    public InlineTableDataReadHandler(Class type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.type = type;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        String type;
        super.startParsing(attrs);
        if ("true".equals(attrs.getValue(this.getUri(), "null"))) {
            this.nullValue = true;
        }
        if ((type = attrs.getValue(this.getUri(), "type")) != null) {
            try {
                ClassLoader loader = ObjectUtilities.getClassLoader(AbstractXmlReadHandler.class);
                this.type = Class.forName(CompatibilityMapperUtil.mapClassName(type), false, loader);
            }
            catch (ClassNotFoundException e) {
                throw new ParseException("Required attribute 'type' is not valid.", this.getLocator());
            }
        }
    }

    protected void doneParsing() throws SAXException {
        super.doneParsing();
        if (this.nullValue) {
            this.value = null;
            return;
        }
        try {
            this.value = ConverterRegistry.toPropertyValue(this.getResult(), this.type);
        }
        catch (BeanException e) {
            try {
                this.value = ConverterRegistry.toPropertyValue(this.getResult().trim(), this.type);
            }
            catch (BeanException ex) {
                throw new ParseException("Unable to convert value '" + this.getResult() + "' into a object of type '" + this.type + "'.", (Exception)((Object)ex), this.getLocator());
            }
        }
    }

    public Object getObject() {
        return this.value;
    }
}

